/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.PrinterKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0006\u0010\f\u001a\u00020\nJ\u001f\u0010\r\u001a\u00020\n2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000f\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\nH\u0002J!\u0010\u0013\u001a\u00020\n2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000f\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\n2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000f\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0015\u001a\u00020\nJ.\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/Printer;", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "indentUnit", "", "indent", "(Ljava/lang/Appendable;Ljava/lang/String;Ljava/lang/String;)V", "append", "", "s", "popIndent", "print", "strings", "", "([Ljava/lang/String;)V", "printIndent", "printLineSeparator", "printWithNoIndent", "println", "pushIndent", "withIndent", "T", "headLine", "fn", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin"})
public final class Printer {
    @NotNull
    private final Appendable out;
    @NotNull
    private final String indentUnit;
    @NotNull
    private String indent;

    public Printer(@NotNull Appendable out, @NotNull String indentUnit, @NotNull String indent) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)indentUnit, (String)"indentUnit");
        Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
        this.out = out;
        this.indentUnit = indentUnit;
        this.indent = indent;
    }

    public /* synthetic */ Printer(Appendable appendable, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "  ";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(appendable, string, string2);
    }

    private final void append(String s) {
        try {
            this.out.append(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void println(String ... strings) {
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        this.print(Arrays.copyOf(strings, strings.length));
        this.printLineSeparator();
    }

    private final void printLineSeparator() {
        String string = PrinterKt.access$getLINE_SEPARATOR$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LINE_SEPARATOR");
        this.append(string);
    }

    public final void print(String ... strings) {
        Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
        String[] stringArray = strings;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (!(stringArray2.length == 0)) {
            this.printIndent();
        }
        this.printWithNoIndent(Arrays.copyOf(strings, strings.length));
    }

    private final void printIndent() {
        this.append(this.indent);
    }

    private final void printWithNoIndent(String ... strings) {
        for (String s : strings) {
            this.append(s);
        }
    }

    public final void pushIndent() {
        Printer printer = this;
        printer.indent = Intrinsics.stringPlus((String)printer.indent, (Object)this.indentUnit);
    }

    public final void popIndent() {
        boolean bl = this.indent.length() >= this.indentUnit.length();
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "No indentation to pop";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = this.indent;
        n = this.indentUnit.length();
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        this.indent = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withIndent(@Nullable String headLine, @NotNull Function0<? extends T> fn) {
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        boolean $i$f$withIndent = false;
        if (headLine != null) {
            stringArray = new String[]{headLine};
            this.println(stringArray);
        }
        this.pushIndent();
        try {
            stringArray = fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.popIndent();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object withIndent$default(Printer this_, String headLine, Function0 fn, int n, Object stringArray) {
        if ((n & 1) != 0) {
            headLine = null;
        }
        Intrinsics.checkParameterIsNotNull((Object)fn, (String)"fn");
        boolean $i$f$withIndent = false;
        if (headLine != null) {
            stringArray = new String[]{headLine};
            this_.println(stringArray);
        }
        this_.pushIndent();
        try {
            stringArray = fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_.popIndent();
            InlineMarker.finallyEnd((int)1);
        }
        return stringArray;
    }
}

