/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0000\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a&\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\n\u0010/\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u001a\u00100\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0001H\u0002\u001a\u0014\u00102\u001a\u000203*\u00020\u00162\u0006\u00104\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"DAEMON_EXPECTED_CLASS", "", "K2JS_COMPILER_CLASS", "K2JS_DCE_CLASS", "K2JVM_COMPILER_CLASS", "K2METADATA_COMPILER_CLASS", "KOTLIN_COMPILER_EMBEDDABLE", "KOTLIN_GRADLE_PLUGIN", "KOTLIN_JVM_SCRIPT_COMPILER_EXPECTED_CLASS", "KOTLIN_KLIB_COMMONIZER_EMBEDDABLE", "KOTLIN_MODULE_GROUP", "KOTLIN_REFLECT", "KOTLIN_REFLECT_EXPECTED_CLASS", "KOTLIN_SCRIPT_ANNOTATION_EXPECTED_CLASS", "KOTLIN_SCRIPT_COMMON", "KOTLIN_SCRIPT_JVM", "KOTLIN_SCRIPT_RUNTIME", "KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS", "KOTLIN_STDLIB", "KOTLIN_STDLIB_EXPECTED_CLASS", "TROVE4J_EXPECTED_CLASS", "findDaemon", "Ljava/io/File;", "findJarByClass", "klass", "Ljava/lang/Class;", "classFqName", "findKotlinCompilerClasspath", "", "project", "Lorg/gradle/api/Project;", "findKotlinJsCompilerClasspath", "findKotlinJsDceClasspath", "findKotlinJvmCompilerClasspath", "findKotlinMetadataCompilerClasspath", "findKotlinModuleDependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "moduleId", "findKotlinModuleJar", "expectedClassName", "findKotlinReflectClasspath", "findKotlinScriptRuntimeClasspath", "findKotlinStdlibClasspath", "findPotentialModuleJars", "", "findTrove4j", "getModuleFromClassLoader", "moduleVersion", "hasEntry", "", "entryToFind", "kotlin-gradle-plugin"})
public final class JarSearchingUtilKt {
    @NotNull
    private static final String K2JVM_COMPILER_CLASS = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    @NotNull
    private static final String K2JS_COMPILER_CLASS = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    @NotNull
    private static final String K2JS_DCE_CLASS = "org.jetbrains.kotlin.cli.js.dce.K2JSDce";
    @NotNull
    private static final String K2METADATA_COMPILER_CLASS = "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler";
    @NotNull
    private static final String KOTLIN_STDLIB_EXPECTED_CLASS = "kotlin.collections.ArraysKt";
    @NotNull
    private static final String KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS = "kotlin.script.templates.AnnotationsKt";
    @NotNull
    private static final String KOTLIN_SCRIPT_ANNOTATION_EXPECTED_CLASS = "kotlin.script.experimental.annotations.KotlinScript";
    @NotNull
    private static final String KOTLIN_JVM_SCRIPT_COMPILER_EXPECTED_CLASS = "kotlin.script.experimental.jvm.JvmScriptCompiler";
    @NotNull
    private static final String KOTLIN_REFLECT_EXPECTED_CLASS = "kotlin.reflect.full.KClasses";
    @NotNull
    private static final String TROVE4J_EXPECTED_CLASS = "gnu.trove.THashMap";
    @NotNull
    private static final String DAEMON_EXPECTED_CLASS = "org.jetbrains.kotlin.daemon.CompileServiceImpl";
    @NotNull
    public static final String KOTLIN_MODULE_GROUP = "org.jetbrains.kotlin";
    @NotNull
    private static final String KOTLIN_GRADLE_PLUGIN = "kotlin-gradle-plugin";
    @NotNull
    public static final String KOTLIN_COMPILER_EMBEDDABLE = "kotlin-compiler-embeddable";
    @NotNull
    private static final String KOTLIN_STDLIB = "kotlin-stdlib";
    @NotNull
    private static final String KOTLIN_SCRIPT_RUNTIME = "kotlin-script-runtime";
    @NotNull
    private static final String KOTLIN_SCRIPT_COMMON = "kotlin-scripting-common";
    @NotNull
    private static final String KOTLIN_SCRIPT_JVM = "kotlin-scripting-jvm";
    @NotNull
    private static final String KOTLIN_REFLECT = "kotlin-reflect";
    @NotNull
    public static final String KOTLIN_KLIB_COMMONIZER_EMBEDDABLE = "kotlin-klib-commonizer-embeddable";

    @NotNull
    public static final List<File> findKotlinJvmCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2JVM_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinJsCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2JS_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinMetadataCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2METADATA_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinJsDceClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2JS_DCE_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object[] objectArray = new File[]{JarSearchingUtilKt.findTrove4j(), JarSearchingUtilKt.findDaemon()};
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)JarSearchingUtilKt.findKotlinStdlibClasspath(project), (Iterable)JarSearchingUtilKt.findKotlinScriptRuntimeClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinReflectClasspath(project)), (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    @Nullable
    public static final File findJarByClass(@NotNull String classFqName) {
        Class clazz;
        Intrinsics.checkParameterIsNotNull((Object)classFqName, (String)"classFqName");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = classLoader.loadClass(classFqName);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        Class clazz2 = clazz;
        if (clazz2 == null) {
            return null;
        }
        Class classFromJar = clazz2;
        return JarSearchingUtilKt.findJarByClass(classFromJar);
    }

    @Nullable
    public static final File findTrove4j() {
        return JarSearchingUtilKt.findJarByClass(TROVE4J_EXPECTED_CLASS);
    }

    @Nullable
    public static final File findDaemon() {
        return JarSearchingUtilKt.findJarByClass(DAEMON_EXPECTED_CLASS);
    }

    @NotNull
    public static final List<File> findKotlinStdlibClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_STDLIB_EXPECTED_CLASS, KOTLIN_STDLIB);
    }

    @NotNull
    public static final List<File> findKotlinScriptRuntimeClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS, KOTLIN_SCRIPT_RUNTIME);
    }

    @NotNull
    public static final List<File> findKotlinReflectClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_REFLECT_EXPECTED_CLASS, KOTLIN_REFLECT);
    }

    @Nullable
    public static final File findJarByClass(@NotNull Class<?> klass) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        String string = klass.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"klass.name");
        String classFileName = Intrinsics.stringPlus((String)StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null), (Object)".class");
        URL uRL = klass.getResource(classFileName);
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String string2 = resource.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resource.toString()");
        String uri = string2;
        if (!StringsKt.startsWith$default((String)uri, (String)"jar:file:", (boolean)false, (int)2, null)) {
            return null;
        }
        String fileName = URLDecoder.decode(StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)uri, (CharSequence)"jar:file:"), (String)"!", null, (int)2, null), Charset.defaultCharset().name());
        return new File(fileName);
    }

    private static final List<File> findKotlinModuleJar(Project project, String expectedClassName, String moduleId) {
        List list2;
        Object v0;
        block4: {
            String pluginVersion = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
            Object[] objectArray = new File[]{JarSearchingUtilKt.getModuleFromClassLoader(moduleId, pluginVersion)};
            boolean bl = false;
            Sequence filesToCheck = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Sequence)((Sequence)new Sequence<File>(project, moduleId){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $moduleId$inlined;
                {
                    this.$project$inlined = project;
                    this.$moduleId$inlined = string;
                }

                @NotNull
                public Iterator<File> iterator() {
                    boolean bl = false;
                    return JarSearchingUtilKt.access$findPotentialModuleJars(this.$project$inlined, this.$moduleId$inlined).iterator();
                }
            }));
            String entryToFind = Intrinsics.stringPlus((String)StringsKt.replace$default((String)expectedClassName, (String)".", (String)"/", (boolean)false, (int)4, null), (Object)".class");
            Sequence $this$firstOrNull$iv = SequencesKt.filterNotNull((Sequence)filesToCheck);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                if (!JarSearchingUtilKt.hasEntry(it, entryToFind)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        File file = v0;
        if (file == null) {
            list2 = null;
        } else {
            File file2 = file;
            boolean bl = false;
            boolean bl3 = false;
            File it = file2;
            boolean bl4 = false;
            list2 = CollectionsKt.listOf((Object)it);
        }
        file = list2;
        boolean bl = false;
        Object object = file;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final File getModuleFromClassLoader(String moduleId, String moduleVersion) {
        Object object;
        Object v1;
        Object object2;
        Object object3;
        block4: {
            void $this$firstOrNull$iv;
            object3 = KotlinPlugin.class.getClassLoader();
            Object object4 = object2 = object3 instanceof URLClassLoader ? (URLClassLoader)object3 : null;
            if (object2 == null) {
                return null;
            }
            URLClassLoader urlClassLoader = object2;
            object3 = urlClassLoader.getURLs();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"urlClassLoader.urLs");
            object3 = (Object[])object3;
            boolean $i$f$firstOrNull = false;
            for (void element$iv : $this$firstOrNull$iv) {
                URL it = (URL)element$iv;
                boolean bl = false;
                String string = it.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                if (!StringsKt.endsWith$default((String)string, (String)(moduleId + '-' + moduleVersion + ".jar"), (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        object2 = v1;
        if (object2 == null) {
            object = null;
        } else {
            Object object5 = object2;
            boolean bl = false;
            int n = 0;
            Object it = object5;
            boolean bl2 = false;
            object5 = object3 = new File(((URL)it).toURI());
            bl = false;
            n = 0;
            Object p0 = object5;
            boolean bl3 = false;
            object = ((File)p0).exists() ? object5 : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable<File> findPotentialModuleJars(Project project, String moduleId) {
        Sequence projects2 = SequencesKt.generateSequence((Object)project, (Function1)findPotentialModuleJars.projects.1.INSTANCE);
        Sequence classpathConfigurations2 = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)projects2, (Function1)findPotentialModuleJars.classpathConfigurations.1.INSTANCE));
        HashSet allFiles = new HashSet();
        for (Configuration configuration2 : classpathConfigurations2) {
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
            ResolvedDependency compilerEmbeddable = JarSearchingUtilKt.findKotlinModuleDependency(configuration2, moduleId);
            if (compilerEmbeddable != null) {
                void $this$mapTo$iv$iv;
                Set set2 = compilerEmbeddable.getModuleArtifacts();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"compilerEmbeddable.moduleArtifacts");
                Iterable $this$map$iv = set2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    File file = it.getFile();
                    collection.add(file);
                }
                return (List)destination$iv$iv;
            }
            allFiles.addAll(configuration2.getFiles());
        }
        return allFiles;
    }

    private static final ResolvedDependency findKotlinModuleDependency(Configuration configuration2, String moduleId) {
        Set set2;
        ResolvedDependency gradlePlugin;
        Set firstLevelModuleDependencies = configuration2.getResolvedConfiguration().getFirstLevelModuleDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)firstLevelModuleDependencies, (String)"firstLevelModuleDependencies");
        ResolvedDependency resolvedDependency = gradlePlugin = JarSearchingUtilKt.findKotlinModuleDependency$findDependency(firstLevelModuleDependencies, KOTLIN_MODULE_GROUP, KOTLIN_GRADLE_PLUGIN);
        return resolvedDependency == null ? null : ((set2 = resolvedDependency.getChildren()) == null ? null : JarSearchingUtilKt.findKotlinModuleDependency$findDependency(set2, KOTLIN_MODULE_GROUP, moduleId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean hasEntry(File $this$hasEntry, String entryToFind) {
        try (ZipFile zip = new ZipFile($this$hasEntry);){
            boolean bl = zip.getEntry(entryToFind) != null;
            return bl;
        }
    }

    private static final ResolvedDependency findKotlinModuleDependency$findDependency(Iterable<? extends ResolvedDependency> $this$findKotlinModuleDependency_u24findDependency, String group2, String name2) {
        ResolvedDependency resolvedDependency;
        block1: {
            Iterable<? extends ResolvedDependency> iterable = $this$findKotlinModuleDependency_u24findDependency;
            boolean bl = false;
            Iterable<? extends ResolvedDependency> iterable2 = iterable;
            boolean bl2 = false;
            Iterator<? extends ResolvedDependency> iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                ResolvedDependency resolvedDependency2;
                ResolvedDependency it = resolvedDependency2 = iterator.next();
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getModuleGroup(), (Object)group2) && Intrinsics.areEqual((Object)it.getModuleName(), (Object)name2))) continue;
                resolvedDependency = resolvedDependency2;
                break block1;
            }
            resolvedDependency = null;
        }
        return resolvedDependency;
    }

    public static final /* synthetic */ Iterable access$findPotentialModuleJars(Project project, String moduleId) {
        return JarSearchingUtilKt.findPotentialModuleJars(project, moduleId);
    }
}

