/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.backend.jvm.lower

import org.jetbrains.kotlin.backend.common.lower.InitializersCleanupLowering
import org.jetbrains.kotlin.backend.common.lower.InitializersLowering
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext
import org.jetbrains.kotlin.backend.jvm.ir.constantValue

/**
 * Merges init blocks and field initializers into constructors.
 */
@PhaseDescription(
    name = "Initializers",
    // Depends on local class extraction, because otherwise local classes in initializers will be copied into each constructor.
    prerequisite = [JvmLocalClassPopupLowering::class]
)
internal class JvmInitializersLowering(context: JvmBackendContext) : InitializersLowering(context)

/**
 * Removes non-static anonymous initializers and non-constant non-static field init expressions.
 */
@PhaseDescription(
    name = "InitializersCleanup",
    prerequisite = [JvmInitializersLowering::class]
)
internal class JvmInitializersCleanupLowering(context: JvmBackendContext) : InitializersCleanupLowering(
    context,
    {
        it.constantValue() == null && (!it.isStatic || it.correspondingPropertySymbol?.owner?.isConst != true)
    }
)
