/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.abi.AbiClass;
import org.jetbrains.kotlin.library.abi.AbiClassKind;
import org.jetbrains.kotlin.library.abi.AbiClassifierReference;
import org.jetbrains.kotlin.library.abi.AbiCompoundName;
import org.jetbrains.kotlin.library.abi.AbiDeclaration;
import org.jetbrains.kotlin.library.abi.AbiDeclarationContainer;
import org.jetbrains.kotlin.library.abi.AbiDeclarationWithModality;
import org.jetbrains.kotlin.library.abi.AbiEnumEntry;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiModality;
import org.jetbrains.kotlin.library.abi.AbiProperty;
import org.jetbrains.kotlin.library.abi.AbiPropertyKind;
import org.jetbrains.kotlin.library.abi.AbiRenderingSettings;
import org.jetbrains.kotlin.library.abi.AbiSimpleName;
import org.jetbrains.kotlin.library.abi.AbiTopLevelDeclarations;
import org.jetbrains.kotlin.library.abi.AbiType;
import org.jetbrains.kotlin.library.abi.AbiTypeArgument;
import org.jetbrains.kotlin.library.abi.AbiTypeNullability;
import org.jetbrains.kotlin.library.abi.AbiTypeParameter;
import org.jetbrains.kotlin.library.abi.AbiTypeParametersContainer;
import org.jetbrains.kotlin.library.abi.AbiValueParameter;
import org.jetbrains.kotlin.library.abi.AbiVariance;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl;

@ExperimentalLibraryAbiReader
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 \r2\u00020\u0001:\t\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl;", "", "libraryAbi", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "settings", "Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;", "output", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "(Lorg/jetbrains/kotlin/library/abi/LibraryAbi;Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;Ljava/lang/Appendable;)V", "printHeader", "", "render", "Companion", "Printer", "RenderedClass", "RenderedDeclaration", "RenderedDeclarationContainerKind", "RenderedEnumEntry", "RenderedFunction", "RenderedProperty", "RenderedTopLevelDeclarations", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,435:1\n1#2:436\n1855#3,2:437\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl\n*L\n47#1:437,2\n*E\n"})
public final class AbiRendererImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryAbi libraryAbi;
    @NotNull
    private final AbiRenderingSettings settings;
    @NotNull
    private final Appendable output;

    public AbiRendererImpl(@NotNull LibraryAbi libraryAbi, @NotNull AbiRenderingSettings settings, @NotNull Appendable output2) {
        Intrinsics.checkNotNullParameter((Object)libraryAbi, (String)"libraryAbi");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        this.libraryAbi = libraryAbi;
        this.settings = settings;
        this.output = output2;
    }

    public final void render() {
        this.printHeader();
        if (this.settings.getRenderDeclarations()) {
            RenderedTopLevelDeclarations.INSTANCE.printNestedDeclarationsInProperOrder((AbiDeclarationContainer)this.libraryAbi.getTopLevelDeclarations(), new Printer(this.output, this.settings));
        }
    }

    private final void printHeader() {
        Appendable appendable = this.output.append(StringsKt.trimIndent((String)("\n                // Rendering settings:\n                // - Signature version: " + this.settings.getRenderedSignatureVersion().getVersionNumber() + "\n                // - Show manifest properties: " + this.settings.getRenderManifest() + "\n                // - Show declarations: " + this.settings.getRenderDeclarations() + "\n               \n                // Library unique name: <" + this.libraryAbi.getUniqueName() + ">\n            ")));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        if (this.settings.getRenderManifest()) {
            Pair pair;
            Pair pair2;
            Pair pair3;
            Pair pair4;
            Pair pair5;
            Object object;
            Pair pair6;
            Object it;
            Object[] objectArray;
            int n;
            Object[] objectArray2;
            LibraryManifest $this$printHeader_u24lambda_u248 = this.libraryAbi.getManifest();
            boolean bl = false;
            Object[] objectArray3 = objectArray2 = new Pair[6];
            int n2 = 0;
            String string2 = $this$printHeader_u24lambda_u248.getPlatform();
            if (string2 != null) {
                String string3 = string2;
                n = n2;
                objectArray = objectArray3;
                boolean bl2 = false;
                Pair pair7 = TuplesKt.to((Object)"Platform", (Object)it);
                objectArray3 = objectArray;
                n2 = n;
                pair6 = pair7;
            } else {
                pair6 = null;
            }
            objectArray3[n2] = pair6;
            it = object = $this$printHeader_u24lambda_u248.getNativeTargets();
            n = 1;
            objectArray = objectArray2;
            boolean bl3 = false;
            boolean bl4 = !((Collection)it).isEmpty();
            Object[] objectArray4 = objectArray;
            int n3 = n;
            Object object2 = bl4 ? object : null;
            if (object2 != null) {
                it = object2;
                n = n3;
                objectArray = objectArray4;
                boolean bl5 = false;
                Pair pair8 = TuplesKt.to((Object)"Native targets", (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                objectArray4 = objectArray;
                n3 = n;
                pair5 = pair8;
            } else {
                pair5 = null;
            }
            objectArray4[n3] = pair5;
            Object[] objectArray5 = objectArray2;
            int n4 = 2;
            String string4 = $this$printHeader_u24lambda_u248.getCompilerVersion();
            if (string4 != null) {
                it = string4;
                n = n4;
                objectArray = objectArray5;
                boolean bl6 = false;
                Pair pair9 = TuplesKt.to((Object)"Compiler version", (Object)it);
                objectArray5 = objectArray;
                n4 = n;
                pair4 = pair9;
            } else {
                pair4 = null;
            }
            objectArray5[n4] = pair4;
            Object[] objectArray6 = objectArray2;
            int n5 = 3;
            String string5 = $this$printHeader_u24lambda_u248.getAbiVersion();
            if (string5 != null) {
                it = string5;
                n = n5;
                objectArray = objectArray6;
                boolean bl7 = false;
                Pair pair10 = TuplesKt.to((Object)"ABI version", (Object)it);
                objectArray6 = objectArray;
                n5 = n;
                pair3 = pair10;
            } else {
                pair3 = null;
            }
            objectArray6[n5] = pair3;
            Object[] objectArray7 = objectArray2;
            int n6 = 4;
            String string6 = $this$printHeader_u24lambda_u248.getLibraryVersion();
            if (string6 != null) {
                it = string6;
                n = n6;
                objectArray = objectArray7;
                boolean bl8 = false;
                Pair pair11 = TuplesKt.to((Object)"Library version", (Object)it);
                objectArray7 = objectArray;
                n6 = n;
                pair2 = pair11;
            } else {
                pair2 = null;
            }
            objectArray7[n6] = pair2;
            Object[] objectArray8 = objectArray2;
            int n7 = 5;
            String string7 = $this$printHeader_u24lambda_u248.getIrProviderName();
            if (string7 != null) {
                it = string7;
                n = n7;
                objectArray = objectArray8;
                boolean bl9 = false;
                Pair pair12 = TuplesKt.to((Object)"IR provider", (Object)it);
                objectArray8 = objectArray;
                n7 = n;
                pair = pair12;
            } else {
                pair = null;
            }
            objectArray8[n7] = pair;
            Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair13 = (Pair)element$iv;
                boolean bl10 = false;
                String name2 = (String)pair13.component1();
                String value2 = (String)pair13.component2();
                Appendable appendable2 = this.output.append("// ").append(name2).append(": ");
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
                Appendable appendable3 = appendable2.append(value2);
                Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JU\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0005*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u00060\u00042\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u0002H\u00050\bj\b\u0012\u0004\u0012\u0002H\u0005`\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00050\u000bH\u0082\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion;", "", "()V", "mapAndSort", "", "R", "T", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "transform", "Lkotlin/Function1;", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,435:1\n1620#2,3:436\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n*L\n429#1:436,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0086\b\u00f8\u0001\u0002J\u0006\u0010\u0013\u001a\u00020\fJ\u001c\u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\b\u001a\u00020\tX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0012\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "", "output", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "settings", "Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;", "(Ljava/lang/Appendable;Lorg/jetbrains/kotlin/library/abi/AbiRenderingSettings;)V", "indent", "Lkotlin/UInt;", "I", "appendIndent", "", "appendSignature", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "indented", "block", "Lkotlin/Function0;", "printClosingBrace", "printDeclaration", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "printOpeningBrace", "", "kotlin-util-klib-abi"})
    private static final class Printer {
        @NotNull
        private final Appendable output;
        @NotNull
        private final AbiRenderingSettings settings;
        private int indent;

        public Printer(@NotNull Appendable output2, @NotNull AbiRenderingSettings settings) {
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.output = output2;
            this.settings = settings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void indented(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$indented = false;
            int n = this.indent;
            this.indent = UInt.constructor-impl((int)(n + 1));
            try {
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                n = this.indent;
                this.indent = UInt.constructor-impl((int)(n + -1));
                InlineMarker.finallyEnd((int)1);
            }
        }

        public final void printDeclaration(@NotNull RenderedDeclaration<?> renderedDeclaration, boolean printOpeningBrace) {
            Intrinsics.checkNotNullParameter(renderedDeclaration, (String)"renderedDeclaration");
            Appendable $this$printDeclaration_u24lambda_u240 = this.output;
            boolean bl = false;
            this.appendIndent();
            $this$printDeclaration_u24lambda_u240.append(renderedDeclaration.getText());
            if (printOpeningBrace) {
                $this$printDeclaration_u24lambda_u240.append(" {");
            }
            this.appendSignature((AbiDeclaration)renderedDeclaration.getDeclaration());
            Intrinsics.checkNotNullExpressionValue((Object)$this$printDeclaration_u24lambda_u240.append('\n'), (String)"append(...)");
        }

        public static /* synthetic */ void printDeclaration$default(Printer printer, RenderedDeclaration renderedDeclaration, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            printer.printDeclaration(renderedDeclaration, bl);
        }

        public final void printClosingBrace() {
            Appendable $this$printClosingBrace_u24lambda_u241 = this.output;
            boolean bl = false;
            this.appendIndent();
            Appendable appendable = $this$printClosingBrace_u24lambda_u241.append('}');
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        }

        private final void appendIndent() {
            int n = 0;
            int n2 = this.indent;
            while (UnsignedKt.uintCompare((int)n, (int)n2) < 0) {
                int i = n++;
                this.output.append(this.settings.getIndentationString());
            }
        }

        private final void appendSignature(AbiDeclaration declaration) {
            this.output.append(" // ");
            String string2 = declaration.getSignatures().get(this.settings.getRenderedSignatureVersion());
            if (string2 == null) {
                string2 = (String)this.settings.getWhenSignatureNotFound().invoke((Object)declaration, (Object)this.settings.getRenderedSignatureVersion());
            }
            this.output.append(string2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiClass;", "declaration", "(Lorg/jetbrains/kotlin/library/abi/AbiClass;)V", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass\n+ 2 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer\n*L\n1#1,435:1\n58#2,7:436\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass\n*L\n258#1:436,7\n*E\n"})
    private static final class RenderedClass
    extends RenderedDeclaration<AbiClass> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        public RenderedClass(@NotNull AbiClass declaration) {
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedClass renderedClass = this;
            boolean bl = false;
            RenderedDeclaration.Companion.appendModalityOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            if (declaration.isInner()) {
                $this$_init__u24lambda_u240.append("inner ");
            }
            if (declaration.isValue()) {
                $this$_init__u24lambda_u240.append("value ");
            }
            if (declaration.isFunction()) {
                $this$_init__u24lambda_u240.append("fun ");
            }
            RenderedClass.Companion.appendClassKind((StringBuilder)$this$_init__u24lambda_u240, declaration.getKind());
            RenderedDeclaration.Companion.appendTypeParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            if (!((Collection)declaration.getSuperTypes()).isEmpty()) {
                RenderedDeclaration.Companion.appendSortedTypes((StringBuilder)$this$_init__u24lambda_u240, declaration.getSuperTypes(), ", ", " : ", "");
            }
            Unit unit2 = Unit.INSTANCE;
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            super(abiDeclaration, string2, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            boolean hasChildren = !((Collection)((AbiClass)this.getDeclaration()).getDeclarations()).isEmpty();
            printer.printDeclaration(this, hasChildren);
            if (hasChildren) {
                Printer this_$iv = printer;
                boolean $i$f$indented = false;
                int n = this_$iv.indent;
                this_$iv.indent = UInt.constructor-impl((int)(n + 1));
                try {
                    boolean bl = false;
                    Companion.printNestedDeclarationsInProperOrder((AbiDeclarationContainer)this.getDeclaration(), printer);
                }
                finally {
                    n = this_$iv.indent;
                    this_$iv.indent = UInt.constructor-impl((int)(n + -1));
                }
                printer.printClosingBrace();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass$Companion;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind;", "Lorg/jetbrains/kotlin/library/abi/AbiClass;", "()V", "orderByDeclarationKind", "", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "appendClassKind", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "classKind", "Lorg/jetbrains/kotlin/library/abi/AbiClassKind;", "kotlin-util-klib-abi"})
        public static final class Companion
        extends RenderedDeclarationContainerKind<AbiClass> {
            private Companion() {
            }

            private final void appendClassKind(StringBuilder $this$appendClassKind, AbiClassKind classKind) {
                String string2;
                switch (WhenMappings.$EnumSwitchMapping$0[classKind.ordinal()]) {
                    case 1: {
                        string2 = "class";
                        break;
                    }
                    case 2: {
                        string2 = "interface";
                        break;
                    }
                    case 3: {
                        string2 = "object";
                        break;
                    }
                    case 4: {
                        string2 = "enum class";
                        break;
                    }
                    case 5: {
                        string2 = "annotation class";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$appendClassKind.append(string2).append(' ');
            }

            @Override
            protected int orderByDeclarationKind(@NotNull RenderedDeclaration<?> renderedDeclaration) {
                int n;
                Intrinsics.checkNotNullParameter(renderedDeclaration, (String)"renderedDeclaration");
                Object declaration = renderedDeclaration.getDeclaration();
                if (declaration instanceof AbiProperty) {
                    n = 1;
                } else if (declaration instanceof AbiFunction) {
                    n = ((AbiFunction)declaration).isConstructor() ? 2 : 3;
                } else if (declaration instanceof AbiClass) {
                    n = 4;
                } else if (declaration instanceof AbiEnumEntry) {
                    n = 5;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AbiClassKind.values().length];
                    try {
                        nArray[AbiClassKind.CLASS.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.INTERFACE.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.OBJECT.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.ENUM_CLASS.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiClassKind.ANNOTATION_CLASS.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u0017*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0017B\u0017\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u0082\u0001\u0004\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "T", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "", "declaration", "text", "", "(Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;Ljava/lang/String;)V", "additionalOrderingFactor1", "", "getAdditionalOrderingFactor1", "()I", "additionalOrderingFactor2", "getAdditionalOrderingFactor2", "()Ljava/lang/String;", "getDeclaration", "()Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "getText", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedClass;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedEnumEntry;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty;", "kotlin-util-klib-abi"})
    private static abstract class RenderedDeclaration<T extends AbiDeclaration> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final T declaration;
        @NotNull
        private final String text;

        private RenderedDeclaration(T declaration, String text2) {
            this.declaration = declaration;
            this.text = text2;
        }

        @NotNull
        public final T getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public int getAdditionalOrderingFactor1() {
            return 0;
        }

        @NotNull
        public String getAdditionalOrderingFactor2() {
            return "";
        }

        public abstract void print(@NotNull Printer var1);

        public /* synthetic */ RenderedDeclaration(AbiDeclaration declaration, String text2, DefaultConstructorMarker $constructor_marker) {
            this(declaration, text2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0006J4\u0010\r\u001a\u00020\b*\u00060\tj\u0002`\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0016\u001a\u00020\u0010J\u0018\u0010\u0017\u001a\u00020\u0012*\u00060\tj\u0002`\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u0012*\u00060\tj\u0002`\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration$Companion;", "", "()V", "createFor", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "appendModalityOf", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/library/abi/AbiDeclarationWithModality;", "appendNameOf", "appendSortedTypes", "types", "", "Lorg/jetbrains/kotlin/library/abi/AbiType;", "separator", "", "prefix", "postfix", "appendType", "type", "appendTypeArgument", "typeArgument", "Lorg/jetbrains/kotlin/library/abi/AbiTypeArgument;", "appendTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParameter;", "appendTypeParametersOf", "container", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParametersContainer;", "appendVariance", "variance", "Lorg/jetbrains/kotlin/library/abi/AbiVariance;", "kotlin-util-klib-abi"})
        @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration$Companion\n+ 2 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,435:1\n426#2,4:436\n430#2,2:444\n1620#3,2:440\n1622#3:443\n1#4:442\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration$Companion\n*L\n229#1:436,4\n229#1:444,2\n229#1:440,2\n229#1:443\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RenderedDeclaration<?> createFor(@NotNull AbiDeclaration declaration) {
                RenderedDeclaration renderedDeclaration;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                AbiDeclaration abiDeclaration = declaration;
                if (abiDeclaration instanceof AbiFunction) {
                    renderedDeclaration = new RenderedFunction((AbiFunction)declaration);
                } else if (abiDeclaration instanceof AbiProperty) {
                    renderedDeclaration = new RenderedProperty((AbiProperty)declaration);
                } else if (abiDeclaration instanceof AbiClass) {
                    renderedDeclaration = new RenderedClass((AbiClass)declaration);
                } else if (abiDeclaration instanceof AbiEnumEntry) {
                    renderedDeclaration = new RenderedEnumEntry((AbiEnumEntry)declaration);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return renderedDeclaration;
            }

            public final void appendModalityOf(@NotNull StringBuilder $this$appendModalityOf, @NotNull AbiDeclarationWithModality declaration) {
                Intrinsics.checkNotNullParameter((Object)$this$appendModalityOf, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                String string2 = declaration.getModality().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                $this$appendModalityOf.append(string2).append(' ');
            }

            public final void appendNameOf(@NotNull StringBuilder $this$appendNameOf, @NotNull AbiDeclaration declaration) {
                Intrinsics.checkNotNullParameter((Object)$this$appendNameOf, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                boolean isTopLevel = AbiCompoundName.getNameSegmentsCount-impl(declaration.getQualifiedName().getRelativeName-l9-qHIQ()) == 1;
                $this$appendNameOf.append(isTopLevel ? (Comparable)declaration.getQualifiedName() : AbiSimpleName.box-impl(AbiCompoundName.getSimpleName-t-3xSXQ(declaration.getQualifiedName().getRelativeName-l9-qHIQ())));
            }

            public final void appendTypeParametersOf(@NotNull StringBuilder $this$appendTypeParametersOf, @NotNull AbiTypeParametersContainer container) {
                Intrinsics.checkNotNullParameter((Object)$this$appendTypeParametersOf, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                if (!((Collection)container.getTypeParameters()).isEmpty()) {
                    CollectionsKt.joinTo$default((Iterable)container.getTypeParameters(), (Appendable)$this$appendTypeParametersOf, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<AbiTypeParameter, CharSequence>($this$appendTypeParametersOf){
                        final /* synthetic */ StringBuilder $this_appendTypeParametersOf;
                        {
                            this.$this_appendTypeParametersOf = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(@NotNull AbiTypeParameter typeParameter2) {
                            Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
                            return org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl$RenderedDeclaration$Companion.access$appendTypeParameter(RenderedDeclaration.Companion, this.$this_appendTypeParametersOf, typeParameter2);
                        }
                    }), (int)48, null);
                    $this$appendTypeParametersOf.append(' ');
                }
            }

            private final String appendTypeParameter(StringBuilder $this$appendTypeParameter, AbiTypeParameter typeParameter2) {
                $this$appendTypeParameter.append('#').append(typeParameter2.getTag()).append(": ");
                if (typeParameter2.isReified()) {
                    $this$appendTypeParameter.append("reified ");
                }
                this.appendVariance($this$appendTypeParameter, typeParameter2.getVariance());
                switch (typeParameter2.getUpperBounds().size()) {
                    case 0: {
                        $this$appendTypeParameter.append("kotlin/Any?");
                        break;
                    }
                    case 1: {
                        this.appendType($this$appendTypeParameter, typeParameter2.getUpperBounds().get(0));
                        break;
                    }
                    default: {
                        this.appendSortedTypes($this$appendTypeParameter, typeParameter2.getUpperBounds(), " & ", "", "");
                    }
                }
                return "";
            }

            public final void appendType(@NotNull StringBuilder $this$appendType, @NotNull AbiType type2) {
                Intrinsics.checkNotNullParameter((Object)$this$appendType, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                AbiType abiType = type2;
                if (abiType instanceof AbiType.Simple) {
                    AbiClassifierReference classifier2 = ((AbiType.Simple)type2).getClassifierReference();
                    if (classifier2 instanceof AbiClassifierReference.ClassReference) {
                        $this$appendType.append(((AbiClassifierReference.ClassReference)classifier2).getClassName());
                        if (!((Collection)((AbiType.Simple)type2).getArguments()).isEmpty()) {
                            CollectionsKt.joinTo$default((Iterable)((AbiType.Simple)type2).getArguments(), (Appendable)$this$appendType, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<AbiTypeArgument, CharSequence>($this$appendType){
                                final /* synthetic */ StringBuilder $this_appendType;
                                {
                                    this.$this_appendType = $receiver;
                                    super(1);
                                }

                                @NotNull
                                public final CharSequence invoke(@NotNull AbiTypeArgument typeArgument) {
                                    Intrinsics.checkNotNullParameter((Object)typeArgument, (String)"typeArgument");
                                    return org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl$RenderedDeclaration$Companion.access$appendTypeArgument(RenderedDeclaration.Companion, this.$this_appendType, typeArgument);
                                }
                            }), (int)48, null);
                        }
                        if (((AbiType.Simple)type2).getNullability() == AbiTypeNullability.MARKED_NULLABLE) {
                            $this$appendType.append('?');
                        }
                    } else if (classifier2 instanceof AbiClassifierReference.TypeParameterReference) {
                        $this$appendType.append('#').append(((AbiClassifierReference.TypeParameterReference)classifier2).getTag());
                        switch (WhenMappings.$EnumSwitchMapping$0[((AbiType.Simple)type2).getNullability().ordinal()]) {
                            case 1: {
                                $this$appendType.append('?');
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                $this$appendType.append("!!");
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (abiType instanceof AbiType.Dynamic) {
                    $this$appendType.append("dynamic");
                } else if (abiType instanceof AbiType.Error) {
                    $this$appendType.append("error");
                }
            }

            private final String appendTypeArgument(StringBuilder $this$appendTypeArgument, AbiTypeArgument typeArgument) {
                AbiTypeArgument abiTypeArgument = typeArgument;
                if (abiTypeArgument instanceof AbiTypeArgument.StarProjection) {
                    $this$appendTypeArgument.append('*');
                } else if (abiTypeArgument instanceof AbiTypeArgument.TypeProjection) {
                    this.appendVariance($this$appendTypeArgument, ((AbiTypeArgument.TypeProjection)typeArgument).getVariance());
                    this.appendType($this$appendTypeArgument, ((AbiTypeArgument.TypeProjection)typeArgument).getType());
                }
                return "";
            }

            private final void appendVariance(StringBuilder $this$appendVariance, AbiVariance variance) {
                switch (WhenMappings.$EnumSwitchMapping$1[variance.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        $this$appendVariance.append("in ");
                        break;
                    }
                    case 3: {
                        $this$appendVariance.append("out ");
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void appendSortedTypes(@NotNull StringBuilder $this$appendSortedTypes, @NotNull List<? extends AbiType> types2, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
                List list2;
                void $this$mapAndSort$iv;
                Intrinsics.checkNotNullParameter((Object)$this$appendSortedTypes, (String)"<this>");
                Intrinsics.checkNotNullParameter(types2, (String)"types");
                Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
                org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl$Companion companion = AbiRendererImpl.Companion;
                List<? extends AbiType> list3 = types2;
                Comparator comparator$iv = ComparisonsKt.naturalOrder();
                boolean $i$f$mapAndSort = false;
                if ($this$mapAndSort$iv.isEmpty()) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    ArrayList result$iv = new ArrayList($this$mapAndSort$iv.size());
                    Iterable $this$mapTo$iv$iv = (Iterable)$this$mapAndSort$iv;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        StringBuilder stringBuilder2;
                        AbiType abiType = (AbiType)item$iv$iv;
                        Collection collection = result$iv;
                        boolean bl = false;
                        StringBuilder $this$appendSortedTypes_u24lambda_u241_u24lambda_u240 = stringBuilder2 = new StringBuilder();
                        boolean bl2 = false;
                        Companion.appendType($this$appendSortedTypes_u24lambda_u241_u24lambda_u240, (AbiType)it);
                        String string2 = stringBuilder2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        collection.add(string2);
                    }
                    CollectionsKt.sortWith((List)result$iv, (Comparator)comparator$iv);
                    list2 = result$iv;
                }
                CollectionsKt.joinTo$default((Iterable)list2, (Appendable)$this$appendSortedTypes, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)112, null);
            }

            public static final /* synthetic */ String access$appendTypeParameter(Companion $this, StringBuilder $receiver, AbiTypeParameter typeParameter2) {
                return $this.appendTypeParameter($receiver, typeParameter2);
            }

            public static final /* synthetic */ String access$appendTypeArgument(Companion $this, StringBuilder $receiver, AbiTypeArgument typeArgument) {
                return $this.appendTypeArgument($receiver, typeArgument);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;
                public static final /* synthetic */ int[] $EnumSwitchMapping$1;

                static {
                    int[] nArray = new int[AbiTypeNullability.values().length];
                    try {
                        nArray[AbiTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                    nArray = new int[AbiVariance.values().length];
                    try {
                        nArray[AbiVariance.INVARIANT.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiVariance.IN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiVariance.OUT.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$1 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH$J\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind;", "T", "Lorg/jetbrains/kotlin/library/abi/AbiDeclarationContainer;", "", "()V", "orderByDeclarationKind", "", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "printNestedDeclarationsInProperOrder", "", "container", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "(Lorg/jetbrains/kotlin/library/abi/AbiDeclarationContainer;Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;)V", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind\n+ 2 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,435:1\n426#2,4:436\n430#2,2:443\n1620#3,3:440\n1855#3,2:445\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind\n*L\n100#1:436,4\n100#1:443,2\n100#1:440,3\n118#1:445,2\n*E\n"})
    private static abstract class RenderedDeclarationContainerKind<T extends AbiDeclarationContainer> {
        protected abstract int orderByDeclarationKind(@NotNull RenderedDeclaration<?> var1);

        /*
         * WARNING - void declaration
         */
        public final void printNestedDeclarationsInProperOrder(@NotNull T container, @NotNull Printer printer) {
            List list2;
            void $this$mapAndSort$iv;
            Intrinsics.checkNotNullParameter(container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            Companion companion = Companion;
            List<AbiDeclaration> list3 = container.getDeclarations();
            Object object = new Function1[]{new Function1<RenderedDeclaration<?>, Integer>(this){

                @NotNull
                public final Integer invoke(@NotNull RenderedDeclaration<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((RenderedDeclarationContainerKind)this.receiver).orderByDeclarationKind(p0);
                }

                @NotNull
                public final String getSignature() {
                    return "orderByDeclarationKind(Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;)I";
                }

                @NotNull
                public final String getName() {
                    return "orderByDeclarationKind";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(RenderedDeclarationContainerKind.class);
                }
            }, printNestedDeclarationsInProperOrder.2.INSTANCE, printNestedDeclarationsInProperOrder.3.INSTANCE, printNestedDeclarationsInProperOrder.4.INSTANCE, printNestedDeclarationsInProperOrder.5.INSTANCE};
            object = ComparisonsKt.compareBy((Function1[])object);
            RenderedDeclaration.Companion companion2 = RenderedDeclaration.Companion;
            boolean $i$f$mapAndSort = false;
            if ($this$mapAndSort$iv.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                void comparator$iv;
                ArrayList result$iv = new ArrayList($this$mapAndSort$iv.size());
                Iterable $this$mapTo$iv$iv = (Iterable)$this$mapAndSort$iv;
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    AbiDeclaration abiDeclaration = (AbiDeclaration)item$iv$iv;
                    Collection collection = result$iv;
                    boolean bl = false;
                    collection.add(companion2.createFor((AbiDeclaration)p0));
                }
                CollectionsKt.sortWith((List)result$iv, (Comparator)comparator$iv);
                list2 = result$iv;
            }
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RenderedDeclaration it = (RenderedDeclaration)element$iv;
                boolean bl = false;
                it.print(printer);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedEnumEntry;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiEnumEntry;", "declaration", "(Lorg/jetbrains/kotlin/library/abi/AbiEnumEntry;)V", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "kotlin-util-klib-abi"})
    private static final class RenderedEnumEntry
    extends RenderedDeclaration<AbiEnumEntry> {
        /*
         * WARNING - void declaration
         */
        public RenderedEnumEntry(@NotNull AbiEnumEntry declaration) {
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedEnumEntry renderedEnumEntry = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.append("enum entry ");
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            Unit unit2 = Unit.INSTANCE;
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            super(abiDeclaration, string2, null);
        }

        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            Printer.printDeclaration$default(printer, this, false, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "declaration", "(Lorg/jetbrains/kotlin/library/abi/AbiFunction;)V", "additionalOrderingFactor1", "", "getAdditionalOrderingFactor1", "()I", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "kotlin-util-klib-abi"})
    private static final class RenderedFunction
    extends RenderedDeclaration<AbiFunction> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        public RenderedFunction(@NotNull AbiFunction declaration) {
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedFunction renderedFunction = this;
            boolean bl = false;
            if (!declaration.isConstructor() || declaration.getModality() != AbiModality.FINAL) {
                RenderedDeclaration.Companion.appendModalityOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            }
            if (declaration.isSuspend()) {
                $this$_init__u24lambda_u240.append("suspend ");
            }
            if (declaration.isInline()) {
                $this$_init__u24lambda_u240.append("inline ");
            }
            $this$_init__u24lambda_u240.append(declaration.isConstructor() ? "constructor " : "fun ");
            RenderedDeclaration.Companion.appendTypeParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedFunction.Companion.appendIrregularValueParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedFunction.Companion.appendRegularValueParametersOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedFunction.Companion.appendReturnTypeOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            Unit unit2 = Unit.INSTANCE;
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            super(abiDeclaration, string2, null);
        }

        @Override
        public int getAdditionalOrderingFactor1() {
            int extensionReceivers = ((AbiFunction)this.getDeclaration()).getHasExtensionReceiverParameter() ? 1 : 0;
            int contextReceivers = ((AbiFunction)this.getDeclaration()).getContextReceiverParametersCount();
            int regularParameters = ((AbiFunction)this.getDeclaration()).getValueParameters().size() - extensionReceivers - contextReceivers;
            return (contextReceivers << 1 | extensionReceivers) << 8 | regularParameters;
        }

        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            Printer.printDeclaration$default(printer, this, false, 2, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u0004*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u0004*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u0004*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\f*\u00060\u0005j\u0002`\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction$Companion;", "", "()V", "appendIrregularValueParametersOf", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "function", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "appendRegularValueParametersOf", "appendReturnTypeOf", "appendValueParameter", "", "valueParameter", "Lorg/jetbrains/kotlin/library/abi/AbiValueParameter;", "kotlin-util-klib-abi"})
        @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,435:1\n1#2:436\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final void appendIrregularValueParametersOf(StringBuilder $this$appendIrregularValueParametersOf, AbiFunction function2) {
                if (function2.getContextReceiverParametersCount() > 0) {
                    Sequence sequence2;
                    Sequence $this$appendIrregularValueParametersOf_u24lambda_u240 = sequence2 = CollectionsKt.asSequence((Iterable)function2.getValueParameters());
                    boolean bl = false;
                    if (function2.getHasExtensionReceiverParameter()) {
                        SequencesKt.drop((Sequence)$this$appendIrregularValueParametersOf_u24lambda_u240, (int)1);
                    }
                    SequencesKt.joinTo$default((Sequence)SequencesKt.take((Sequence)sequence2, (int)function2.getContextReceiverParametersCount()), (Appendable)$this$appendIrregularValueParametersOf, (CharSequence)", ", (CharSequence)"context(", (CharSequence)") ", (int)0, null, (Function1)((Function1)new Function1<AbiValueParameter, CharSequence>($this$appendIrregularValueParametersOf){
                        final /* synthetic */ StringBuilder $this_appendIrregularValueParametersOf;
                        {
                            this.$this_appendIrregularValueParametersOf = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(@NotNull AbiValueParameter valueParameter2) {
                            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
                            return org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl$RenderedFunction$Companion.access$appendValueParameter(RenderedFunction.Companion, this.$this_appendIrregularValueParametersOf, valueParameter2);
                        }
                    }), (int)48, null);
                }
                if (function2.getHasExtensionReceiverParameter()) {
                    $this$appendIrregularValueParametersOf.append('(');
                    this.appendValueParameter($this$appendIrregularValueParametersOf, function2.getValueParameters().get(0));
                    $this$appendIrregularValueParametersOf.append(").");
                }
            }

            private final void appendRegularValueParametersOf(StringBuilder $this$appendRegularValueParametersOf, AbiFunction function2) {
                int skippedParametersCount = (function2.getHasExtensionReceiverParameter() ? 1 : 0) + function2.getContextReceiverParametersCount();
                SequencesKt.joinTo$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)function2.getValueParameters()), (int)skippedParametersCount), (Appendable)$this$appendRegularValueParametersOf, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<AbiValueParameter, CharSequence>($this$appendRegularValueParametersOf){
                    final /* synthetic */ StringBuilder $this_appendRegularValueParametersOf;
                    {
                        this.$this_appendRegularValueParametersOf = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull AbiValueParameter valueParameter2) {
                        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
                        return org.jetbrains.kotlin.library.abi.impl.AbiRendererImpl$RenderedFunction$Companion.access$appendValueParameter(RenderedFunction.Companion, this.$this_appendRegularValueParametersOf, valueParameter2);
                    }
                }), (int)48, null);
            }

            private final String appendValueParameter(StringBuilder $this$appendValueParameter, AbiValueParameter valueParameter2) {
                if (valueParameter2.isNoinline()) {
                    $this$appendValueParameter.append("noinline ");
                }
                if (valueParameter2.isCrossinline()) {
                    $this$appendValueParameter.append("crossinline ");
                }
                RenderedDeclaration.Companion.appendType($this$appendValueParameter, valueParameter2.getType());
                if (valueParameter2.isVararg()) {
                    $this$appendValueParameter.append("...");
                }
                if (valueParameter2.getHasDefaultArg()) {
                    $this$appendValueParameter.append(" =...");
                }
                return "";
            }

            private final void appendReturnTypeOf(StringBuilder $this$appendReturnTypeOf, AbiFunction function2) {
                block0: {
                    AbiType abiType = function2.getReturnType();
                    if (abiType == null) break block0;
                    AbiType returnType2 = abiType;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = $this$appendReturnTypeOf.append(": ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    RenderedDeclaration.Companion.appendType(stringBuilder2, returnType2);
                }
            }

            public static final /* synthetic */ String access$appendValueParameter(Companion $this, StringBuilder $receiver, AbiValueParameter valueParameter2) {
                return $this.appendValueParameter($receiver, valueParameter2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "Lorg/jetbrains/kotlin/library/abi/AbiProperty;", "declaration", "(Lorg/jetbrains/kotlin/library/abi/AbiProperty;)V", "additionalOrderingFactor1", "", "getAdditionalOrderingFactor1", "()I", "additionalOrderingFactor2", "", "getAdditionalOrderingFactor2", "()Ljava/lang/String;", "getter", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedFunction;", "setter", "print", "", "printer", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer;", "Companion", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$Printer\n*L\n1#1,435:1\n1#2:436\n58#3,7:437\n*S KotlinDebug\n*F\n+ 1 LibraryAbiRendererImpl.kt\norg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty\n*L\n329#1:437,7\n*E\n"})
    private static final class RenderedProperty
    extends RenderedDeclaration<AbiProperty> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final RenderedFunction getter;
        @Nullable
        private final RenderedFunction setter;

        /*
         * WARNING - void declaration
         */
        public RenderedProperty(@NotNull AbiProperty declaration) {
            RenderedFunction renderedFunction;
            RenderedFunction renderedFunction2;
            void $this$_init__u24lambda_u240;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
            AbiDeclaration abiDeclaration = declaration;
            RenderedProperty renderedProperty = this;
            boolean bl2 = false;
            RenderedDeclaration.Companion.appendModalityOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            RenderedProperty.Companion.appendPropertyKind((StringBuilder)$this$_init__u24lambda_u240, declaration.getKind());
            RenderedDeclaration.Companion.appendNameOf((StringBuilder)$this$_init__u24lambda_u240, declaration);
            Unit unit2 = Unit.INSTANCE;
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            super(abiDeclaration, string2, null);
            RenderedProperty renderedProperty2 = this;
            AbiFunction abiFunction = declaration.getGetter();
            if (abiFunction != null) {
                void p0;
                AbiFunction bl2 = abiFunction;
                renderedProperty = renderedProperty2;
                boolean bl3 = false;
                renderedFunction2 = new RenderedFunction((AbiFunction)p0);
                renderedProperty2 = renderedProperty;
            } else {
                renderedFunction2 = null;
            }
            renderedProperty2.getter = renderedFunction2;
            RenderedProperty renderedProperty3 = this;
            AbiFunction abiFunction2 = declaration.getSetter();
            if (abiFunction2 != null) {
                AbiFunction p0 = abiFunction2;
                renderedProperty = renderedProperty3;
                boolean bl4 = false;
                renderedFunction = new RenderedFunction(p0);
                renderedProperty3 = renderedProperty;
            } else {
                renderedFunction = null;
            }
            renderedProperty3.setter = renderedFunction;
        }

        @Override
        public int getAdditionalOrderingFactor1() {
            RenderedFunction renderedFunction = this.getter;
            if (renderedFunction == null) {
                renderedFunction = this.setter;
            }
            return renderedFunction != null ? renderedFunction.getAdditionalOrderingFactor1() : 0;
        }

        @Override
        @NotNull
        public String getAdditionalOrderingFactor2() {
            String string2;
            RenderedFunction renderedFunction = this.getter;
            if (renderedFunction == null) {
                renderedFunction = this.setter;
            }
            if ((string2 = renderedFunction != null ? renderedFunction.getText() : null) == null) {
                string2 = "";
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(@NotNull Printer printer) {
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            Printer.printDeclaration$default(printer, this, false, 2, null);
            Printer this_$iv = printer;
            boolean $i$f$indented = false;
            int n = this_$iv.indent;
            this_$iv.indent = UInt.constructor-impl((int)(n + 1));
            try {
                boolean bl = false;
                RenderedFunction renderedFunction = this.getter;
                if (renderedFunction != null) {
                    renderedFunction.print(printer);
                }
                RenderedFunction renderedFunction2 = this.setter;
                if (renderedFunction2 != null) {
                    renderedFunction2.print(printer);
                }
            }
            finally {
                n = this_$iv.indent;
                this_$iv.indent = UInt.constructor-impl((int)(n + -1));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u0004*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedProperty$Companion;", "", "()V", "appendPropertyKind", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "propertyKind", "Lorg/jetbrains/kotlin/library/abi/AbiPropertyKind;", "kotlin-util-klib-abi"})
        public static final class Companion {
            private Companion() {
            }

            private final void appendPropertyKind(StringBuilder $this$appendPropertyKind, AbiPropertyKind propertyKind) {
                String string2;
                switch (WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
                    case 1: {
                        string2 = "val";
                        break;
                    }
                    case 2: {
                        string2 = "const val";
                        break;
                    }
                    case 3: {
                        string2 = "var";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$appendPropertyKind.append(string2).append(' ');
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AbiPropertyKind.values().length];
                    try {
                        nArray[AbiPropertyKind.VAL.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiPropertyKind.CONST_VAL.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AbiPropertyKind.VAR.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedTopLevelDeclarations;", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclarationContainerKind;", "Lorg/jetbrains/kotlin/library/abi/AbiTopLevelDeclarations;", "()V", "orderByDeclarationKind", "", "renderedDeclaration", "Lorg/jetbrains/kotlin/library/abi/impl/AbiRendererImpl$RenderedDeclaration;", "kotlin-util-klib-abi"})
    private static final class RenderedTopLevelDeclarations
    extends RenderedDeclarationContainerKind<AbiTopLevelDeclarations> {
        @NotNull
        public static final RenderedTopLevelDeclarations INSTANCE = new RenderedTopLevelDeclarations();

        private RenderedTopLevelDeclarations() {
        }

        @Override
        protected int orderByDeclarationKind(@NotNull RenderedDeclaration<?> renderedDeclaration) {
            Intrinsics.checkNotNullParameter(renderedDeclaration, (String)"renderedDeclaration");
            Object obj = renderedDeclaration.getDeclaration();
            return obj instanceof AbiClass ? 1 : (obj instanceof AbiProperty ? 2 : (obj instanceof AbiFunction ? 3 : 4));
        }
    }
}

