/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.ir.declarations.persistent.carriers

import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall
import org.jetbrains.kotlin.ir.symbols.IrSymbol
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol
import org.jetbrains.kotlin.ir.types.IrType

// Auto-generated by compiler/ir/ir.tree.persistent/generator/src/org/jetbrains/kotlin/ir/persistentIrGenerator/Main.kt. DO NOT EDIT!

internal interface TypeAliasCarrier : DeclarationCarrier{
    val typeParametersField: List<IrTypeParameter>
    val typeParametersSymbolField: List<IrTypeParameterSymbol>
    val expandedTypeField: IrType

    override fun clone(): TypeAliasCarrier {
        return TypeAliasCarrierImpl(
            lastModified,
            parentSymbolField,
            originField,
            annotationsField,
            typeParametersSymbolField,
            expandedTypeField
        )
    }
}

internal class TypeAliasCarrierImpl(
    override val lastModified: Int,
    override val parentSymbolField: IrSymbol?,
    override val originField: IrDeclarationOrigin,
    override val annotationsField: List<IrConstructorCall>,
    override val typeParametersSymbolField: List<IrTypeParameterSymbol>,
    override val expandedTypeField: IrType
) : TypeAliasCarrier {

    override val typeParametersField: List<IrTypeParameter> by lazy { typeParametersSymbolField.map { it.owner } }
}
