/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.fir;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003 !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000fJ \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u0004\u0018\u00010\n*\u00020\u001d2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\u001e2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\u001f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\tH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter;", "", "()V", "reportByFile", "", "diagnosticsCollector", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "", "reportDiagnostic", "diagnostic", "reporter", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportDiagnosticToMessageCollector", "location", "reportDiagnostics", "diagnostics", "", "reportSpecialErrors", "reportToMessageCollector", "messageCollector", "throwErrorDiagnosticAsException", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "throwFirstErrorAsException", "genericLocation", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "DiagnosticComparator", "SequentialFilePositionFinder", "SingleFileDiagnosticComparator", "cli"})
public final class FirDiagnosticsCompilerResultsReporter {
    @NotNull
    public static final FirDiagnosticsCompilerResultsReporter INSTANCE;

    public final boolean reportDiagnostics(@NotNull Collection<? extends KtDiagnostic> diagnostics2, @NotNull MessageCollector reporter) {
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean hasErrors = false;
        for (KtDiagnostic diagnostic : CollectionsKt.sortedWith((Iterable)diagnostics2, (Comparator)DiagnosticComparator.INSTANCE)) {
            hasErrors = this.reportDiagnostic(diagnostic, reporter) || hasErrors;
        }
        this.reportSpecialErrors(diagnostics2);
        return hasErrors;
    }

    public final boolean reportToMessageCollector(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        return this.reportByFile(diagnosticsCollector, (Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit>)((Function2)new Function2<KtDiagnostic, CompilerMessageSourceLocation, Unit>(messageCollector){
            final /* synthetic */ MessageCollector $messageCollector;

            public final void invoke(@NotNull KtDiagnostic diagnostic, @NotNull CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                FirDiagnosticsCompilerResultsReporter.access$reportDiagnosticToMessageCollector(FirDiagnosticsCompilerResultsReporter.INSTANCE, diagnostic, location, this.$messageCollector);
            }
            {
                this.$messageCollector = messageCollector;
                super(2);
            }
        }));
    }

    public final boolean throwFirstErrorAsException(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull MessageRenderer messageRenderer) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
        return this.reportByFile(diagnosticsCollector, (Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit>)((Function2)new Function2<KtDiagnostic, CompilerMessageSourceLocation, Unit>(messageRenderer){
            final /* synthetic */ MessageRenderer $messageRenderer;

            public final void invoke(@NotNull KtDiagnostic diagnostic, @NotNull CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                FirDiagnosticsCompilerResultsReporter.access$throwErrorDiagnosticAsException(FirDiagnosticsCompilerResultsReporter.INSTANCE, diagnostic, location, this.$messageRenderer);
            }
            {
                this.$messageRenderer = messageRenderer;
                super(2);
            }
        }));
    }

    public static /* synthetic */ boolean throwFirstErrorAsException$default(FirDiagnosticsCompilerResultsReporter firDiagnosticsCompilerResultsReporter, BaseDiagnosticsCollector baseDiagnosticsCollector, MessageRenderer messageRenderer, int n, Object object) {
        if ((n & 2) != 0) {
            MessageRenderer messageRenderer2 = MessageRenderer.PLAIN_RELATIVE_PATHS;
            Intrinsics.checkNotNullExpressionValue((Object)messageRenderer2, (String)"MessageRenderer.PLAIN_RELATIVE_PATHS");
            messageRenderer = messageRenderer2;
        }
        return firDiagnosticsCompilerResultsReporter.throwFirstErrorAsException(baseDiagnosticsCollector, messageRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reportByFile(@NotNull BaseDiagnosticsCollector diagnosticsCollector, @NotNull Function2<? super KtDiagnostic, ? super CompilerMessageSourceLocation, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter(report2, (String)"report");
        boolean hasErrors = false;
        for (String filePath : diagnosticsCollector.getDiagnosticsByFilePath().keySet()) {
            List list2 = diagnosticsCollector.getDiagnosticsByFilePath().get(filePath);
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            for (KtDiagnostic diagnostic : CollectionsKt.sortedWith((Iterable)list3, (Comparator)SingleFileDiagnosticComparator.INSTANCE)) {
                SequentialFilePositionFinder filePositionFinder = null;
                try {
                    CompilerMessageSourceLocation compilerMessageSourceLocation;
                    CompilerMessageSourceLocation compilerMessageSourceLocation2;
                    if (diagnostic instanceof KtPsiDiagnostic) {
                        compilerMessageSourceLocation2 = this.location(((KtPsiDiagnostic)((Object)diagnostic)).getElement(), diagnostic);
                    } else {
                        filePositionFinder = new SequentialFilePositionFinder(filePath);
                        TextRange textRange = DiagnosticUtils.firstRange(diagnostic.getTextRanges());
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"DiagnosticUtils.firstRange(diagnostic.textRanges)");
                        PsiDiagnosticUtils.LineAndColumn position = SequentialFilePositionFinder.findNextPosition$default(filePositionFinder, textRange.getStartOffset(), false, 2, null);
                        compilerMessageSourceLocation2 = MessageUtil.createMessageLocation(filePath, position.getLineContent(), position.getLine(), position.getColumn(), -1, -1);
                    }
                    if (compilerMessageSourceLocation2 == null) continue;
                    CompilerMessageSourceLocation location = compilerMessageSourceLocation = compilerMessageSourceLocation2;
                    boolean bl = false;
                    report2.invoke((Object)diagnostic, (Object)location);
                    hasErrors = hasErrors || diagnostic.getSeverity() == Severity.ERROR;
                }
                finally {
                    SequentialFilePositionFinder sequentialFilePositionFinder = filePositionFinder;
                    if (sequentialFilePositionFinder == null) continue;
                    sequentialFilePositionFinder.close();
                }
            }
        }
        return hasErrors;
    }

    private final void reportSpecialErrors(Collection<? extends KtDiagnostic> diagnostics2) {
    }

    private final boolean reportDiagnostic(KtDiagnostic diagnostic, MessageCollector reporter) {
        block1: {
            CompilerMessageSourceLocation compilerMessageSourceLocation;
            if (!diagnostic.isValid()) {
                return false;
            }
            CompilerMessageSourceLocation compilerMessageSourceLocation2 = this.location(diagnostic);
            if (compilerMessageSourceLocation2 == null) break block1;
            CompilerMessageSourceLocation it = compilerMessageSourceLocation = compilerMessageSourceLocation2;
            boolean bl = false;
            INSTANCE.reportDiagnosticToMessageCollector(diagnostic, it, reporter);
        }
        return diagnostic.getSeverity() == Severity.ERROR;
    }

    private final void reportDiagnosticToMessageCollector(KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageCollector reporter) {
        CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
        KtDiagnosticRenderer renderer = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic);
        reporter.report(severity, renderer.render(diagnostic), location);
    }

    private final void throwErrorDiagnosticAsException(KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageRenderer messageRenderer) {
        if (diagnostic.getSeverity() == Severity.ERROR) {
            CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
            KtDiagnosticRenderer renderer = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic);
            String diagnosticText = messageRenderer.render(severity, renderer.render(diagnostic), location);
            throw (Throwable)new IllegalStateException(diagnostic.getFactory().getName() + ": " + diagnosticText);
        }
    }

    private final CompilerMessageSourceLocation location(KtDiagnostic $this$location) {
        AbstractKtSourceElement element = $this$location.getElement();
        return element instanceof KtPsiSourceElement ? this.location((KtPsiSourceElement)element, $this$location) : (element instanceof KtLightSourceElement ? this.location((KtLightSourceElement)element, $this$location) : this.genericLocation(element, $this$location));
    }

    private final CompilerMessageSourceLocation location(KtPsiSourceElement $this$location, KtDiagnostic diagnostic) {
        PsiFile file2;
        PsiFile psiFile = file2 = $this$location.getPsi().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
        return MessageUtil.psiFileToMessageLocation(file2, psiFile.getName(), DiagnosticUtils.getLineAndColumnRange(file2, diagnostic.getTextRanges()));
    }

    private final CompilerMessageSourceLocation location(KtLightSourceElement $this$location, KtDiagnostic diagnostic) {
        return null;
    }

    private final CompilerMessageSourceLocation genericLocation(AbstractKtSourceElement $this$genericLocation, KtDiagnostic diagnostic) {
        return null;
    }

    private FirDiagnosticsCompilerResultsReporter() {
    }

    static {
        FirDiagnosticsCompilerResultsReporter firDiagnosticsCompilerResultsReporter;
        INSTANCE = firDiagnosticsCompilerResultsReporter = new FirDiagnosticsCompilerResultsReporter();
    }

    public static final /* synthetic */ void access$reportDiagnosticToMessageCollector(FirDiagnosticsCompilerResultsReporter $this, KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageCollector reporter) {
        $this.reportDiagnosticToMessageCollector(diagnostic, location, reporter);
    }

    public static final /* synthetic */ void access$throwErrorDiagnosticAsException(FirDiagnosticsCompilerResultsReporter $this, KtDiagnostic diagnostic, CompilerMessageSourceLocation location, MessageRenderer messageRenderer) {
        $this.throwErrorDiagnosticAsException(diagnostic, location, messageRenderer);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter$DiagnosticComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "cli"})
    private static final class DiagnosticComparator
    implements Comparator<KtDiagnostic> {
        @NotNull
        public static final DiagnosticComparator INSTANCE;

        @Override
        public int compare(@NotNull KtDiagnostic o1, @NotNull KtDiagnostic o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            AbstractKtSourceElement element1 = o1.getElement();
            AbstractKtSourceElement element2 = o1.getElement();
            if (!(element1 instanceof KtPsiSourceElement) || !(element2 instanceof KtPsiSourceElement)) {
                return 0;
            }
            PsiFile file1 = ((KtPsiSourceElement)element1).getPsi().getContainingFile();
            PsiFile file2 = ((KtPsiSourceElement)element2).getPsi().getContainingFile();
            PsiFile psiFile = file1;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file1");
            FileViewProvider fileViewProvider = psiFile.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file1.viewProvider");
            VirtualFile virtualFile2 = fileViewProvider.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file1.viewProvider.virtualFile");
            String string2 = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file1.viewProvider.virtualFile.path");
            String path1 = string2;
            PsiFile psiFile2 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file2");
            FileViewProvider fileViewProvider2 = psiFile2.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider2, (String)"file2.viewProvider");
            VirtualFile virtualFile3 = fileViewProvider2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"file2.viewProvider.virtualFile");
            String string3 = virtualFile3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file2.viewProvider.virtualFile.path");
            String path2 = string3;
            if (Intrinsics.areEqual((Object)path1, (Object)path2) ^ true) {
                return path1.compareTo(path2);
            }
            TextRange textRange = DiagnosticUtils.firstRange(o1.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"DiagnosticUtils.firstRange(o1.textRanges)");
            TextRange range1 = textRange;
            TextRange textRange2 = DiagnosticUtils.firstRange(o2.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"DiagnosticUtils.firstRange(o2.textRanges)");
            TextRange range2 = textRange2;
            return Intrinsics.areEqual((Object)range1, (Object)range2) ^ true ? DiagnosticUtils.TEXT_RANGE_COMPARATOR.compare(range1, range2) : o1.getFactory().getName().compareTo(o2.getFactory().getName());
        }

        private DiagnosticComparator() {
        }

        static {
            DiagnosticComparator diagnosticComparator;
            INSTANCE = diagnosticComparator = new DiagnosticComparator();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter$SingleFileDiagnosticComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "cli"})
    private static final class SingleFileDiagnosticComparator
    implements Comparator<KtDiagnostic> {
        @NotNull
        public static final SingleFileDiagnosticComparator INSTANCE;

        @Override
        public int compare(@NotNull KtDiagnostic o1, @NotNull KtDiagnostic o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            TextRange textRange = DiagnosticUtils.firstRange(o1.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"DiagnosticUtils.firstRange(o1.textRanges)");
            TextRange range1 = textRange;
            TextRange textRange2 = DiagnosticUtils.firstRange(o2.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"DiagnosticUtils.firstRange(o2.textRanges)");
            TextRange range2 = textRange2;
            return Intrinsics.areEqual((Object)range1, (Object)range2) ^ true ? DiagnosticUtils.TEXT_RANGE_COMPARATOR.compare(range1, range2) : o1.getFactory().getName().compareTo(o2.getFactory().getName());
        }

        private SingleFileDiagnosticComparator() {
        }

        static {
            SingleFileDiagnosticComparator singleFileDiagnosticComparator;
            INSTANCE = singleFileDiagnosticComparator = new SingleFileDiagnosticComparator();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter$SequentialFilePositionFinder;", "Ljava/io/Closeable;", "filePath", "", "(Ljava/lang/String;)V", "bufLength", "", "bufPos", "buffer", "", "charsRead", "currentLine", "currentLineContent", "endOfStream", "", "reader", "Ljava/io/InputStreamReader;", "skipNextLf", "close", "", "findNextPosition", "Lorg/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils$LineAndColumn;", "offset", "withLineContents", "readNextLine", "cli"})
    public static final class SequentialFilePositionFinder
    implements Closeable {
        private InputStreamReader reader;
        private String currentLineContent;
        private final char[] buffer;
        private int bufLength;
        private int bufPos;
        private boolean endOfStream;
        private boolean skipNextLf;
        private int charsRead;
        private int currentLine;
        private final String filePath;

        @NotNull
        public final synchronized PsiDiagnosticUtils.LineAndColumn findNextPosition(int offset2, boolean withLineContents) {
            boolean bl;
            if (offset2 < 0 || this.reader == null) {
                PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.LineAndColumn.NONE;
                Intrinsics.checkNotNullExpressionValue((Object)lineAndColumn, (String)"PsiDiagnosticUtils.LineAndColumn.NONE");
                return lineAndColumn;
            }
            boolean bl2 = bl = offset2 >= this.charsRead;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            while (true) {
                if (this.currentLineContent == null) {
                    this.currentLineContent = this.readNextLine();
                }
                String string3 = this.currentLineContent;
                Intrinsics.checkNotNull((Object)string3);
                int col = offset2 - (this.charsRead - string3.length() - 1) + 1;
                String string4 = this.currentLineContent;
                Intrinsics.checkNotNull((Object)string4);
                if (col <= string4.length()) {
                    return new PsiDiagnosticUtils.LineAndColumn(this.currentLine, col, withLineContents ? this.currentLineContent : null);
                }
                if (this.endOfStream) {
                    PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.LineAndColumn.NONE;
                    Intrinsics.checkNotNullExpressionValue((Object)lineAndColumn, (String)"PsiDiagnosticUtils.LineAndColumn.NONE");
                    return lineAndColumn;
                }
                this.currentLineContent = null;
            }
        }

        public static /* synthetic */ PsiDiagnosticUtils.LineAndColumn findNextPosition$default(SequentialFilePositionFinder sequentialFilePositionFinder, int n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            return sequentialFilePositionFinder.findNextPosition(n, bl);
        }

        private final String readNextLine() {
            StringBuilder stringBuilder2;
            StringBuilder $this$buildString = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            while (true) {
                if (this.bufPos >= this.bufLength) {
                    InputStreamReader inputStreamReader = this.reader;
                    Intrinsics.checkNotNull((Object)inputStreamReader);
                    this.bufLength = inputStreamReader.read(this.buffer);
                    this.bufPos = 0;
                    if (this.bufLength >= 0) continue;
                    this.endOfStream = true;
                    break;
                }
                int n = this.bufPos;
                this.bufPos = n + 1;
                char c = this.buffer[n];
                n = this.charsRead;
                this.charsRead = n + 1;
                if (c == '\n' && this.skipNextLf) {
                    this.skipNextLf = false;
                    continue;
                }
                if (c == '\n' || c == '\r') {
                    n = this.currentLine;
                    this.currentLine = n + 1;
                    this.skipNextLf = c == '\r';
                    break;
                }
                $this$buildString.append(c);
                this.skipNextLf = false;
            }
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @Override
        public void close() {
            block0: {
                InputStreamReader inputStreamReader = this.reader;
                if (inputStreamReader == null) break block0;
                inputStreamReader.close();
            }
        }

        /*
         * Unable to fully structure code
         */
        public SequentialFilePositionFinder(@Nullable String filePath) {
            super();
            this.filePath = filePath;
            v0 = this;
            v1 = this.filePath;
            if (v1 == null) ** GOTO lbl-1000
            var3_3 = var2_2 = v1;
            var5_4 = v0;
            $i$a$-unknown-FirDiagnosticsCompilerResultsReporter$SequentialFilePositionFinder$reader$1 = false;
            var6_6 = new File((String)p1);
            p1 = var2_2 = var6_6;
            $i$a$-takeIf-FirDiagnosticsCompilerResultsReporter$SequentialFilePositionFinder$reader$2 = false;
            var6_7 = it.isFile();
            v0 = var5_4;
            v1 = var6_7 != false ? var2_2 : null;
            if (v1 != null) {
                var2_2 = v1;
                var3_3 = Charsets.UTF_8;
                v2 = new InputStreamReader((InputStream)new FileInputStream((File)var2_2), (Charset)var3_3);
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            v0.reader = v2;
            this.buffer = new char[255];
            this.bufLength = -1;
        }
    }
}

