/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u0012*\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001cH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/VarargLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isEmptyArray", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;)Z", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "addVararg", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilder;", "backend.jvm.lower"})
public final class VarargLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public VarargLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
        if (IrUtilsKt.isAnnotationClass(AdditionalIrUtilsKt.getConstructedClass(constructor2))) {
            return expression2;
        }
        return super.visitConstructorCall(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        IrFunctionSymbol function2 = (IrFunctionSymbol)expression2.getSymbol();
        int n = 0;
        int n2 = expression2.getValueArgumentsCount();
        while (n < n2) {
            IrValueParameter parameter;
            int i;
            if (expression2.getValueArgument(i = n++) != null || (parameter = function2.getOwner().getValueParameters().get(i)).getVarargElementType() == null || IrUtilsKt.hasDefaultValue(parameter)) continue;
            IrType arrayType = IrTypesKt.makeNotNull(IrTypeUtilsKt.substitute(parameter.getType(), IrUtilsKt.getTypeSubstitutionMap(expression2)));
            expression2.putValueArgument(i, IrArrayBuilderKt.irArrayOf$default(VarargLowering.createBuilder$default(this, 0, 0, 3, null), arrayType, null, 2, null));
        }
        if (VarargLoweringKt.isArrayOf(function2.getOwner())) {
            IrExpression irExpression2 = expression2.getValueArgument(0);
            irExpression = irExpression2;
            Intrinsics.checkNotNull((Object)irExpression2);
        } else {
            irExpression = this.isEmptyArray(function2) ? IrArrayBuilderKt.irArrayOf$default(this.createBuilder(expression2.getStartOffset(), expression2.getEndOffset()), expression2.getType(), null, 2, null) : (IrExpression)expression2;
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        void $this$irArray$iv;
        IrArrayBuilder irArrayBuilder;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JvmIrBuilder jvmIrBuilder = this.createBuilder(expression2.getStartOffset(), expression2.getEndOffset());
        IrType arrayType$iv = expression2.getType();
        boolean $i$f$irArray = false;
        IrArrayBuilder $this$irArray_u24lambda_u2d0$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
        boolean bl = false;
        IrArrayBuilder $this$visitVararg_u24lambda_u2d0 = $this$irArray_u24lambda_u2d0$iv;
        boolean bl2 = false;
        this.addVararg($this$visitVararg_u24lambda_u2d0, expression2);
        return irArrayBuilder.build();
    }

    private final void addVararg(IrArrayBuilder $this$addVararg, IrVararg expression2) {
        for (IrVarargElement element : expression2.getElements()) {
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                $this$addVararg.unaryPlus((IrExpression)((IrExpression)element).transform((IrElementTransformer)this, (Object)null));
                continue;
            }
            if (irVarargElement instanceof IrSpreadElement) {
                IrExpression spread = ((IrSpreadElement)element).getExpression();
                if (spread instanceof IrFunctionAccessExpression && VarargLoweringKt.isArrayOf(((IrFunctionSymbol)((IrFunctionAccessExpression)spread).getSymbol()).getOwner())) {
                    IrExpression irExpression = ((IrFunctionAccessExpression)spread).getValueArgument(0);
                    if (irExpression == null) continue;
                    IrExpression argument2 = irExpression;
                    if (argument2 instanceof IrVararg) {
                        this.addVararg($this$addVararg, (IrVararg)argument2);
                        continue;
                    }
                }
                $this$addVararg.addSpread((IrExpression)spread.transform((IrElementTransformer)this, (Object)null));
                continue;
            }
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected IrVarargElement subclass: ", (Object)element).toString());
        }
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(VarargLowering varargLowering, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return varargLowering.createBuilder(n, n2);
    }

    private final boolean isEmptyArray(IrFunctionSymbol $this$isEmptyArray) {
        IrDeclarationParent irDeclarationParent;
        IrPackageFragment irPackageFragment;
        return Intrinsics.areEqual((Object)$this$isEmptyArray.getOwner().getName().asString(), (Object)"emptyArray") && Intrinsics.areEqual((Object)((irPackageFragment = (irDeclarationParent = $this$isEmptyArray.getOwner().getParent()) instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null) == null ? null : irPackageFragment.getFqName()), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME);
    }
}

