/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001c\u0010\u0011\u001a\u00020\t*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a&\u0010\u0016\u001a\u00020\u0017*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "createSourceFilesFromSourceRoots", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "sourceRoots", "", "Lorg/jetbrains/kotlin/cli/common/config/KotlinSourceRoot;", "reportLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "applyModuleProperties", "module", "Lorg/jetbrains/kotlin/modules/Module;", "buildFile", "Ljava/io/File;", "report", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "", "location", "cli"})
public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageLocation location2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$report, (String)"$this$report");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            MessageCollector messageCollector = $this$report.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector == null) break block0;
            messageCollector.report(severity, message2, location2);
        }
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string2, compilerMessageLocation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        PsiManager psiManager = PsiManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager psiManager2 = psiManager;
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        List result2 = new ArrayList();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        for (KotlinSourceRoot kotlinSourceRoot : sourceRoots) {
            void sourceRootPath;
            String string2 = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            VirtualFile vFile = localFileSystem.findFileByPath((String)sourceRootPath);
            if (vFile == null) {
                String message2 = "Source file or directory not found: " + (String)sourceRootPath;
                File buildFilePath = configuration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message2 + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, message2, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && Intrinsics.areEqual((Object)vFile.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
                CoreEnvironmentUtilsKt.report(configuration, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + (String)sourceRootPath, reportLocation);
                continue;
            }
            for (File file2 : FilesKt.walkTopDown((File)new File((String)sourceRootPath))) {
                PsiFile psiFile;
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                if (!file2.isFile()) continue;
                if (localFileSystem.findFileByPath(file2.getAbsolutePath()) != null) {
                    VirtualFile virtualFile4;
                    VirtualFile p1 = virtualFile4;
                    boolean bl = false;
                    virtualFile3 = virtualFileCreator.create(p1);
                } else {
                    virtualFile3 = null;
                }
                if ((virtualFile2 = virtualFile3) == null || !processedFiles.add(virtualFile2) || !((psiFile = psiManager2.findFile(virtualFile2)) instanceof KtFile)) continue;
                result2.add(psiFile);
                if (!isCommon) continue;
                IsCommonSourceKt.setCommonSource((KtFile)psiFile, true);
            }
        }
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list2, compilerMessageLocation);
    }

    @NotNull
    public static final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $this$messageCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$messageCollector, (String)"$this$messageCollector");
        MessageCollector messageCollector = $this$messageCollector.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector;
    }

    @NotNull
    public static final CompilerConfiguration applyModuleProperties(@NotNull CompilerConfiguration $this$applyModuleProperties, @NotNull Module module2, @Nullable File buildFile) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter((Object)$this$applyModuleProperties, (String)"$this$applyModuleProperties");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        CompilerConfiguration $this$apply = compilerConfiguration = $this$applyModuleProperties.copy();
        boolean bl = false;
        if (buildFile != null) {
            Function2 $fun$checkKeyIsNull$1 = new Function2<CompilerConfigurationKey<?>, String, Unit>($this$apply){
                final /* synthetic */ CompilerConfiguration $this_apply;

                public final void invoke(@NotNull CompilerConfigurationKey<?> key, @NotNull String name) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    boolean bl2 = bl = this.$this_apply.get(key) == null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = name + " should be null, when buildFile is used";
                        throw new AssertionError((Object)string2);
                    }
                }
                {
                    this.$this_apply = compilerConfiguration;
                    super(2);
                }
            };
            CompilerConfigurationKey<File> compilerConfigurationKey = JVMConfigurationKeys.OUTPUT_DIRECTORY;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"JVMConfigurationKeys.OUTPUT_DIRECTORY");
            $fun$checkKeyIsNull$1.invoke(compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CompilerConfigurationKey<File> compilerConfigurationKey2 = JVMConfigurationKeys.OUTPUT_JAR;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey2, (String)"JVMConfigurationKeys.OUTPUT_JAR");
            $fun$checkKeyIsNull$1.invoke(compilerConfigurationKey2, "OUTPUT_JAR");
            $this$apply.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(module2.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration2, (String)"copy().apply {\n        i\u2026ctory()))\n        }\n    }");
        return compilerConfiguration2;
    }
}

