/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.ClassicTypeSystemContextForCSKt;
import org.jetbrains.kotlin.resolve.calls.components.ErrorDescriptorResolutionPart;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.inference.DescriptorRelatedInferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.model.GivenCandidate;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.HiddenDescriptor;
import org.jetbrains.kotlin.resolve.calls.tower.HiddenExtensionRelatedToDynamicTypes;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJD\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u000e\u0010 \u001a\u00020\u00022\u0006\u0010-\u001a\u00020.J\"\u0010 \u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020$2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0006\u00103\u001a\u00020\u0002J\u001e\u00104\u001a\u0004\u0018\u00010&2\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u000102H\u0002J\u0016\u00108\u001a\u0004\u0018\u000106*\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u00109\u001a\u0004\u0018\u000106*\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "kotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;)V", "baseSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "getBaseSystem", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "getCallComponents", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "getCallableReferenceResolver", "()Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "getInferenceSession", "()Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "getKotlinCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "getResolutionCallbacks", "()Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "createCandidate", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "dispatchArgumentReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "extensionArgumentReceiver", "initialDiagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "knownSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "givenCandidate", "Lorg/jetbrains/kotlin/resolve/calls/model/GivenCandidate;", "towerCandidate", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "extensionReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "createErrorCandidate", "createReceiverArgument", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "fromResolution", "getExplicitDispatchReceiver", "getExplicitExtensionReceiver", "resolution"})
public final class SimpleCandidateFactory
implements CandidateFactory<KotlinResolutionCandidate> {
    @NotNull
    private final KotlinCallComponents callComponents;
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final KotlinCall kotlinCall;
    @NotNull
    private final KotlinResolutionCallbacks resolutionCallbacks;
    @NotNull
    private final CallableReferenceResolver callableReferenceResolver;
    @NotNull
    private final InferenceSession inferenceSession;
    @NotNull
    private final ConstraintStorage baseSystem;

    public SimpleCandidateFactory(@NotNull KotlinCallComponents callComponents, @NotNull ImplicitScopeTower scopeTower, @NotNull KotlinCall kotlinCall, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull CallableReferenceResolver callableReferenceResolver) {
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        Intrinsics.checkNotNullParameter((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkNotNullParameter((Object)callableReferenceResolver, (String)"callableReferenceResolver");
        this.callComponents = callComponents;
        this.scopeTower = scopeTower;
        this.kotlinCall = kotlinCall;
        this.resolutionCallbacks = resolutionCallbacks;
        this.callableReferenceResolver = callableReferenceResolver;
        this.inferenceSession = this.resolutionCallbacks.getInferenceSession();
        NewConstraintSystemImpl baseSystem = ClassicTypeSystemContextForCSKt.NewConstraintSystemImpl(this.callComponents.getConstraintInjector(), this.callComponents.getBuiltIns());
        if (!this.inferenceSession.resolveReceiverIndependently()) {
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, this.kotlinCall.getExplicitReceiver());
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, this.kotlinCall.getDispatchReceiverForInvokeExtension());
        }
        for (KotlinCallArgument argument2 : this.kotlinCall.getArgumentsInParenthesis()) {
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, argument2);
        }
        DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, this.kotlinCall.getExternalArgument());
        baseSystem.addOtherSystem(this.inferenceSession.currentConstraintSystem());
        this.baseSystem = baseSystem.asReadOnlyStorage();
    }

    @NotNull
    public final KotlinCallComponents getCallComponents() {
        return this.callComponents;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final KotlinCall getKotlinCall() {
        return this.kotlinCall;
    }

    @NotNull
    public final KotlinResolutionCallbacks getResolutionCallbacks() {
        return this.resolutionCallbacks;
    }

    @NotNull
    public final CallableReferenceResolver getCallableReferenceResolver() {
        return this.callableReferenceResolver;
    }

    @NotNull
    public final InferenceSession getInferenceSession() {
        return this.inferenceSession;
    }

    @NotNull
    public final ConstraintStorage getBaseSystem() {
        return this.baseSystem;
    }

    private final SimpleKotlinCallArgument createReceiverArgument(ReceiverKotlinCallArgument explicitReceiver, ReceiverValueWithSmartCastInfo fromResolution) {
        SimpleKotlinCallArgument simpleKotlinCallArgument;
        SimpleKotlinCallArgument simpleKotlinCallArgument2;
        SimpleKotlinCallArgument simpleKotlinCallArgument3 = simpleKotlinCallArgument2 = explicitReceiver instanceof SimpleKotlinCallArgument ? (SimpleKotlinCallArgument)explicitReceiver : null;
        if (simpleKotlinCallArgument2 == null) {
            ReceiverExpressionKotlinCallArgument receiverExpressionKotlinCallArgument;
            ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = fromResolution;
            if (receiverValueWithSmartCastInfo == null) {
                receiverExpressionKotlinCallArgument = null;
            } else {
                ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo2 = receiverValueWithSmartCastInfo;
                boolean bl = false;
                boolean bl2 = false;
                ReceiverValueWithSmartCastInfo it = receiverValueWithSmartCastInfo2;
                boolean bl3 = false;
                receiverExpressionKotlinCallArgument = ReceiverExpressionKotlinCallArgument.Companion.invoke(it, false, this.getKotlinCall().isForImplicitInvoke());
            }
            simpleKotlinCallArgument = receiverExpressionKotlinCallArgument;
        } else {
            simpleKotlinCallArgument = simpleKotlinCallArgument2;
        }
        return simpleKotlinCallArgument;
    }

    private final ReceiverKotlinCallArgument getExplicitDispatchReceiver(KotlinCall $this$getExplicitDispatchReceiver, ExplicitReceiverKind explicitReceiverKind) {
        ReceiverKotlinCallArgument receiverKotlinCallArgument;
        ExplicitReceiverKind explicitReceiverKind2 = explicitReceiverKind;
        int n = WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind2.ordinal()];
        switch (n) {
            case 1: {
                receiverKotlinCallArgument = $this$getExplicitDispatchReceiver.getExplicitReceiver();
                break;
            }
            case 2: {
                receiverKotlinCallArgument = $this$getExplicitDispatchReceiver.getDispatchReceiverForInvokeExtension();
                break;
            }
            default: {
                receiverKotlinCallArgument = null;
            }
        }
        return receiverKotlinCallArgument;
    }

    private final ReceiverKotlinCallArgument getExplicitExtensionReceiver(KotlinCall $this$getExplicitExtensionReceiver, ExplicitReceiverKind explicitReceiverKind) {
        ReceiverKotlinCallArgument receiverKotlinCallArgument;
        ExplicitReceiverKind explicitReceiverKind2 = explicitReceiverKind;
        int n = WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind2.ordinal()];
        switch (n) {
            case 2: 
            case 3: {
                receiverKotlinCallArgument = $this$getExplicitExtensionReceiver.getExplicitReceiver();
                break;
            }
            default: {
                receiverKotlinCallArgument = null;
            }
        }
        return receiverKotlinCallArgument;
    }

    @NotNull
    public final KotlinResolutionCandidate createCandidate(@NotNull GivenCandidate givenCandidate) {
        ReceiverExpressionKotlinCallArgument receiverExpressionKotlinCallArgument;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)givenCandidate, (String)"givenCandidate");
        ReceiverKotlinCallArgument receiverKotlinCallArgument = this.kotlinCall.getExplicitReceiver();
        SimpleKotlinCallArgument simpleKotlinCallArgument = receiverKotlinCallArgument instanceof SimpleKotlinCallArgument ? (SimpleKotlinCallArgument)receiverKotlinCallArgument : null;
        boolean isSafeCall = simpleKotlinCallArgument == null ? false : (bl = simpleKotlinCallArgument.isSafeCall());
        ExplicitReceiverKind explicitReceiverKind = givenCandidate.getDispatchReceiver() == null ? ExplicitReceiverKind.NO_EXPLICIT_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = givenCandidate.getDispatchReceiver();
        if (receiverValueWithSmartCastInfo == null) {
            receiverExpressionKotlinCallArgument = null;
        } else {
            ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo2 = receiverValueWithSmartCastInfo;
            boolean bl2 = false;
            boolean bl3 = false;
            ReceiverValueWithSmartCastInfo it = receiverValueWithSmartCastInfo2;
            boolean bl4 = false;
            receiverExpressionKotlinCallArgument = ReceiverExpressionKotlinCallArgument.Companion.invoke$default(ReceiverExpressionKotlinCallArgument.Companion, it, isSafeCall, false, 4, null);
        }
        ReceiverExpressionKotlinCallArgument dispatchArgumentReceiver = receiverExpressionKotlinCallArgument;
        boolean bl5 = false;
        return this.createCandidate(givenCandidate.getDescriptor(), explicitReceiverKind, dispatchArgumentReceiver, null, CollectionsKt.emptyList(), givenCandidate.getKnownTypeParametersResultingSubstitutor());
    }

    @Override
    @NotNull
    public KotlinResolutionCandidate createCandidate(@NotNull CandidateWithBoundDispatchReceiver towerCandidate, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable ReceiverValueWithSmartCastInfo extensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)towerCandidate, (String)"towerCandidate");
        Intrinsics.checkNotNullParameter((Object)((Object)explicitReceiverKind), (String)"explicitReceiverKind");
        SimpleKotlinCallArgument dispatchArgumentReceiver = this.createReceiverArgument(this.getExplicitDispatchReceiver(this.kotlinCall, explicitReceiverKind), towerCandidate.getDispatchReceiver());
        SimpleKotlinCallArgument extensionArgumentReceiver = this.createReceiverArgument(this.getExplicitExtensionReceiver(this.kotlinCall, explicitReceiverKind), extensionReceiver);
        return this.createCandidate(towerCandidate.getDescriptor(), explicitReceiverKind, dispatchArgumentReceiver, extensionArgumentReceiver, (Collection<? extends KotlinCallDiagnostic>)towerCandidate.getDiagnostics(), null);
    }

    private final KotlinResolutionCandidate createCandidate(CallableDescriptor descriptor2, ExplicitReceiverKind explicitReceiverKind, SimpleKotlinCallArgument dispatchArgumentReceiver, SimpleKotlinCallArgument extensionArgumentReceiver, Collection<? extends KotlinCallDiagnostic> initialDiagnostics, TypeSubstitutor knownSubstitutor) {
        MutableResolvedCallAtom resolvedKtCall = new MutableResolvedCallAtom(this.kotlinCall, descriptor2, explicitReceiverKind, dispatchArgumentReceiver, extensionArgumentReceiver);
        if (ErrorUtils.isError(descriptor2)) {
            return new KotlinResolutionCandidate(this.callComponents, this.resolutionCallbacks, this.callableReferenceResolver, this.scopeTower, this.baseSystem, resolvedKtCall, knownSubstitutor, CollectionsKt.listOf((Object)ErrorDescriptorResolutionPart.INSTANCE));
        }
        KotlinResolutionCandidate candidate2 = new KotlinResolutionCandidate(this.callComponents, this.resolutionCallbacks, this.callableReferenceResolver, this.scopeTower, this.baseSystem, resolvedKtCall, knownSubstitutor, null, 128, null);
        Iterable $this$forEach$iv = initialDiagnostics;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallDiagnostic p0 = (KotlinCallDiagnostic)element$iv;
            boolean bl = false;
            candidate2.addDiagnostic(p0);
        }
        if (this.callComponents.getStatelessCallbacks().isHiddenInResolution((DeclarationDescriptor)descriptor2, this.kotlinCall, this.resolutionCallbacks)) {
            candidate2.addDiagnostic(HiddenDescriptor.INSTANCE);
        }
        if (extensionArgumentReceiver != null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
            KotlinType $i$f$forEach2 = receiverParameterDescriptor.getValue().getType();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach2, (String)"descriptor.extensionReceiverParameter!!.value.type");
            boolean parameterIsDynamic = DynamicTypesKt.isDynamic($i$f$forEach2);
            KotlinType kotlinType = extensionArgumentReceiver.getReceiver().getReceiverValue().getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"extensionArgumentReceive\u2026ceiver.receiverValue.type");
            boolean argumentIsDynamic = DynamicTypesKt.isDynamic(kotlinType);
            if (parameterIsDynamic != argumentIsDynamic || parameterIsDynamic && !AnnotationsForResolveUtilsKt.hasDynamicExtensionAnnotation(descriptor2)) {
                candidate2.addDiagnostic(HiddenExtensionRelatedToDynamicTypes.INSTANCE);
            }
        }
        return candidate2;
    }

    @NotNull
    public final KotlinResolutionCandidate createErrorCandidate() {
        MemberScope memberScope2 = ErrorUtils.createErrorScope(Intrinsics.stringPlus((String)"Error resolution candidate for call ", (Object)this.kotlinCall));
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"createErrorScope(\"Error \u2026te for call $kotlinCall\")");
        MemberScope errorScope = memberScope2;
        CallableMemberDescriptor errorDescriptor = (CallableMemberDescriptor)CollectionsKt.first((Iterable)(this.kotlinCall.getCallKind() == KotlinCallKind.VARIABLE ? errorScope.getContributedVariables(this.kotlinCall.getName(), this.scopeTower.getLocation()) : errorScope.getContributedFunctions(this.kotlinCall.getName(), this.scopeTower.getLocation())));
        SimpleKotlinCallArgument dispatchReceiver = this.createReceiverArgument(this.kotlinCall.getExplicitReceiver(), null);
        ExplicitReceiverKind explicitReceiverKind = dispatchReceiver == null ? ExplicitReceiverKind.NO_EXPLICIT_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
        boolean bl = false;
        return this.createCandidate(errorDescriptor, explicitReceiverKind, dispatchReceiver, null, CollectionsKt.emptyList(), null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 2;
            nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

