/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J$\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SuspensionPointInsideMutexLockChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCall", "", "parent", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "child", "insideLambda", "reportProblem", "frontend.java"})
public final class SuspensionPointInsideMutexLockChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        SourceElement sourceElement;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
            return;
        }
        FunctionDescriptor functionDescriptor = CoroutineCallCheckerKt.findEnclosingSuspendFunction(context2);
        PsiElement psiElement2 = functionDescriptor == null ? null : (psiElement = (sourceElement = functionDescriptor.getSource()) == null ? null : KotlinSourceElementKt.getPsi(sourceElement));
        if (psiElement == null) {
            return;
        }
        PsiElement enclosingSuspendFunctionSource = psiElement;
        PsiElement parent2 = reportOn;
        PsiElement child = reportOn;
        boolean insideLambda = false;
        while (!(Intrinsics.areEqual((Object)parent2, (Object)enclosingSuspendFunctionSource) || parent2 instanceof KtCallExpression && this.checkCall(context2, (KtCallExpression)parent2, child, insideLambda, reportOn, resolvedCall2))) {
            PsiElement psiElement3;
            if (parent2 instanceof KtLambdaExpression) {
                insideLambda = true;
            }
            if (!(parent2 instanceof KtValueArgumentList)) {
                child = parent2;
            }
            if ((psiElement3 = parent2.getParent()) == null) {
                return;
            }
            parent2 = psiElement3;
        }
    }

    private final boolean checkCall(CallCheckerContext context2, KtCallExpression parent2, PsiElement child, boolean insideLambda, PsiElement reportOn, ResolvedCall<?> resolvedCall2) {
        Call call2;
        Object object = (Call)context2.getTrace().get(BindingContext.CALL, parent2.getCalleeExpression());
        if (object == null) {
            return false;
        }
        Call call3 = call2 = object;
        ResolvedCall resolvedCall3 = (ResolvedCall)context2.getTrace().get(BindingContext.RESOLVED_CALL, call3);
        if (resolvedCall3 == null) {
            return false;
        }
        Object resolved = object = resolvedCall3;
        resolvedCall3 = resolved.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedCall3, (String)"resolved.resultingDescriptor");
        boolean isSynchronized = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)((Object)resolvedCall3), "synchronized", "kotlin");
        if (isSynchronized) {
            List<ResolvedValueArgument> list2 = resolved.getValueArgumentsByIndex();
            ResolvedValueArgument resolvedValueArgument = list2 == null ? null : list2.get(1);
            ExpressionValueArgument expressionValueArgument = resolvedValueArgument instanceof ExpressionValueArgument ? (ExpressionValueArgument)resolvedValueArgument : null;
            boolean isSecondArgument = Intrinsics.areEqual((Object)(expressionValueArgument == null ? null : expressionValueArgument.getValueArgument()), (Object)child);
            if (insideLambda && isSecondArgument) {
                this.reportProblem(context2, reportOn, resolvedCall2);
            }
            return true;
        }
        Object d = resolved.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, (String)"resolved.resultingDescriptor");
        boolean isWithLock = DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)d, "withLock", "kotlin.concurrent");
        if (isWithLock) {
            this.reportProblem(context2, reportOn, resolvedCall2);
            return true;
        }
        return false;
    }

    private final void reportProblem(CallCheckerContext context2, PsiElement reportOn, ResolvedCall<?> resolvedCall2) {
        context2.getTrace().report(ErrorsJvm.SUSPENSION_POINT_INSIDE_CRITICAL_SECTION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
    }
}

