/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B[\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007\u00a2\u0006\u0002\u0010\u0012J5\u0010+\u001a\u00020,\"\u0004\b\u0000\u0010-\"\u0004\b\u0001\u0010.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u0002H.002\u0006\u00101\u001a\u0002H.H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\u000fH\u0016J\u0016\u00105\u001a\u00020,2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001107H\u0016J\u0010\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020\u0005H\u0016J)\u0010:\u001a\u00020\u0000\"\u0004\b\u0000\u0010.2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H.0<2\u0006\u00101\u001a\u0002H.H\u0016\u00a2\u0006\u0002\u0010=J)\u0010>\u001a\u00020\u0000\"\u0004\b\u0000\u0010.2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H.0<2\u0006\u00101\u001a\u0002H.H\u0016\u00a2\u0006\u0002\u0010=J)\u0010?\u001a\u00020\u0000\"\u0004\b\u0000\u0010.2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H.0<2\u0006\u00101\u001a\u0002H.H\u0016\u00a2\u0006\u0002\u0010=R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/impl/FirResolvedQualifierImpl;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "relativeClassFqName", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isNullableLHSForCallableReference", "", "typeArguments", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Ljava/util/List;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;ZLjava/util/List;)V", "getAnnotations", "()Ljava/util/List;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "()Z", "setNullableLHSForCallableReference", "(Z)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "setPackageFqName", "(Lorg/jetbrains/kotlin/name/FqName;)V", "getRelativeClassFqName", "setRelativeClassFqName", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getTypeArguments", "getTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "acceptChildren", "", "R", "D", "visitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "data", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;Ljava/lang/Object;)V", "replaceIsNullableLHSForCallableReference", "newIsNullableLHSForCallableReference", "replaceTypeArguments", "newTypeArguments", "", "replaceTypeRef", "newTypeRef", "transformAnnotations", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "(Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/impl/FirResolvedQualifierImpl;", "transformChildren", "transformTypeArguments", "tree"})
public final class FirResolvedQualifierImpl
extends FirResolvedQualifier {
    @Nullable
    private final FirSourceElement source;
    @NotNull
    private FirTypeRef typeRef;
    @NotNull
    private final List<FirAnnotationCall> annotations;
    @NotNull
    private FqName packageFqName;
    @Nullable
    private FqName relativeClassFqName;
    @Nullable
    private final FirClassLikeSymbol<?> symbol;
    private boolean isNullableLHSForCallableReference;
    @NotNull
    private final List<FirTypeProjection> typeArguments;

    public FirResolvedQualifierImpl(@Nullable FirSourceElement source, @NotNull FirTypeRef typeRef, @NotNull List<FirAnnotationCall> annotations2, @NotNull FqName packageFqName, @Nullable FqName relativeClassFqName, @Nullable FirClassLikeSymbol<?> symbol2, boolean isNullableLHSForCallableReference, @NotNull List<FirTypeProjection> typeArguments2) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        this.source = source;
        this.typeRef = typeRef;
        this.annotations = annotations2;
        this.packageFqName = packageFqName;
        this.relativeClassFqName = relativeClassFqName;
        this.symbol = symbol2;
        this.isNullableLHSForCallableReference = isNullableLHSForCallableReference;
        this.typeArguments = typeArguments2;
    }

    @Override
    @Nullable
    public FirSourceElement getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public FirTypeRef getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(@NotNull FirTypeRef firTypeRef) {
        Intrinsics.checkNotNullParameter((Object)firTypeRef, (String)"<set-?>");
        this.typeRef = firTypeRef;
    }

    @Override
    @NotNull
    public List<FirAnnotationCall> getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        return this.packageFqName;
    }

    public void setPackageFqName(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"<set-?>");
        this.packageFqName = fqName2;
    }

    @Override
    @Nullable
    public FqName getRelativeClassFqName() {
        return this.relativeClassFqName;
    }

    public void setRelativeClassFqName(@Nullable FqName fqName2) {
        this.relativeClassFqName = fqName2;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isNullableLHSForCallableReference() {
        return this.isNullableLHSForCallableReference;
    }

    public void setNullableLHSForCallableReference(boolean bl) {
        this.isNullableLHSForCallableReference = bl;
    }

    @Override
    @NotNull
    public List<FirTypeProjection> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @Nullable
    public ClassId getClassId() {
        ClassId classId;
        FqName fqName2 = this.getRelativeClassFqName();
        if (fqName2 == null) {
            classId = null;
        } else {
            FqName fqName3 = fqName2;
            boolean bl = false;
            boolean bl2 = false;
            FqName it = fqName3;
            boolean bl3 = false;
            classId = new ClassId(this.getPackageFqName(), it, false);
        }
        return classId;
    }

    @Override
    public <R, D> void acceptChildren(@NotNull FirVisitor<? extends R, ? super D> visitor2, D data) {
        FirPureAbstractElement it;
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        this.getTypeRef().accept(visitor2, data);
        Iterable $this$forEach$iv = this.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirAnnotationCall)element$iv;
            boolean bl = false;
            ((FirAnnotationCall)it).accept(visitor2, data);
        }
        $this$forEach$iv = this.getTypeArguments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirTypeProjection)element$iv;
            boolean bl = false;
            ((FirTypeProjection)it).accept(visitor2, data);
        }
    }

    @Override
    @NotNull
    public <D> FirResolvedQualifierImpl transformChildren(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        this.setTypeRef((FirTypeRef)this.getTypeRef().transform(transformer2, data));
        this.transformAnnotations((FirTransformer)transformer2, (Object)data);
        this.transformTypeArguments((FirTransformer)transformer2, (Object)data);
        return this;
    }

    @Override
    @NotNull
    public <D> FirResolvedQualifierImpl transformAnnotations(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        FirTransformerUtilKt.transformInplace(this.getAnnotations(), transformer2, data);
        return this;
    }

    @Override
    @NotNull
    public <D> FirResolvedQualifierImpl transformTypeArguments(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        FirTransformerUtilKt.transformInplace(this.getTypeArguments(), transformer2, data);
        return this;
    }

    @Override
    public void replaceTypeRef(@NotNull FirTypeRef newTypeRef) {
        Intrinsics.checkNotNullParameter((Object)newTypeRef, (String)"newTypeRef");
        this.setTypeRef(newTypeRef);
    }

    @Override
    public void replaceIsNullableLHSForCallableReference(boolean newIsNullableLHSForCallableReference) {
        this.setNullableLHSForCallableReference(newIsNullableLHSForCallableReference);
    }

    @Override
    public void replaceTypeArguments(@NotNull List<? extends FirTypeProjection> newTypeArguments) {
        Intrinsics.checkNotNullParameter(newTypeArguments, (String)"newTypeArguments");
        this.getTypeArguments().clear();
        this.getTypeArguments().addAll((Collection<FirTypeProjection>)newTypeArguments);
    }
}

