/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.PersistentCheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.AbstractFirDiagnosticFactory;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020(0.2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H&J\u0012\u0010/\u001a\u00020\u00042\n\u00100\u001a\u0006\u0012\u0002\b\u000301R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "", "()V", "allErrorsSuppressed", "", "getAllErrorsSuppressed", "()Z", "allInfosSuppressed", "getAllInfosSuppressed", "allWarningsSuppressed", "getAllWarningsSuppressed", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingDeclarations", "()Ljava/util/List;", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getGetClassCalls", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "qualifiedAccesses", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "getQualifiedAccesses", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "getReturnTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getSessionHolder", "()Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "suppressedDiagnostics", "", "", "getSuppressedDiagnostics", "()Ljava/util/Set;", "addSuppressedDiagnostics", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/PersistentCheckerContext;", "diagnosticNames", "", "isDiagnosticSuppressed", "diagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "checkers"})
public abstract class CheckerContext {
    @NotNull
    public abstract SessionHolder getSessionHolder();

    @NotNull
    public abstract ReturnTypeCalculator getReturnTypeCalculator();

    @NotNull
    public abstract ImplicitReceiverStack getImplicitReceiverStack();

    @NotNull
    public abstract List<FirDeclaration> getContainingDeclarations();

    @NotNull
    public abstract List<FirQualifiedAccess> getQualifiedAccesses();

    @NotNull
    public abstract List<FirGetClassCall> getGetClassCalls();

    @NotNull
    public abstract Set<String> getSuppressedDiagnostics();

    public abstract boolean getAllInfosSuppressed();

    public abstract boolean getAllWarningsSuppressed();

    public abstract boolean getAllErrorsSuppressed();

    @NotNull
    public final FirSession getSession() {
        return this.getSessionHolder().getSession();
    }

    @NotNull
    public abstract PersistentCheckerContext addSuppressedDiagnostics(@NotNull Collection<String> var1, boolean var2, boolean var3, boolean var4);

    public final boolean isDiagnosticSuppressed(@NotNull FirDiagnostic<?> diagnostic) {
        boolean bl;
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        AbstractFirDiagnosticFactory<?, ?> factory2 = diagnostic.getFactory();
        String name = factory2.getName();
        Severity severity = factory2.getSeverity();
        int n = WhenMappings.$EnumSwitchMapping$0[severity.ordinal()];
        switch (n) {
            case 1: {
                bl = this.getAllInfosSuppressed();
                break;
            }
            case 2: {
                bl = this.getAllWarningsSuppressed();
                break;
            }
            case 3: {
                bl = this.getAllErrorsSuppressed();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean suppressedByAll = bl;
        return suppressedByAll || this.getSuppressedDiagnostics().contains(name);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            nArray[Severity.INFO.ordinal()] = 1;
            nArray[Severity.WARNING.ordinal()] = 2;
            nArray[Severity.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

