/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "deadCodeElimination", "Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer;", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "ConstantConditionsOptimization", "ConstantPropagationInterpreter", "IConstValue", "backend"})
public final class ConstantConditionEliminationMethodTransformer
extends MethodTransformer {
    @NotNull
    private final DeadCodeEliminationMethodTransformer deadCodeElimination = new DeadCodeEliminationMethodTransformer();

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        boolean changes;
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        do {
            if (!(changes = new ConstantConditionsOptimization(internalClassName, methodNode).run())) continue;
            this.deadCodeElimination.transform(internalClassName, methodNode);
        } while (changes);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0002JD\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\"\u0010\u0015\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0016j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u0017H\u0002J4\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\"\u0010\u0015\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0016j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u0017H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJB\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\"\u0010\u0015\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0016j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u0017H\u0002JB\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\"\u0010\u0015\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0016j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer$ConstantConditionsOptimization;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "getInternalClassName", "()Ljava/lang/String;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "collectRewriteActions", "", "Lkotlin/Function0;", "", "rewriteBinaryComparisonOfConsts", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "value1", "", "value2", "actions", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "rewriteBinaryComparisonWith0", "run", "", "tryRewriteBinaryComparison", "frame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "tryRewriteComparisonWithZero", "backend"})
    private static final class ConstantConditionsOptimization {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;

        public ConstantConditionsOptimization(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
        }

        @NotNull
        public final String getInternalClassName() {
            return this.internalClassName;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public final boolean run() {
            List<Function0<Unit>> actions = this.collectRewriteActions();
            Iterable $this$forEach$iv = actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
            Collection collection = actions;
            boolean bl = false;
            return !collection.isEmpty();
        }

        private final List<Function0<Unit>> collectRewriteActions() {
            boolean bl = false;
            ArrayList<Function0<Unit>> arrayList = new ArrayList<Function0<Unit>>();
            boolean bl2 = false;
            boolean bl3 = false;
            ArrayList<Function0<Unit>> actions = arrayList;
            boolean bl4 = false;
            Frame<V>[] frameArray = MethodTransformer.analyze(this.getInternalClassName(), this.getMethodNode(), new ConstantPropagationInterpreter());
            Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(internalClassName, methodNode, ConstantPropagationInterpreter())");
            Frame<V>[] frames2 = frameArray;
            AbstractInsnNode[] insns = this.getMethodNode().instructions.toArray();
            int n = 0;
            int n2 = frames2.length + -1;
            if (n <= n2) {
                do {
                    JumpInsnNode jumpInsnNode;
                    int i;
                    Frame<BasicValue> frame;
                    if ((frame = frames2[i = n++]) == null) continue;
                    Frame<BasicValue> frame2 = frame;
                    AbstractInsnNode abstractInsnNode = insns[i];
                    JumpInsnNode jumpInsnNode2 = jumpInsnNode = abstractInsnNode instanceof JumpInsnNode ? (JumpInsnNode)abstractInsnNode : null;
                    if (jumpInsnNode == null) continue;
                    JumpInsnNode insn = jumpInsnNode;
                    int n3 = insn.getOpcode();
                    boolean bl5 = 153 <= n3 ? n3 <= 158 : false;
                    if (bl5) {
                        this.tryRewriteComparisonWithZero(insn, frame2, actions);
                        continue;
                    }
                    boolean bl6 = 159 <= n3 ? n3 <= 164 : false;
                    if (!bl6) continue;
                    this.tryRewriteBinaryComparison(insn, frame2, actions);
                } while (n <= n2);
            }
            return arrayList;
        }

        private final void tryRewriteComparisonWithZero(JumpInsnNode insn, Frame<BasicValue> frame, ArrayList<Function0<Unit>> actions) {
            boolean bl;
            IConstValue iConstValue;
            BasicValue basicValue = StackTransformationUtilsKt.top(frame);
            Intrinsics.checkNotNull((Object)basicValue);
            BasicValue $this$safeAs$iv = basicValue;
            boolean $i$f$safeAs = false;
            BasicValue basicValue2 = $this$safeAs$iv;
            if (!(basicValue2 instanceof IConstValue)) {
                basicValue2 = null;
            }
            if ((iConstValue = (IConstValue)basicValue2) == null) {
                return;
            }
            IConstValue top = iConstValue;
            int n = insn.getOpcode();
            switch (n) {
                case 153: {
                    if (top.getValue() == 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 154: {
                    if (top.getValue() != 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 156: {
                    if (top.getValue() >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 157: {
                    if (top.getValue() > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 158: {
                    if (top.getValue() <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 155: {
                    if (top.getValue() < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected instruction: ", (Object)InlineCodegenUtilsKt.getInsnText(insn)));
                }
            }
            boolean constCondition = bl;
            actions.add(new Function0<Unit>(this, insn, constCondition){
                final /* synthetic */ ConstantConditionsOptimization this$0;
                final /* synthetic */ JumpInsnNode $insn;
                final /* synthetic */ boolean $constCondition;
                {
                    this.this$0 = $receiver;
                    this.$insn = $insn;
                    this.$constCondition = $constCondition;
                    super(0);
                }

                public final void invoke() {
                    InsnList insnList = this.this$0.getMethodNode().instructions;
                    JumpInsnNode jumpInsnNode = this.$insn;
                    boolean bl = this.$constCondition;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    InsnList $this$invoke_u24lambda_u2d0 = insnList;
                    boolean bl4 = false;
                    $this$invoke_u24lambda_u2d0.insertBefore((AbstractInsnNode)jumpInsnNode, new InsnNode(87));
                    if (bl) {
                        $this$invoke_u24lambda_u2d0.set(jumpInsnNode, new JumpInsnNode(167, jumpInsnNode.label));
                    } else {
                        $this$invoke_u24lambda_u2d0.remove(jumpInsnNode);
                    }
                }
            });
        }

        private final void tryRewriteBinaryComparison(JumpInsnNode insn, Frame<BasicValue> frame, ArrayList<Function0<Unit>> actions) {
            BasicValue basicValue = StackTransformationUtilsKt.peek(frame, 1);
            Intrinsics.checkNotNull((Object)basicValue);
            BasicValue arg1 = basicValue;
            BasicValue basicValue2 = StackTransformationUtilsKt.peek(frame, 0);
            Intrinsics.checkNotNull((Object)basicValue2);
            BasicValue arg2 = basicValue2;
            if (arg1 instanceof IConstValue && arg2 instanceof IConstValue) {
                this.rewriteBinaryComparisonOfConsts(insn, ((IConstValue)arg1).getValue(), ((IConstValue)arg2).getValue(), actions);
            } else if (arg2 instanceof IConstValue && ((IConstValue)arg2).getValue() == 0) {
                this.rewriteBinaryComparisonWith0(insn, actions);
            }
        }

        private final void rewriteBinaryComparisonOfConsts(JumpInsnNode insn, int value1, int value2, ArrayList<Function0<Unit>> actions) {
            boolean bl;
            int n = insn.getOpcode();
            switch (n) {
                case 159: {
                    if (value1 == value2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 160: {
                    if (value1 != value2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 164: {
                    if (value1 <= value2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 161: {
                    if (value1 < value2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 162: {
                    if (value1 >= value2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 163: {
                    if (value1 > value2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected instruction: ", (Object)InlineCodegenUtilsKt.getInsnText(insn)));
                }
            }
            boolean constCondition = bl;
            actions.add(new Function0<Unit>(this, insn, constCondition){
                final /* synthetic */ ConstantConditionsOptimization this$0;
                final /* synthetic */ JumpInsnNode $insn;
                final /* synthetic */ boolean $constCondition;
                {
                    this.this$0 = $receiver;
                    this.$insn = $insn;
                    this.$constCondition = $constCondition;
                    super(0);
                }

                public final void invoke() {
                    InsnList insnList = this.this$0.getMethodNode().instructions;
                    JumpInsnNode jumpInsnNode = this.$insn;
                    boolean bl = this.$constCondition;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    InsnList $this$invoke_u24lambda_u2d0 = insnList;
                    boolean bl4 = false;
                    $this$invoke_u24lambda_u2d0.insertBefore((AbstractInsnNode)jumpInsnNode, new InsnNode(87));
                    $this$invoke_u24lambda_u2d0.insertBefore((AbstractInsnNode)jumpInsnNode, new InsnNode(87));
                    if (bl) {
                        $this$invoke_u24lambda_u2d0.set(jumpInsnNode, new JumpInsnNode(167, jumpInsnNode.label));
                    } else {
                        $this$invoke_u24lambda_u2d0.remove(jumpInsnNode);
                    }
                }
            });
        }

        private final void rewriteBinaryComparisonWith0(JumpInsnNode insn, ArrayList<Function0<Unit>> actions) {
            actions.add(new Function0<Unit>(this, insn){
                final /* synthetic */ ConstantConditionsOptimization this$0;
                final /* synthetic */ JumpInsnNode $insn;
                {
                    this.this$0 = $receiver;
                    this.$insn = $insn;
                    super(0);
                }

                public final void invoke() {
                    int n;
                    InsnList insnList = this.this$0.getMethodNode().instructions;
                    JumpInsnNode jumpInsnNode = this.$insn;
                    boolean bl = false;
                    boolean bl2 = false;
                    InsnList $this$invoke_u24lambda_u2d0 = insnList;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u2d0.insertBefore((AbstractInsnNode)jumpInsnNode, new InsnNode(87));
                    int n2 = jumpInsnNode.getOpcode();
                    switch (n2) {
                        case 159: {
                            n = 153;
                            break;
                        }
                        case 160: {
                            n = 154;
                            break;
                        }
                        case 164: {
                            n = 158;
                            break;
                        }
                        case 161: {
                            n = 155;
                            break;
                        }
                        case 162: {
                            n = 156;
                            break;
                        }
                        case 163: {
                            n = 157;
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected instruction: ", (Object)InlineCodegenUtilsKt.getInsnText(jumpInsnNode)));
                        }
                    }
                    int cmpWith0Opcode = n;
                    $this$invoke_u24lambda_u2d0.set(jumpInsnNode, new JumpInsnNode(cmpWith0Opcode, jumpInsnNode.label));
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer$IConstValue;", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "value", "", "(I)V", "getValue", "()I", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "backend"})
    private static final class IConstValue
    extends StrictBasicValue {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int value;
        @NotNull
        private static final IConstValue[] ICONST_CACHE;

        private IConstValue(int value2) {
            super(Type.INT_TYPE);
            this.value = value2;
        }

        public final int getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other == this || other instanceof IConstValue && ((IConstValue)other).value == this.value;
        }

        @Override
        public int hashCode() {
            return this.value;
        }

        @Override
        @NotNull
        public String toString() {
            return "IConst(" + this.value + ')';
        }

        public /* synthetic */ IConstValue(int value2, DefaultConstructorMarker $constructor_marker) {
            this(value2);
        }

        static {
            int n = 0;
            IConstValue[] iConstValueArray = new IConstValue[7];
            while (n < 7) {
                int n2 = n++;
                iConstValueArray[n2] = new IConstValue(n2 - 1);
            }
            ICONST_CACHE = iConstValueArray;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer$IConstValue$Companion;", "", "()V", "ICONST_CACHE", "", "Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer$IConstValue;", "[Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer$IConstValue;", "of", "value", "", "backend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final IConstValue of(int value2) {
                return (-1 <= value2 ? value2 <= 5 : false) ? ICONST_CACHE[value2 + 1] : new IConstValue(value2, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer$ConstantPropagationInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "()V", "merge", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "v", "w", "newOperation", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "backend"})
    private static final class ConstantPropagationInterpreter
    extends OptimizationBasicInterpreter {
        @Override
        @NotNull
        public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
            BasicValue basicValue;
            Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
            int n = insn.getOpcode();
            boolean bl = 2 <= n ? n <= 8 : false;
            if (bl) {
                basicValue = IConstValue.Companion.of(insn.getOpcode() - 3);
            } else if (n == 16 ? true : n == 17) {
                AbstractInsnNode $this$cast$iv = insn;
                boolean $i$f$cast = false;
                basicValue = IConstValue.Companion.of(((IntInsnNode)$this$cast$iv).operand);
            } else if (n == 18) {
                AbstractInsnNode $this$cast$iv = insn;
                boolean $i$f$cast = false;
                Object operand = ((LdcInsnNode)$this$cast$iv).cst;
                BasicValue basicValue2 = operand instanceof Integer ? (BasicValue)IConstValue.Companion.of(((Number)operand).intValue()) : super.newOperation(insn);
                Intrinsics.checkNotNullExpressionValue((Object)basicValue2, (String)"{\n                    val operand = insn.cast<LdcInsnNode>().cst\n                    if (operand is Int)\n                        IConstValue.of(operand)\n                    else\n                        super.newOperation(insn)\n                }");
                basicValue = basicValue2;
            } else {
                BasicValue basicValue3 = super.newOperation(insn);
                Intrinsics.checkNotNullExpressionValue((Object)basicValue3, (String)"super.newOperation(insn)");
                basicValue = basicValue3;
            }
            return basicValue;
        }

        @Override
        @NotNull
        public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
            BasicValue basicValue;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            if (v instanceof IConstValue && w instanceof IConstValue && Intrinsics.areEqual((Object)v, (Object)w)) {
                basicValue = v;
            } else {
                BasicValue basicValue2 = super.merge(v, w);
                Intrinsics.checkNotNullExpressionValue((Object)basicValue2, (String)"super.merge(v, w)");
                basicValue = basicValue2;
            }
            return basicValue;
        }
    }
}

