/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.IllegalDataException;
import org.jetbrains.kotlin.org.jdom.Parent;
import org.jetbrains.kotlin.org.jdom.Verifier;
import org.jetbrains.kotlin.org.jdom.output.XMLOutputter2;

public class Comment
extends Content {
    protected String text;

    protected Comment() {
        super(Content.CType.Comment);
    }

    public Comment(String text2) {
        super(Content.CType.Comment);
        this.setText(text2);
    }

    @Override
    public String getValue() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public Comment setText(String text2) {
        String reason = Verifier.checkCommentData(text2);
        if (reason != null) {
            throw new IllegalDataException(text2, "comment", reason);
        }
        this.text = text2;
        return this;
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    @Override
    public Comment detach() {
        return (Comment)super.detach();
    }

    @Override
    protected Comment setParent(Parent parent2) {
        return (Comment)super.setParent(parent2);
    }

    public String toString() {
        return "[Comment: " + new XMLOutputter2().outputString(this) + "]";
    }
}

