/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JetNodeType;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementType;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.JetLexer;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.parsing.JetParser;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetParserDefinition
implements ParserDefinition {
    public static final String STD_SCRIPT_SUFFIX = "kts";
    public static final String STD_SCRIPT_EXT = ".kts";

    @NotNull
    public static JetParserDefinition getInstance() {
        JetParserDefinition jetParserDefinition = (JetParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(JetLanguage.INSTANCE);
        if (jetParserDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "getInstance"));
        }
        return jetParserDefinition;
    }

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        JetLexer jetLexer = new JetLexer();
        if (jetLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "createLexer"));
        }
        return jetLexer;
    }

    @Override
    public PsiParser createParser(Project project) {
        return new JetParser(project);
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JetStubElementTypes.FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JetTokens.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JetTokens.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JetTokens.STRINGS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        IElementType elementType = astNode.getElementType();
        if (elementType instanceof JetStubElementType) {
            Object PsiT = ((JetStubElementType)elementType).createPsiFromAst(astNode);
            if (PsiT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "createElement"));
            }
            return PsiT;
        }
        if (elementType == JetNodeTypes.TYPE_CODE_FRAGMENT || elementType == JetNodeTypes.EXPRESSION_CODE_FRAGMENT || elementType == JetNodeTypes.BLOCK_CODE_FRAGMENT) {
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(astNode);
            if (aSTWrapperPsiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "createElement"));
            }
            return aSTWrapperPsiElement;
        }
        if (elementType instanceof KDocElementType) {
            PsiElement psiElement = ((KDocElementType)elementType).createPsi(astNode);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (elementType == KDocTokens.MARKDOWN_LINK) {
            KDocLink kDocLink = new KDocLink(astNode);
            if (kDocLink == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "createElement"));
            }
            return kDocLink;
        }
        JetElement jetElement = ((JetNodeType)elementType).createPsi(astNode);
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParserDefinition", "createElement"));
        }
        return jetElement;
    }

    @Override
    public PsiFile createFile(FileViewProvider fileViewProvider) {
        return new JetFile(fileViewProvider, false);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode astNode, ASTNode astNode1) {
        IElementType rightTokenType = astNode1.getElementType();
        if (rightTokenType == JetTokens.GET_KEYWORD || rightTokenType == JetTokens.SET_KEYWORD) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

