/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    private final List<JsStatement> result;

    public InitializerVisitor(List<JsStatement> result2) {
        this.result = result2;
    }

    @Override
    protected Void emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "emptyResult"));
        }
        return null;
    }

    @Override
    public final Void visitProperty(@NotNull JetProperty property, @NotNull TranslationContext context) {
        JsStatement delegate2;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        JetExpression initializer = property.getInitializer();
        if (initializer != null) {
            this.result.add(InitializerUtils.generateInitializerForProperty(context, BindingUtils.getPropertyDescriptor(context.bindingContext(), property), Translation.translateAsExpression(initializer, context)));
        }
        if ((delegate2 = InitializerUtils.generateInitializerForDelegate(context, property)) != null) {
            this.result.add(delegate2);
        }
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull JetClassInitializer initializer, @NotNull TranslationContext context) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        JetExpression initializerBody = initializer.getBody();
        if (initializerBody != null) {
            this.result.add(Translation.translateAsStatementAndMergeInBlockIfNeeded(initializerBody, context));
        }
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull JetDeclaration expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        return null;
    }

    @Override
    public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitObjectDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitObjectDeclaration"));
        }
        if (!declaration.isCompanion()) {
            InitializerUtils.generateObjectInitializer(declaration, this.result, context);
        }
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull JetSecondaryConstructor constructor, TranslationContext data2) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitSecondaryConstructor"));
        }
        return null;
    }
}

