/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetConstructor;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetElementImpl;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetWhenConditionInRange;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"3$))\u0002k\\:ji&|g.\u001b8h'R\u0014\u0018\r^3hS\u0016\u001c(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u0006\u0004\u0003:L(\"E!C'R\u0013\u0016i\u0011+`\u001b>#\u0015JR%F%*\u0019\u0002k\\:ji&|g.\u001b8h'R\u0014\u0018\r^3hs*!\"*\u001a;N_\u0012Lg-[3s\u0019&\u001cHoT<oKJT1\u0001]:j\u0015Q9W\r^!C'R\u0013\u0016i\u0011+`\u001b>#\u0015JR%F%*a\u0011I\u0015*B3~\u000b5iQ#T'*A\"*\u001a;BeJ\f\u00170Q2dKN\u001cX\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u001f\u001d,G/\u0011*S\u0003f{\u0016iQ\"F'NSq!Q*`)f\u0003VI\u0003\u0010KKR\u0014\u0015N\\1ss\u0016C\bO]3tg&|gnV5uQRK\b/\u001a*I'*Qq-\u001a;B'~#\u0016\fU#\u000b\u0019\r\u000bE\nT0F\u0019\u0016kUI\u0014+\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0010O\u0016$8)\u0011'M?\u0016cU)T#O)*y1)\u0011'M?\u0016C\u0006KU#T'&{eJ\u0003\nhKR\u001c\u0015\t\u0014'`\u000bb\u0003&+R*T\u0013>s%\u0002E\"P\u001bB\u000be*S(O?>\u0013%*R\"U\u0015QQU\r^(cU\u0016\u001cG\u000fR3dY\u0006\u0014\u0018\r^5p]*\u0019r-\u001a;D\u001f6\u0003\u0016IT%P\u001d~{%IS#D)*y1)\u0016+`\u0007\"\u000b%kX)V\u001fR+5K\u0003\u0006KKR,E.Z7f]RT!cZ3u\u0007V#vl\u0011%B%~\u000bVk\u0014+F'*\u0001B)R\"M\u0003J\u000bE+S(O?:\u000bU*\u0012\u0006\u0014\u0015\u0016$h*Y7fI\u0012+7\r\\1sCRLwN\u001c\u0006\u0014O\u0016$H)R\"M\u0003J\u000bE+S(O?:\u000bU*\u0012\u0006\u0018\t\u0016\u001bE*\u0011*B)&{ej\u0018*F)V\u0013fj\u0018+Z!\u0016SaBS3u\t\u0016\u001cG.\u0019:bi&|gN\u0003\u000ehKR$Ui\u0011'B%\u0006#\u0016j\u0014(`%\u0016#VK\u0015(`)f\u0003VIC\u000bE\u000b\u000ec\u0015IU!U\u0013>sulU%H\u001d\u0006#VKU#\u000b1\u001d,G\u000fR#D\u0019\u0006\u0013\u0016\tV%P\u001d~\u001b\u0016j\u0012(B)V\u0013VI\u0003\u0011E\u000b\u000ec\u0015IU!U\u0013>sulU%H\u001d\u0006#VKU#`\u001fJ{F)\u0012$B+2#&bI4fi\u0012+5\tT!S\u0003RKuJT0T\u0013\u001es\u0015\tV+S\u000b~{%k\u0018#F\r\u0006+F\n\u0016\u0006\u0016\t\u0016\u001bE*\u0011*B)&{ejX,J)\"{&i\u0014#Z\u0015YQU\r\u001e#fG2\f'/\u0019;j_:<\u0016\u000e\u001e5C_\u0012L(\u0002G4fi\u0012+5\tT!S\u0003RKuJT0X\u0013RCuLQ(E3*9A)\u0012$B+2#&BC4fi\u0012+e)Q+M)*!B)\u0012'F\u000f\u0006#vJU0T+B+%kX\"B\u00192SABS3u\u000b:,X.\u00128uefTqcZ3u\t\u0016cUiR!U\u001fJ{6+\u0016)F%~\u001b\u0015\t\u0014'\u000b\u0015\u0015c5+R0F\u001dR\u0013\u0016L\u0003\u0007KKR<\u0006.\u001a8F]R\u0014\u0018PC\u0007hKR,EjU#`\u000b:#&+\u0017\u0006\u000f\r&s\u0015\tT0N\u001f\u0012Ke)S#S\u0015E9W\r\u001e$J\u001d\u0006cu,T(E\u0013\u001aKUI\u0015\u0006\u0012\r>\u0013vLU#E\u000b\u000ec\u0015IU!U\u0013>s%\u0002F4fi\u001a{%k\u0018*F\t\u0016\u001bE*\u0011*B)&{eJ\u0003\rG\u001fJ{VK\u0014*F'>ce+\u0012#`%\u00163UIU#O\u0007\u0016SaCS3u%\u00164WM]3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001cO\u0016$hi\u0014*`+:\u0013ViU(M-\u0016#uLU#G\u000bJ+ejQ#\u000b'\u0019+fj\u0011+J\u001f:{\u0006+\u0011*B\u001b\u0016#VIU*\u000b\u0017)+GOR;oGRLwN\u001c\u0006\u0017O\u0016$h)\u0016(D)&{ej\u0018)B%\u0006kU\tV#S'*a\u0011*\u0014)P%R{\u0016\tT%B'*\u0011\"*\u001a;J[B|'\u000f\u001e#je\u0016\u001cG/\u001b<f\u0015=9W\r^%N!>\u0013FkX!M\u0013\u0006\u001b&BD%O\u001d\u0016\u0013v,T(E\u0013\u001aKUI\u0015\u0006\u0012O\u0016$\u0018J\u0014(F%~ku\nR%G\u0013\u0016\u0013&b\u0005'P\u001d\u001e{F*\u0013+F%\u0006culU+G\r&C&BF4fi2{ejR0M\u0013R+%+\u0011'`'V3e)\u0013-\u000b\u001b9+F\nT!C\u0019\u0016{F+\u0017)F\u0015=QU\r\u001e(vY2\f'\r\\3UsB,'\u0002E4fi:+F\nT!C\u0019\u0016{F+\u0017)F\u0015Eye+\u0012*S\u0013\u0012+u,T(E\u0013\u001aKUI\u0015\u0006\u0015O\u0016$xJV#S%&#UiX'P\t&3\u0015*\u0012*\u000b/A\u000b%+Q'F)\u0016\u0013v\fR#G\u0003VcEk\u0018,B\u0019V+%\u0002\u0004&fiB\u000b'/Y7fi\u0016\u0014(BG4fiB\u000b%+Q'F)\u0016\u0013v\fR#G\u0003VcEk\u0018,B\u0019V+%bD*F\u00032+EiX'P\t&3\u0015*\u0012*\u000b%\u001d,GoU#B\u0019\u0016#u,T(E\u0013\u001aKUI\u0015\u0006&'\u0016\u001buJ\u0014#B%f{6i\u0014(T)J+6\tV(S?\u0012+E*R$B)&{ejX\"B\u00192SADS3u\u0007>t7\u000f\u001e:vGR|'\u000fR3mK\u001e\fG/[8o\u0007\u0006dGN\u0003\u0015hKR\u001cViQ(O\t\u0006\u0013\u0016lX\"P\u001dN#&+V\"U\u001fJ{F)\u0012'F\u000f\u0006#\u0016j\u0014(`\u0007\u0006cEJ\u0003\u0015U3B+u\fU!S\u00036+E+\u0012*T?>\u0013v\fR#D\u0019\u0006\u0013\u0016\tV%P\u001d~\u001b\u0016j\u0012(B)V\u0013VIC\u0016hKR$\u0016\fU#`!\u0006\u0013\u0016)T#U\u000bJ\u001bvl\u0014*`\t\u0016\u001bE*\u0011*B)&{ejX*J\u000f:\u000bE+\u0016*F\u0015A)fJU#B\u0007\"\u000b%\tT#`\u0007>#UIC\nhKR,fJU#B\u0007\"\u000b%\tT#`\u0007>#UI\u0003\u0007V\u001dV\u001bV\tR0W\u00032+VIC\nKKR\u0014\u0015N\\1ss\u0016C\bO]3tg&|gNC\bhKR,f*V*F\t~3\u0016\tT+F\u00155)6+\u0012'F'N{V\t\u0014,J'*\u0001r-\u001a;V'\u0016cUiU*`\u000b23\u0016j\u0015\u0006\u0010-\u0006cU+R0B%\u001e+V*\u0012(U'*\u0011r-\u001a;W\u00032+ViX!S\u000fVkUI\u0014+T\u0015=1\u0016\tT0P%~3\u0016IU0O\u001f\u0012+%BE4fiZ\u000bEjX(S?Z\u000b%k\u0018(P\t\u0016SaCV!S\u0013\u0006s5)R0J\u001d~\u0003&k\u0014&F\u0007RKuJ\u0014\u0006\u0012\u0015\u0016$H+\u001f9f!J|'.Z2uS>t'\"G4fiZ\u000b%+S!O\u0007\u0016{\u0016JT0Q%>SUi\u0011+J\u001f:S\u0011CV!S\u0013\u0006s5)R0N\u001f\u0012Ke)S#S\u0015Q9W\r\u001e,B%&\u000bejQ#`\u001b>#\u0015JR%F%*\u0019b+S*J\u0005&c\u0015\nV-`\u001b>#\u0015JR%F%*1r-\u001a;W\u0013NK%)\u0013'J)f{Vj\u0014#J\r&+%KC\fX\u0011\u0016sulQ(O\t&#\u0016j\u0014(`\u0013:{&+\u0011(H\u000b*9\"*\u001a;XQ\u0016t7i\u001c8eSRLwN\\%o%\u0006tw-\u001a\u0006\u001bO\u0016$x\u000bS#O?\u000e{e\nR%U\u0013>su,\u0013(`%\u0006su)\u0012\u0006\u0010/\"+ejX#Y!J+5kU%P\u001d*\t\"*\u001a;XQ\u0016tW\t\u001f9sKN\u001c\u0018n\u001c8\u000b%\u001d,Go\u0016%F\u001d~+\u0005\f\u0015*F'NKuJ\u0014\u0006\u0014[>$\u0017NZ5feN+G\u000fU8tSRLwN\u001c\u0006\u0007i>\\WM\\:\u000b\u000b\u0005\u0013(/Y=\u000b/)+G/T8eS\u001aLWM]&fs^|'\u000f\u001a+pW\u0016t'\"\u00027fq\u0016\u0014(\"\u0005#fG2\f'/\u0019;j_:DU-\u00193feJ\u0015!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0003\u0011\u000ba\u0001!B\u0002\u0005\u0004!\u001dA\u0002A\u0003\u0003\t\u0005AI!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\u0007A9!B\u0002\u0005\t!1A\u0002A\u0003\u0004\t\u0011Ay\u0001\u0004\u0001\u0006\u0003!MQA\u0001C\u0007\u0011))!\u0001B\u0004\t\n\u0015\u0019Aq\u0002\u0005\n\u0019\u0001)1\u0001\u0002\u0003\t\u001a1\u0001Qa\u0001\u0003\u0005\u00119a\u0001!B\u0002\u0005\t!}A\u0002A\u0003\u0004\t\u0011A\u0011\u0003\u0004\u0001\u0006\u0007\u0011!\u0001\u0012\u0006\u0007\u0001\u000b\r!A\u0001C\f\r\u0001\u0015\u0019A\u0001\u0002E\u0019\u0019\u0001)1\u0001\u0002\u0003\t91\u0001Qa\u0001\u0003\u0005\u0011wa\u0001!B\u0002\u0005\t!yB\u0002A\u0003\u0004\t\u0011A)\u0005\u0004\u0001\u0006\u0007\u0011!\u0001\"\n\u0007\u0001\u000b\r!A\u0001c\u0014\r\u0001\u0015\u0019A\u0001\u0002\u0005,\u0019\u0001)1\u0001\u0002\u0003\t`1\u0001Qa\u0001\u0003\u0005\u0011Mb\u0001!B\u0002\u0005\t!%D\u0002A\u0003\u0004\t\u000bAi\u0007\u0004\u0001\u0006\u0005\u0011\t\u0001rN\u0003\u0004\tGAq\u0007\u0004\u0001\u0006\u0005\u0011\r\u0002b\u000e\u0003d\u00031\u0011\u0011dA\u0003\u0002\u0011\rA2!(\u00019[U!1\r\u0002\r\u0004C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001E\u00051\u0013A:!V\u0002\t\u000b\r!1!C\u0001\t\u000b5\u0019A!B\u0005\u0002\u0011\u0015iS\u0003B2\u00051\u0017\t\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011\u0017AZ\u0001g\u0002V\u0007!)1\u0001b\u0003\n\u0003!)Qb\u0001C\u0007\u0013\u0005AQ!L\u000b\u0005G\u0012Ar!\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005Aa\u0001\u0007\u0004\u0019\bU\u001b\u0001\"B\u0002\u0005\u000f%\t\u0001\"B\u0007\u0004\t!I\u0011\u0001C\u0003.+\u0011\u0019G\u0001'\u0005\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a\u001dQk\u0001\u0005\u0006\u0007\u0011E\u0011\"\u0001\u0005\u0006\u001b\r!)\"C\u0001\t\u000b5*Ba\u0019\u0003\u0019\u0017\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0011aA\u0001tA+\u0004\u0011\u0015\u0019AaC\u0005\u0002\u0011\u0015i1\u0001b\u0006\n\u0003!)Q&\u0006\u0003d\taa\u0011\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!E\u0001\u0014\u0003M\u0004+\u000eAQa\u0001\u0003\r\u0013\u0005AQ!D\u0002\u0005\u001b%\t\u0001\"B\u0017\u0016\t\r$\u00014D\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\"\u0003\r\n1\u000f)6\u0001C\u0003\u0004\t7I\u0011\u0001C\u0003\u000e\u0007\u0011u\u0011\"\u0001\u0005\u0006[U!1\r\u0002\r\u0010C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001E\n1'A:!V\u0002\t\u000b\r!q\"C\u0001\t\u000b5\u0019A\u0001E\u0005\u0002\u0011\u0015iS\u0003B2\u00051C\t\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011)A\"\u0002g\u0002V\u0007!)1\u0001\"\t\n\u0003!)Qb\u0001C\u0012\u0013\u0005AQ!L\u000b\u0005G\u0012A\"#\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005A!\u0002\u0007\u0006\u0019\bU\u001b\u0001\"B\u0002\u0005%%\t\u0001\"B\u0007\u0004\tKI\u0011\u0001C\u0003.+\u0011\u0019G\u0001G\n\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a\u001dQk\u0001\u0005\u0006\u0007\u0011\u0019\u0012\"\u0001\u0005\u0006\u001b\r!9#C\u0001\t\u000b5*Ba\u0019\u0003\u0019)\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0016aU\u0001tA+\u0004\u0011\u0015\u0019A\u0001F\u0005\u0002\u0011\u0015i1\u0001B\u000b\n\u0003!)Q&\u0006\u0003d\ta-\u0012\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!A\u0001\u0004\u0003M\u0004+\u000eAQa\u0001C\u0016\u0013\u0005AQ!D\u0002\u0005-%\t\u0001\"B\u0017\u0016\t\r$\u0001TF\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001b\u0003\r\f1\u000f)6\u0001C\u0003\u0004\t[I\u0011\u0001C\u0003\u000e\u0007\u0011=\u0012\"\u0001\u0005\u0006[U!1\r\u0002\r\u0019C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001E\f1/A:!V\u0002\t\u000b\r!\u0001$C\u0001\t\u000b5\u0019A!G\u0005\u0002\u0011\u0015iS\u0003B2\u00051g\t\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011\u0013AJ\u0001g\u0002V\u0007!)1\u0001b\r\n\u0003!)Qb\u0001\u0003\u001b\u0013\u0005AQ!L\u000b\u0005G\u0012A*$\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019\bU\u001b\u0001\"B\u0002\u00056%\t\u0001\"B\u0007\u0004\tmI\u0011\u0001C\u0003.+\u0011\u0019G\u0001g\u000e\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0007\u0019\u0019a\u001dQk\u0001\u0005\u0006\u0007\u0011]\u0012\"\u0001\u0005\u0006\u001b\r!I$C\u0001\t\u000b5*Ba\u0019\u0003\u0019;\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u001aae\u0001tA+\u0004\u0011\u0015\u0019A!H\u0005\u0002\u0011\u0015i1\u0001\u0002\u0010\n\u0003!)Q&\u0006\u0003d\tau\u0012\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!i\u0001$\u0004M\u0004+\u000eAQa\u0001C\u001f\u0013\u0005AQ!D\u0002\u0005@%\t\u0001\"B\u0017\u0016\t\r$\u0001\u0004I\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0002M\u00051\u000f)6\u0001C\u0003\u0004\t\u0001J\u0011\u0001C\u0003\u000e\u0007\u0011\u0005\u0013\"\u0001\u0005\u0006[U!1\r\u0002\r\"C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\n1%A:!V\u0002\t\u000b\r!\u0011%C\u0001\t\u000b5\u0019A1I\u0005\u0002\u0011\u0015iS\u0003B2\u00051\t\n\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u00117AZ\u0002g\u0002V\u0007!)1\u0001\u0002\u0012\n\u0003!)Qb\u0001\u0003$\u0013\u0005AQ!L\u000b\u0005G\u0012A:%\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005AI\u0001'\u0003\u0019\bU\u001b\u0001\"B\u0002\u0005H%\t\u0001\"B\u0007\u0004\t\u0011J\u0011\u0001C\u0003.+\u0011\u0019G\u0001'\u0013\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001\u0003\b\u0019\u001da\u001dQk\u0001\u0005\u0006\u0007\u0011%\u0013\"\u0001\u0005\u0006\u001b\r!Y%C\u0001\t\u000b5*Ba\u0019\u0003\u0019M\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\na%\u0001tA+\u0004\u0011\u0015\u0019AAJ\u0005\u0002\u0011\u0015i1\u0001\"\u0014\n\u0003!)Q&\u0006\u0003d\ta9\u0013\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!u\u0001T\u0004M\u0004+\u000eAQa\u0001\u0003(\u0013\u0005AQ!D\u0002\u0005Q%\t\u0001\"B\u0017\u0016\t\r$\u0001\u0014K\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001B\u0003\r\u000b1\u000f)6\u0001C\u0003\u0004\t#J\u0011\u0001C\u0003\u000e\u0007\u0011I\u0013\"\u0001\u0005\u0006[U!1\r\u0002M*C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001\u0005\t1!A:!V\u0002\t\u000b\r!\u0019&C\u0001\t\u000b5\u0019AAK\u0005\u0002\u0011\u0015iS\u0003B2\u00051+\n\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011=Ar\u0002g\u0002V\u0007!)1\u0001\"\u0016\n\u0003!)Qb\u0001C,\u0013\u0005AQ!L\u000b\u0005G\u0012AB&\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0002G\b\u0019\bU\u001b\u0001\"B\u0002\u0005Y%\t\u0001\"B\u0007\u0004\t3J\u0011\u0001C\u0003.+\u0011\u0019G\u0001G\u0017\"\u0011\u0015\t\u0001rA\u0005\u0005\u0013\r)\u0011\u0001C\u0005\u0019\u0013a\u001dQk\u0001\u0005\u0006\u0007\u0011i\u0013\"\u0001\u0005\u0006\u001b\r!Y&C\u0001\t\u000b5*Ba\u0019\u0003\u0019]\u0005BQ!\u0001E\u0004\u0013\u0011I1!B\u0001\t\u0014aM\u0001tA+\u0004\u0011\u0015\u0019AAL\u0005\u0002\u0011\u0015i1\u0001\"\u0018\n\u0003!)Q&\u0006\u0003d\tay\u0013\u0005C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!}\u0001t\u0004M\u0004+\u000eAQa\u0001\u00030\u0013\u0005AQ!D\u0002\u0005a%\t\u0001\"B\u0017\u0016\t\r$\u0001\u0014M\u0011\t\u000b\u0005A9!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0002M\u00051\u000f)6\u0001C\u0003\u0004\tCJ\u0011\u0001C\u0003\u000e\u0007\u0011\t\u0014\"\u0001\u0005\u0006[U!1\r\u0002M2C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001E\u00051\u0013A:!V\u0002\t\u000b\r!\u0019'C\u0001\t\u000b5\u0019AAM\u0005\u0002\u0011\u0015iS\u0003B2\u00051K\n\u0003\"B\u0001\t\b%!\u0011bA\u0003\u0002\u0011AA\u0002\u0003g\u0002V\u0007!)1\u0001\"\u001a\n\u0003!)Qb\u0001C4\u0013\u0005AQ!L\u000b\u0005G\u0012AB'\t\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0003'\t\u0019\bU\u001b\u0001\"B\u0002\u0005i%\t\u0001\"B\u0007\u0004\tUJ\u0011\u0001C\u0003.K\u0011\u001d\u00014NO\u0012\t\u0001Aa'D\u0005\u0006\u0003!\t\u0012\"\u0002C\u0001\u0013\r)\u0011\u0001\u0003\n\u0019%a\t\u0012cA\u0003\u0002\u0011IA\"\u0003U\u0002\u0001C!)\u0011\u0001c\u0002\n\t%\u0019Q!\u0001E\u00051\u0013A:!U\u0002\u0007\tWJ\u0011\u0001C\u0003\u000e\u0005!\u0015B\u0012A\u001b\u0001"})
public final class PositioningStrategies {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT;
    @NotNull
    public static final PositioningStrategy<JetDeclaration> DECLARATION_RETURN_TYPE;
    @NotNull
    public static final PositioningStrategy<JetNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final PositioningStrategy<JetDeclaration> DECLARATION_SIGNATURE;
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @NotNull
    public static final PositioningStrategy<JetDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> ABSTRACT_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> INNER_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> OVERRIDE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> FINAL_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> SEALED_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> VARIANCE_MODIFIER;
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @NotNull
    public static final PositioningStrategy<JetReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @NotNull
    public static final PositioningStrategy<JetArrayAccessExpression> ARRAY_ACCESS;
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> VISIBILITY_MODIFIER;
    @NotNull
    public static final PositioningStrategy<JetTypeProjection> VARIANCE_IN_PROJECTION;
    @NotNull
    public static final PositioningStrategy<JetParameter> PARAMETER_DEFAULT_VALUE;
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @NotNull
    public static final PositioningStrategy<JetDeclarationWithBody> DECLARATION_WITH_BODY;
    @NotNull
    public static final PositioningStrategy<JetNamedDeclaration> VAL_OR_VAR_NODE;
    @NotNull
    public static final PositioningStrategy<JetWhenEntry> ELSE_ENTRY;
    @NotNull
    public static final PositioningStrategy<JetWhenExpression> WHEN_EXPRESSION;
    @NotNull
    public static final PositioningStrategy<JetWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @NotNull
    public static final PositioningStrategy<JetNullableType> NULLABLE_TYPE;
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @NotNull
    public static final PositioningStrategy<JetElement> VALUE_ARGUMENTS;
    @NotNull
    public static final PositioningStrategy<JetFunction> FUNCTION_PARAMETERS;
    @NotNull
    public static final PositioningStrategy<JetElement> CUT_CHAR_QUOTES;
    @NotNull
    public static final PositioningStrategy<JetElement> LONG_LITERAL_SUFFIX;
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @NotNull
    public static final PositioningStrategy<JetBinaryExpressionWithTypeRHS> AS_TYPE;
    @NotNull
    public static final PositioningStrategy<JetObjectDeclaration> COMPANION_OBJECT;
    @NotNull
    public static final PositioningStrategy<JetConstructorDelegationCall> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @NotNull
    public static final PositioningStrategy<JetEnumEntry> DELEGATOR_SUPER_CALL;
    @NotNull
    public static final PositioningStrategy<JetBinaryExpression> UNUSED_VALUE;
    @NotNull
    public static final PositioningStrategy<JetBinaryExpression> USELESS_ELVIS;
    @NotNull
    public static final PositioningStrategy<JetImportDirective> IMPORT_ALIAS;
    public static final PositioningStrategies INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(PositioningStrategies.class);
        new PositioningStrategies();
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final PositioningStrategy<JetDeclaration> getDECLARATION_RETURN_TYPE() {
        return DECLARATION_RETURN_TYPE;
    }

    @NotNull
    public final PositioningStrategy<JetNamedDeclaration> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final PositioningStrategy<JetDeclaration> getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDECLARATION_SIGNATURE_OR_DEFAULT() {
        return DECLARATION_SIGNATURE_OR_DEFAULT;
    }

    @NotNull
    public final PositioningStrategy<JetDeclaration> getTYPE_PARAMETERS_OR_DECLARATION_SIGNATURE() {
        return TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getABSTRACT_MODIFIER() {
        return ABSTRACT_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getINNER_MODIFIER() {
        return INNER_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getOVERRIDE_MODIFIER() {
        return OVERRIDE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getFINAL_MODIFIER() {
        return FINAL_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getSEALED_MODIFIER() {
        return SEALED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getVARIANCE_MODIFIER() {
        return VARIANCE_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getFOR_REDECLARATION() {
        return FOR_REDECLARATION;
    }

    @NotNull
    public final PositioningStrategy<JetReferenceExpression> getFOR_UNRESOLVED_REFERENCE() {
        return FOR_UNRESOLVED_REFERENCE;
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<JetModifierListOwner> modifierSetPosition(JetModifierKeywordToken ... tokens) {
        Intrinsics.checkParameterIsNotNull(tokens, "tokens");
        return new PositioningStrategy<JetModifierListOwner>(tokens){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ JetModifierKeywordToken[] $tokens;

            static {
                $kotlinClass = Reflection.createKotlinClass(modifierSetPosition.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetModifierListOwner element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetModifierList $receiver = element.getModifierList();
                JetModifierList jetModifierList = $receiver;
                if (jetModifierList == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "No modifier list, but modifier has been found by the analyzer";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                JetModifierList modifierList = jetModifierList;
                JetModifierKeywordToken[] jetModifierKeywordTokenArray = this.$tokens;
                for (int i = 0; i < jetModifierKeywordTokenArray.length; ++i) {
                    JetModifierKeywordToken token = jetModifierKeywordTokenArray[i];
                    PsiElement element2 = modifierList.getModifier(token);
                    if (element2 == null) continue;
                    return PositioningStrategyKt.markElement(element2);
                }
                throw (Throwable)new IllegalStateException("None of the modifiers is found: " + CollectionsKt.listOf(this.$tokens));
            }
            {
                this.$tokens = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public final PositioningStrategy<JetArrayAccessExpression> getARRAY_ACCESS() {
        return ARRAY_ACCESS;
    }

    @NotNull
    public final PositioningStrategy<JetModifierListOwner> getVISIBILITY_MODIFIER() {
        return VISIBILITY_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<JetTypeProjection> getVARIANCE_IN_PROJECTION() {
        return VARIANCE_IN_PROJECTION;
    }

    @NotNull
    public final PositioningStrategy<JetParameter> getPARAMETER_DEFAULT_VALUE() {
        return PARAMETER_DEFAULT_VALUE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCALL_ELEMENT() {
        return CALL_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<JetDeclarationWithBody> getDECLARATION_WITH_BODY() {
        return DECLARATION_WITH_BODY;
    }

    @NotNull
    public final PositioningStrategy<JetNamedDeclaration> getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final PositioningStrategy<JetWhenEntry> getELSE_ENTRY() {
        return ELSE_ENTRY;
    }

    @NotNull
    public final PositioningStrategy<JetWhenExpression> getWHEN_EXPRESSION() {
        return WHEN_EXPRESSION;
    }

    @NotNull
    public final PositioningStrategy<JetWhenConditionInRange> getWHEN_CONDITION_IN_RANGE() {
        return WHEN_CONDITION_IN_RANGE;
    }

    @NotNull
    public final PositioningStrategy<JetNullableType> getNULLABLE_TYPE() {
        return NULLABLE_TYPE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getCALL_EXPRESSION() {
        return CALL_EXPRESSION;
    }

    @NotNull
    public final PositioningStrategy<JetElement> getVALUE_ARGUMENTS() {
        return VALUE_ARGUMENTS;
    }

    @NotNull
    public final PositioningStrategy<JetFunction> getFUNCTION_PARAMETERS() {
        return FUNCTION_PARAMETERS;
    }

    @NotNull
    public final PositioningStrategy<JetElement> getCUT_CHAR_QUOTES() {
        return CUT_CHAR_QUOTES;
    }

    @NotNull
    public final PositioningStrategy<JetElement> getLONG_LITERAL_SUFFIX() {
        return LONG_LITERAL_SUFFIX;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getUNREACHABLE_CODE() {
        return UNREACHABLE_CODE;
    }

    @NotNull
    public final PositioningStrategy<JetBinaryExpressionWithTypeRHS> getAS_TYPE() {
        return AS_TYPE;
    }

    @NotNull
    public final PositioningStrategy<JetObjectDeclaration> getCOMPANION_OBJECT() {
        return COMPANION_OBJECT;
    }

    @NotNull
    public final PositioningStrategy<JetConstructorDelegationCall> getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final PositioningStrategy<JetEnumEntry> getDELEGATOR_SUPER_CALL() {
        return DELEGATOR_SUPER_CALL;
    }

    @NotNull
    public final PositioningStrategy<JetBinaryExpression> getUNUSED_VALUE() {
        return UNUSED_VALUE;
    }

    @NotNull
    public final PositioningStrategy<JetBinaryExpression> getUSELESS_ELVIS() {
        return USELESS_ELVIS;
    }

    @NotNull
    public final PositioningStrategy<JetImportDirective> getIMPORT_ALIAS() {
        return IMPORT_ALIAS;
    }

    PositioningStrategies() {
        INSTANCE$ = this;
        DEFAULT = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DEFAULT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element;
                if (psiElement instanceof JetObjectLiteralExpression) {
                    JetObjectDeclaration objectDeclaration = ((JetObjectLiteralExpression)element).getObjectDeclaration();
                    PsiElement objectKeyword = objectDeclaration.getObjectKeyword();
                    JetDelegationSpecifierList delegationSpecifierList = objectDeclaration.getDelegationSpecifierList();
                    if (delegationSpecifierList == null) {
                        return PositioningStrategyKt.markElement(objectKeyword);
                    }
                    return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
                }
                if (psiElement instanceof JetObjectDeclaration) {
                    PsiElement psiElement2 = ((JetObjectDeclaration)element).getObjectKeyword();
                    PsiElement psiElement3 = ((JetObjectDeclaration)element).getNameIdentifier();
                    if (psiElement3 == null) {
                        psiElement3 = ((JetObjectDeclaration)element).getObjectKeyword();
                    }
                    return PositioningStrategyKt.markRange(psiElement2, psiElement3);
                }
                if (psiElement instanceof JetConstructorDelegationCall) {
                    return PositioningStrategies.INSTANCE$.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark((JetConstructorDelegationCall)element);
                }
                return super.mark(element);
            }
        };
        DECLARATION_RETURN_TYPE = new PositioningStrategy<JetDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_RETURN_TYPE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return PositioningStrategyKt.markElement(this.getElementToMark(element));
            }

            public boolean isValid(@NotNull JetDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
            }

            /*
             * WARNING - void declaration
             */
            private final PsiElement getElementToMark(JetDeclaration declaration) {
                void nameIdentifierOrPlaceholder;
                void returnTypeRef;
                JetDeclaration jetDeclaration = declaration;
                Pair<JetTypeReference, PsiElement> pair = jetDeclaration instanceof JetCallableDeclaration ? new Pair<JetTypeReference, PsiElement>(((JetCallableDeclaration)declaration).getTypeReference(), ((JetCallableDeclaration)declaration).getNameIdentifier()) : (jetDeclaration instanceof JetPropertyAccessor ? new Pair<JetTypeReference, PsiElement>(((JetPropertyAccessor)declaration).getReturnTypeReference(), ((JetPropertyAccessor)declaration).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
                JetTypeReference jetTypeReference = pair.component1();
                PsiElement psiElement = pair.component2();
                pair = null;
                if (returnTypeRef != null) {
                    return (PsiElement)returnTypeRef;
                }
                if (nameIdentifierOrPlaceholder != null) {
                    return nameIdentifierOrPlaceholder;
                }
                return declaration;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<JetNamedDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_NAME.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetNamedDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof JetClassOrObject) {
                        PsiElement psiElement;
                        PsiElement psiElement2 = ((JetClassOrObject)element).getModifierList();
                        if (psiElement2 == null || (psiElement2 = psiElement2.getModifier(JetTokens.ENUM_KEYWORD)) == null) {
                            ASTNode aSTNode = ((JetClassOrObject)element).getNode().findChildByType(TokenSet.create(JetTokens.CLASS_KEYWORD, JetTokens.OBJECT_KEYWORD));
                            psiElement2 = psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                        }
                        if (psiElement2 == null) {
                            psiElement = element;
                        }
                        PsiElement startElement = psiElement;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof JetNamedFunction) {
                    return PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().mark((JetDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<JetDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_SIGNATURE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetDeclaration jetDeclaration = element;
                if (jetDeclaration instanceof JetConstructor) {
                    PsiElement psiElement = ((JetConstructor)element).getConstructorKeyword();
                    if (psiElement == null) {
                        psiElement = ((JetConstructor)element).getValueParameterList();
                    }
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement begin = psiElement;
                    JetParameterList jetParameterList = ((JetConstructor)element).getValueParameterList();
                    PsiElement psiElement2 = jetParameterList != null ? (PsiElement)jetParameterList : ((JetConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement end = psiElement2;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (jetDeclaration instanceof JetFunction) {
                    NavigatablePsiElement navigatablePsiElement;
                    PsiElement endOfSignatureElement;
                    JetTypeReference jetTypeReference = ((JetFunction)element).getTypeReference();
                    JetElementImplStub jetElementImplStub = jetTypeReference != null ? (JetElementImplStub)jetTypeReference : (JetElementImplStub)((JetFunction)element).getValueParameterList();
                    PsiElement psiElement = jetElementImplStub != null ? (PsiElement)jetElementImplStub : ((JetFunction)element).getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = endOfSignatureElement = (PsiElement)element;
                    }
                    if (element instanceof JetFunctionLiteral) {
                        JetTypeReference jetTypeReference2 = ((JetFunctionLiteral)element).getReceiverTypeReference();
                        JetElementImplStub jetElementImplStub2 = jetTypeReference2 != null ? (JetElementImplStub)jetTypeReference2 : (JetElementImplStub)((JetFunctionLiteral)element).getValueParameterList();
                        navigatablePsiElement = jetElementImplStub2 != null ? (NavigatablePsiElement)jetElementImplStub2 : (NavigatablePsiElement)element;
                    } else {
                        navigatablePsiElement = element;
                    }
                    NavigatablePsiElement startElement = navigatablePsiElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (jetDeclaration instanceof JetProperty) {
                    JetTypeReference jetTypeReference = ((JetProperty)element).getTypeReference();
                    PsiElement psiElement = jetTypeReference != null ? (PsiElement)jetTypeReference : ((JetProperty)element).getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (jetDeclaration instanceof JetPropertyAccessor) {
                    PsiElement psiElement;
                    PsiElement psiElement3;
                    JetTypeReference jetTypeReference = ((JetPropertyAccessor)element).getReturnTypeReference();
                    if (jetTypeReference != null) {
                        psiElement3 = jetTypeReference;
                    } else {
                        ASTNode aSTNode = ((JetPropertyAccessor)element).getRightParenthesis();
                        psiElement3 = psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                    }
                    if (psiElement3 == null) {
                        PsiElement psiElement4 = ((JetPropertyAccessor)element).getNamePlaceholder();
                        psiElement = psiElement4;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement4, "element.getNamePlaceholder()");
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (jetDeclaration instanceof JetClass) {
                    PsiElement psiElement = ((JetClass)element).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement;
                    JetParameterList jetParameterList = ((JetClass)element).getPrimaryConstructorParameterList();
                    if (jetParameterList == null) {
                        PsiElement psiElement5 = nameAsDeclaration;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement5, "nameAsDeclaration");
                        return PositioningStrategyKt.markElement(psiElement5);
                    }
                    JetParameterList primaryConstructorParameterList = jetParameterList;
                    PsiElement psiElement6 = nameAsDeclaration;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement6, "nameAsDeclaration");
                    return PositioningStrategyKt.markRange(psiElement6, primaryConstructorParameterList);
                }
                if (jetDeclaration instanceof JetObjectDeclaration) {
                    return PositioningStrategies.INSTANCE$.getDECLARATION_NAME().mark((JetNamedDeclaration)element);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_SIGNATURE_OR_DEFAULT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof JetDeclaration ? PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().mark((JetDeclaration)element) : PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof JetDeclaration ? PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().isValid((JetDeclaration)element) : PositioningStrategies.INSTANCE$.getDEFAULT().isValid(element);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<JetDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclaration element) {
                JetTypeParameterList jetTypeParameterList;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetTypeParameterListOwner && (jetTypeParameterList = ((JetTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(jetTypeParameterList);
                }
                return PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE().mark((JetDeclaration)((PsiElement)element));
            }
        };
        JetModifierKeywordToken[] jetModifierKeywordTokenArray = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken = JetTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken, "JetTokens.ABSTRACT_KEYWORD");
        jetModifierKeywordTokenArray[0] = jetModifierKeywordToken;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray2 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken2 = JetTokens.INNER_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken2, "JetTokens.INNER_KEYWORD");
        jetModifierKeywordTokenArray2[0] = jetModifierKeywordToken2;
        INNER_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray2);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray3 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken3 = JetTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken3, "JetTokens.OVERRIDE_KEYWORD");
        jetModifierKeywordTokenArray3[0] = jetModifierKeywordToken3;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray3);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray4 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken4 = JetTokens.FINAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken4, "JetTokens.FINAL_KEYWORD");
        jetModifierKeywordTokenArray4[0] = jetModifierKeywordToken4;
        FINAL_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray4);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray5 = new JetModifierKeywordToken[1];
        JetModifierKeywordToken jetModifierKeywordToken5 = JetTokens.SEALED_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken5, "JetTokens.SEALED_KEYWORD");
        jetModifierKeywordTokenArray5[0] = jetModifierKeywordToken5;
        SEALED_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray5);
        JetModifierKeywordToken[] jetModifierKeywordTokenArray6 = new JetModifierKeywordToken[2];
        JetModifierKeywordToken jetModifierKeywordToken6 = JetTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken6, "JetTokens.IN_KEYWORD");
        jetModifierKeywordTokenArray6[0] = jetModifierKeywordToken6;
        JetModifierKeywordToken jetModifierKeywordToken7 = JetTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken7, "JetTokens.OUT_KEYWORD");
        jetModifierKeywordTokenArray6[1] = jetModifierKeywordToken7;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray6);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FOR_REDECLARATION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof JetNamedDeclaration) {
                    psiElement = ((JetNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof JetFile) {
                    JetPackageDirective jetPackageDirective = ((JetFile)element).getPackageDirective();
                    if (jetPackageDirective == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement = jetPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = (PsiElement)null;
                }
                if (nameIdentifier == null && element instanceof JetObjectDeclaration) {
                    return PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
                }
                PsiElement psiElement3 = nameIdentifier;
                if (psiElement3 == null) {
                    psiElement3 = element;
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement3, "nameIdentifier ?: element");
                return PositioningStrategyKt.markElement(psiElement3);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<JetReferenceExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FOR_UNRESOLVED_REFERENCE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetReferenceExpression element) {
                List<TextRange> ranges2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetArrayAccessExpression && !(ranges2 = ((JetArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                    List<TextRange> list = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list, "ranges");
                    return list;
                }
                return CollectionsKt.listOf(JetPsiUtilKt.getCalleeHighlightingRange(element));
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<JetArrayAccessExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(ARRAY_ACCESS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getIndicesNode();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getIndicesNode()");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        VISIBILITY_MODIFIER = new PositioningStrategy<JetModifierListOwner>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VISIBILITY_MODIFIER.1.class);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull JetModifierListOwner element) {
                PsiElement psiElement;
                PsiElement nameIdentifier;
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<JetModifierKeywordToken> visibilityTokens = CollectionsKt.listOf(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
                JetModifierList modifierList = element.getModifierList();
                Iterable iterable = visibilityTokens;
                JetModifierListOwner jetModifierListOwner = $receiver2;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
                for (T item : $receiver) {
                    void it2;
                    JetModifierKeywordToken jetModifierKeywordToken = (JetModifierKeywordToken)item;
                    void var10_10 = destination;
                    PsiElement psiElement2 = modifierList;
                    TextRange textRange = psiElement2 != null && (psiElement2 = ((JetModifierList)psiElement2).getModifier((JetModifierKeywordToken)it2)) != null ? psiElement2.getTextRange() : null;
                    var10_10.add(textRange);
                }
                List<TextRange> result2 = CollectionsKt.filterNotNull((List)destination);
                if (!result2.isEmpty()) {
                    return result2;
                }
                if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                jetModifierListOwner = element;
                if (jetModifierListOwner instanceof JetObjectDeclaration) {
                    psiElement = ((JetObjectDeclaration)element).getObjectKeyword();
                } else if (jetModifierListOwner instanceof JetPropertyAccessor) {
                    psiElement = ((JetPropertyAccessor)element).getNamePlaceholder();
                } else if (jetModifierListOwner instanceof JetClassInitializer) {
                    psiElement = element;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + "'");
                }
                PsiElement elementToMark = psiElement;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
        VARIANCE_IN_PROJECTION = new PositioningStrategy<JetTypeProjection>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VARIANCE_IN_PROJECTION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetTypeProjection element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getProjectionToken();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getProjectionToken()!!");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<JetParameter>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(PARAMETER_DEFAULT_VALUE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetParameter element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetExpression jetExpression = element.getDefaultValue();
                if (jetExpression == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode aSTNode = jetExpression.getNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getDefaultValue()!!.getNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CALL_ELEMENT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                JetElement jetElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element;
                if (!(psiElement instanceof JetCallElement)) {
                    psiElement = null;
                }
                return PositioningStrategyKt.markElement((jetElement = (JetCallElement)psiElement) != null && (jetElement = jetElement.getCalleeExpression()) != null ? (PsiElement)jetElement : element);
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<JetDeclarationWithBody>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DECLARATION_WITH_BODY.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetExpression jetExpression = element.getBodyExpression();
                if (!(jetExpression instanceof JetBlockExpression)) {
                    jetExpression = null;
                }
                JetBlockExpression jetBlockExpression = (JetBlockExpression)jetExpression;
                TextRange lastBracketRange = jetBlockExpression != null ? jetBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull JetDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (!super.isValid((PsiElement)element)) return false;
                JetExpression jetExpression = element.getBodyExpression();
                if (!(jetExpression instanceof JetBlockExpression)) {
                    jetExpression = null;
                }
                JetBlockExpression jetBlockExpression = (JetBlockExpression)jetExpression;
                if (jetBlockExpression == null) return false;
                TextRange textRange = jetBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<JetNamedDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VAL_OR_VAR_NODE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetNamedDeclaration element) {
                List list;
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetNamedDeclaration jetNamedDeclaration = element;
                if (jetNamedDeclaration instanceof JetParameter) {
                    PsiElement psiElement = ((JetParameter)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list = PositioningStrategyKt.markElement(psiElement);
                } else if (jetNamedDeclaration instanceof JetProperty) {
                    PsiElement psiElement = ((JetProperty)element).getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.valOrVarKeyword");
                    list = PositioningStrategyKt.markElement(psiElement);
                } else {
                    list = (List)((Object)PreconditionsKt.error("Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element)));
                }
                return list;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<JetWhenEntry>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(ELSE_ENTRY.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetWhenEntry element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getElseKeyword();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getElseKeyword()!!");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<JetWhenExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(WHEN_EXPRESSION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetWhenExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getWhenKeyword()");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<JetWhenConditionInRange>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(WHEN_CONDITION_IN_RANGE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetWhenConditionInRange element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getOperationReference()");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<JetNullableType>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(NULLABLE_TYPE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetNullableType element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getQuestionMarkNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CALL_EXPRESSION.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetCallExpression) {
                    JetTypeArgumentList jetTypeArgumentList = ((JetCallExpression)element).getTypeArgumentList();
                    JetElement jetElement = jetTypeArgumentList != null ? (JetElement)jetTypeArgumentList : (JetElement)((JetCallExpression)element).getCalleeExpression();
                    if (jetElement == null) {
                        jetElement = (JetElement)element;
                    }
                    return PositioningStrategyKt.markRange(element, jetElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<JetElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(VALUE_ARGUMENTS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetElement element) {
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetElement jetElement = element;
                if (!(jetElement instanceof JetValueArgumentList)) {
                    jetElement = null;
                }
                if ((psiElement = (JetValueArgumentList)jetElement) == null || (psiElement = psiElement.getRightParenthesis()) == null) {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<JetFunction>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(FUNCTION_PARAMETERS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetFunction element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof JetFunctionLiteral) {
                    ASTNode aSTNode = ((JetFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getLBrace().getNode()");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.INSTANCE$.getDECLARATION_SIGNATURE_OR_DEFAULT().mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<JetElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(CUT_CHAR_QUOTES.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetConstantExpression && Intrinsics.areEqual(((JetConstantExpression)element).getNode().getElementType(), JetNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = ((JetConstantExpression)element).getTextRange();
                    return CollectionsKt.listOf(TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<JetElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(LONG_LITERAL_SUFFIX.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof JetConstantExpression && Intrinsics.areEqual(((JetConstantExpression)element).getNode().getElementType(), JetNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    return CollectionsKt.listOf(TextRange.create(endOffset - 1, endOffset));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(UNREACHABLE_CODE.1.class);
            }

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
                List list = (List)((DiagnosticWithParameters1)Errors.UNREACHABLE_CODE.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull(list, "Errors.UNREACHABLE_CODE.cast(diagnostic).getA()");
                return list;
            }
        };
        AS_TYPE = new PositioningStrategy<JetBinaryExpressionWithTypeRHS>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(AS_TYPE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getOperationReference()");
                return PositioningStrategyKt.markRange(psiElement, element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<JetObjectDeclaration>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(COMPANION_OBJECT.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetObjectDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.hasModifier(JetTokens.COMPANION_KEYWORD)) {
                    JetModifierKeywordToken[] jetModifierKeywordTokenArray = new JetModifierKeywordToken[1];
                    JetModifierKeywordToken jetModifierKeywordToken = JetTokens.COMPANION_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(jetModifierKeywordToken, "JetTokens.COMPANION_KEYWORD");
                    jetModifierKeywordTokenArray[0] = jetModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(jetModifierKeywordTokenArray).mark((JetModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.INSTANCE$.getDEFAULT().mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<JetConstructorDelegationCall>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(SECONDARY_CONSTRUCTOR_DELEGATION_CALL.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetConstructorDelegationCall element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.isImplicit()) {
                    PsiElement $receiver = element;
                    JetSecondaryConstructor jetSecondaryConstructor = PsiTreeUtil.getParentOfType($receiver, JetSecondaryConstructor.class, true);
                    if (jetSecondaryConstructor == null) {
                        Intrinsics.throwNpe();
                    }
                    JetSecondaryConstructor constructor = jetSecondaryConstructor;
                    JetParameterList jetParameterList = constructor.getValueParameterList();
                    if (jetParameterList == null) {
                        return PositioningStrategyKt.markElement(constructor);
                    }
                    JetParameterList valueParameterList = jetParameterList;
                    PsiElement psiElement = constructor.getConstructorKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "constructor.getConstructorKeyword()");
                    PsiElement psiElement2 = valueParameterList.getLastChild();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement2, "valueParameterList.getLastChild()");
                    return PositioningStrategyKt.markRange(psiElement, psiElement2);
                }
                JetConstructorDelegationReferenceExpression jetConstructorDelegationReferenceExpression = element.getCalleeExpression();
                return PositioningStrategyKt.markElement(jetConstructorDelegationReferenceExpression != null ? (JetElementImpl)jetConstructorDelegationReferenceExpression : (JetElementImpl)element);
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<JetEnumEntry>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(DELEGATOR_SUPER_CALL.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetEnumEntry element) {
                JetElementImplStub jetElementImplStub;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<JetDelegationSpecifier> specifiers = element.getDelegationSpecifiers();
                if (specifiers.isEmpty()) {
                    jetElementImplStub = element;
                } else {
                    JetElementImplStub jetElementImplStub2 = specifiers.get(0);
                    jetElementImplStub = jetElementImplStub2;
                    Intrinsics.checkExpressionValueIsNotNull(jetElementImplStub2, "specifiers[0]");
                }
                return PositioningStrategyKt.markElement(jetElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<JetBinaryExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(UNUSED_VALUE.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                JetExpression jetExpression = element.getLeft();
                if (jetExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(jetExpression), PsiUtilsKt.getEndOffset(element.getOperationReference())));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<JetBinaryExpression>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(USELESS_ELVIS.1.class);
            }

            @NotNull
            protected List<TextRange> mark(@NotNull JetBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(element.getOperationReference()), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<JetImportDirective>(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(IMPORT_ALIAS.1.class);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<TextRange> mark(@NotNull JetImportDirective element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getAliasNameNode();
                if (aSTNode != null) {
                    ASTNode it2;
                    ASTNode $receiver = aSTNode;
                    ASTNode aSTNode2 = it2 = $receiver;
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode2, "it");
                    return PositioningStrategyKt.markNode(aSTNode2);
                }
                JetExpression jetExpression = element.getImportedReference();
                if (jetExpression != null) {
                    JetExpression $receiver = jetExpression;
                    JetExpression it3 = $receiver;
                    if (it3 instanceof JetQualifiedExpression) {
                        JetExpression jetExpression2 = ((JetQualifiedExpression)it3).getSelectorExpression();
                        if (jetExpression2 != null) {
                            void $receiver2;
                            JetExpression jetExpression3 = jetExpression2;
                            JetExpression it4 = (JetExpression)$receiver2;
                            PsiElement psiElement = it4;
                            Intrinsics.checkExpressionValueIsNotNull(psiElement, "it");
                            return PositioningStrategyKt.markElement(psiElement);
                        }
                    }
                    PsiElement psiElement = it3;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "it");
                    return PositioningStrategyKt.markElement(psiElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={" \u0004)\tB)Z2mCJ\fG/[8o\u0011\u0016\fG-\u001a:\u000b+A{7/\u001b;j_:LgnZ*ue\u0006$XmZ5fg*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0006eS\u0006<gn\\:uS\u000e\u001c(\"\u0001+\u000b\u001d)+G\u000fR3dY\u0006\u0014\u0018\r^5p]*\u0019\u0001o]5\u000b'A{7/\u001b;j_:LgnZ*ue\u0006$XmZ=\u000b\rqJg.\u001b;?\u0015\u001dI7OV1mS\u0012Tq!\u001a7f[\u0016tGOC\u0004C_>dW-\u00198O\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0003!!Qa\u0001\u0003\u0004\u0011\u000fa\u0001!B\u0002\u0005\u0004!%A\u0002A\u0003\u0002\u0011\t)1\u0001\"\u0003\t\u000e1\u0001QA\u0001\u0003\u0004\u0011\u000f!\u0011\u0002$\u0002\u0016\r\u0011\u0001\u0001bA\u000b\u0004\u000b\u0005A9\u0001g\u0002\u001a\u0013\u0015\t\u0001\u0002B\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001\u0004B\u0017\u0017\t-AZ!(\u0005\u0005\u0001!1Q\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001Q\u0007\u0001\t3!B\u0001\t\u000ba)\u0011kA\u0003\u0005\f%\tA\u0011A\u0007\u0002\u0011\u0017)\u0014$\u0002\r\u0005G\u0004\tb\u0001\u0002\u0001\t\u0007U\u0019Q!\u0001E\u00041\u000fAR!I\u0005\u0006\u0003!\u0015\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a\u0015\u0011kA\u0002\u0005\u000b%\tA\u0001\u0001"})
    private static class DeclarationHeader<T extends JetDeclaration>
    extends PositioningStrategy<T> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(DeclarationHeader.class);
        }

        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            if (element instanceof JetNamedDeclaration && !(element instanceof JetObjectDeclaration) && !(element instanceof JetSecondaryConstructor) && !(element instanceof JetFunction) && ((JetNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }
}

