/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"h\u0004)!2\r\\5QYV<\u0017N\\+tC\u001e,7\u000b\u001e:j]\u001eT\u0001\u0002\u001d7vO&t\u0017\n\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\r-|G\u000f\\5o\u0015\u001dy\u0007\u000f^5p]NT!bQ8mY\u0016\u001cG/[8o\u0015%\u0019E.[(qi&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\u0011\r|W\u000e]5mKJTa\u0001\u001d7vO&t'\u0002\u00026bm\u0006TA\u0001\\1oO*!Q\u000f^5m\u00151\u0019E.[(qi&|gn]&u\u0015U9W\r\u001e)mk\u001eLgn\u00149uS>t7\u000b\u001e:j]\u001eT1a[3z\u0015\u00151\u0018\r\\;f\u0015E\u0001\u0018M]:f!2,x-\u001b8PaRLwN\u001c\u0006\u000eCJ<W/\\3oiZ\u000bG.^3\u000b\u001d\rc\u0017n\u00149uS>tg+\u00197vK\nT!\u0001E\u0002\u000b\r!\u0001\u0001C\u0001\r\u0001\u0015\u0019A\u0001\u0001E\u0003\u0019\u0001)\u0011\u0001c\u0002\u0006\u0005\u0011\r\u0001\u0002B\u0003\u0003\t\tA\u0019!\u0002\u0002\u0005\u0006!%QA\u0001\u0003\u0004\u0011\u0015)1\u0001b\u0002\t\u00071\u0001Q!\u0001E\u0006\u000b\t!I\u0001\u0003\u0004\u0006\u0005\u0011)\u0001\"A\u0003\u0003\t\u0013Ai!\u0002\u0002\u0005\r!\u0015Qa\u0001C\u0004\u0011)a\u0001!\u0002\u0002\u0005\b!QQA\n\u0003\u00041\u0001iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001E\u00011\u0003\u00016\u0001AO\r\t\u0001A!!\u0004\u0005\u0006\u0003!\t\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\u0019\u0003A\u001b\t!I\u0002\u0006\u0003!\u0005\u0001\u0014A)\u0004\u000f\u0011\u0001\u0011\"\u0001E\u0006\u001b\u0005AY!D\u0001\t\u000ea\u001bq!b\u0016\u0005\u0007a=Qt\u0002\u0003\u0001\u0011\u0003i1!B\u0001\t\u0002a\u0005\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0003iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\u00011\u0003\u00016!A\u0011\u0004\u000b\u0005A\t\u0001'\u0001R\u0007%!y!C\u0001\t\f5\t\u00012B\u0007\u0002\u0011\u0017i\u0011\u0001c\u0003Y\u0007\u001d)y\u0003B\u0002\u0019\u0013u=A\u0001\u0001E\n\u001b\r)\u0011\u0001#\u0001\u0019\u0002A\u001b\u0001!\t\u0003\u0006\u0003!9A\u0012\u0001\r\b#\u000e)A!C\u0005\u0002\u0011\u001fi\u0011\u0001c\u0003Y\u0007\u001d\u0001"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends CliOption> options) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable iterable = options;
        void var5_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            CliOption cliOption = (CliOption)item;
            void var10_10 = destination;
            String name = it2.getName() + " " + it2.getValueDescription();
            String margin = name.length() > MAX_OPTION_WIDTH ? "\n" + StringsKt.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1) : StringsKt.repeat(" ", 1 + MAX_OPTION_WIDTH - name.length());
            List modifiers = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf(it2.getRequired() ? "required" : (String)null, it2.getAllowMultipleOccurrences() ? "multiple" : (String)null));
            String modifiersEnclosed = modifiers.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default(modifiers, null, null, null, 0, null, null, 63) + ")";
            String string = StringsKt.repeat(" ", LEFT_INDENT) + name + margin + it2.getDescription() + modifiersEnclosed;
            var10_10.add(string);
        }
        List renderedOptions = (List)destination;
        return "Plugin " + "\"" + pluginId + "\"" + " usage:" + "\n" + CollectionsKt.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58);
    }

    @Nullable
    public static final CliOptionValue parsePluginOption(@NotNull String argumentValue) {
        Intrinsics.checkParameterIsNotNull(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull(string, "matcher.group(1)");
            String string2 = matcher.group(2);
            Intrinsics.checkExpressionValueIsNotNull(string2, "matcher.group(2)");
            String string3 = matcher.group(3);
            Intrinsics.checkExpressionValueIsNotNull(string3, "matcher.group(3)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(pluginId, "pluginId");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value, "value");
        return "plugin:" + pluginId + ":" + key + "=" + value;
    }
}

