/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.DefaultProcessor;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlinePackage;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InliningInstructionAdapter;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodInliner;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParameterMappings;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.RootInliningContext;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.inline.SimpleInterval;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class InlineCodegen
extends CallGenerator {
    private final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final SimpleFunctionDescriptor functionDescriptor;
    private final JvmMethodSignature jvmSignature;
    private final JetElement callElement;
    private final MethodContext context;
    private final ExpressionCodegen codegen;
    private final boolean asFunctionInline;
    private final int initialFrameSize;
    private final boolean isSameModule;
    protected final ParametersBuilder invocationParamBuilder;
    protected final Map<Integer, LambdaInfo> expressionMap;
    private final ReifiedTypeInliner reifiedTypeInliner;
    private LambdaInfo activeLambda;
    private final SourceMapper sourceMapper;

    public InlineCodegen(@NotNull ExpressionCodegen codegen, @NotNull GenerationState state, @NotNull SimpleFunctionDescriptor functionDescriptor, @NotNull JetElement callElement, @Nullable ReifiedTypeParameterMappings typeParameterMappings) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        this.invocationParamBuilder = ParametersBuilder.newBuilder();
        this.expressionMap = new HashMap<Integer, LambdaInfo>();
        assert (InlineUtil.isInline(functionDescriptor)) : "InlineCodegen could inline only inline function: " + functionDescriptor;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.codegen = codegen;
        this.callElement = callElement;
        this.functionDescriptor = functionDescriptor.getOriginal();
        this.reifiedTypeInliner = new ReifiedTypeInliner(typeParameterMappings);
        this.initialFrameSize = codegen.getFrameMap().getCurrentSize();
        this.context = (MethodContext)InlineCodegen.getContext(functionDescriptor, state);
        this.jvmSignature = this.typeMapper.mapSignature(functionDescriptor, this.context.getContextKind());
        InlineStrategy inlineStrategy = InlineUtil.getInlineStrategy(functionDescriptor);
        this.asFunctionInline = false;
        this.isSameModule = JvmCodegenUtil.isCallInsideSameModuleAsDeclared(functionDescriptor, codegen.getContext(), state.getOutDirectory());
        this.sourceMapper = codegen.getParentCodegen().getOrCreateSourceMapper();
        this.reportIncrementalInfo(functionDescriptor, codegen.getContext().getFunctionDescriptor().getOriginal());
    }

    @Override
    public void genCallWithoutAssertions(@NotNull CallableMethod callableMethod, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallWithoutAssertions"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallWithoutAssertions"));
        }
        this.genCall(callableMethod, null, false, codegen);
    }

    @Override
    public void genCallInner(@NotNull Callable callableMethod, @Nullable ResolvedCall<?> resolvedCall, boolean callDefault, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallInner"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallInner"));
        }
        SMAPAndMethodNode nodeAndSmap = null;
        if (!this.state.getInlineCycleReporter().enterIntoInlining(resolvedCall)) {
            this.generateStub(resolvedCall, codegen);
            return;
        }
        try {
            nodeAndSmap = this.createMethodNode(callDefault);
            this.endCall(this.inlineCall(nodeAndSmap));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            boolean generateNodeText = !(e instanceof InlineException);
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.codegen.getContext().getContextDescriptor());
            throw new CompilationException("Couldn't inline method call '" + this.functionDescriptor.getName() + "' into \n" + (element != null ? element.getText() : "null psi element " + this.codegen.getContext().getContextDescriptor()) + (generateNodeText ? "\ncause: " + InlineCodegenUtil.getNodeText(nodeAndSmap != null ? nodeAndSmap.getNode() : null) : ""), e, this.callElement);
        }
        finally {
            this.state.getInlineCycleReporter().exitFromInliningOf(resolvedCall);
        }
    }

    protected void generateStub(@Nullable ResolvedCall<?> resolvedCall, @NotNull ExpressionCodegen codegen) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateStub"));
        }
        this.leaveTemps();
        assert (resolvedCall != null);
        String message = "Call is part of inline cycle: " + resolvedCall.getCall().getCallElement().getText();
        AsmUtil.genThrow(codegen.v, "java/lang/UnsupportedOperationException", message);
    }

    private void endCall(@NotNull InlineResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "endCall"));
        }
        this.leaveTemps();
        this.codegen.propagateChildReifiedTypeParametersUsages(result2.getReifiedTypeParametersUsages());
        this.state.getFactory().removeInlinedClasses(result2.getClassesToRemove());
        this.codegen.markLineNumberAfterInlineIfNeeded();
    }

    @NotNull
    private SMAPAndMethodNode createMethodNode(boolean callDefault) throws ClassNotFoundException, IOException {
        SMAPAndMethodNode nodeAndSMAP;
        JvmMethodSignature jvmSignature = this.typeMapper.mapSignature(this.functionDescriptor, this.context.getContextKind());
        Method asmMethod = callDefault ? this.typeMapper.mapDefaultMethod(this.functionDescriptor, this.context.getContextKind()) : jvmSignature.getAsmMethod();
        if (this.functionDescriptor instanceof DeserializedSimpleFunctionDescriptor) {
            ClassId containerClassId = InlineCodegenUtil.getContainerClassIdForInlineCallable((DeserializedSimpleFunctionDescriptor)this.functionDescriptor);
            VirtualFile file = InlineCodegenUtil.getVirtualFileForCallable(containerClassId, this.state);
            nodeAndSMAP = InlineCodegenUtil.getMethodNode(file.contentsToByteArray(), asmMethod.getName(), asmMethod.getDescriptor(), containerClassId);
            if (nodeAndSMAP == null) {
                throw new RuntimeException("Couldn't obtain compiled function body for " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
        } else {
            SMAP smap;
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.functionDescriptor);
            if (element == null || !(element instanceof JetNamedFunction)) {
                throw new RuntimeException("Couldn't find declaration for function " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
            JetNamedFunction inliningFunction = (JetNamedFunction)element;
            MethodNode node = new MethodNode(327680, AsmUtil.getMethodAsmFlags(this.functionDescriptor, this.context.getContextKind()) | (callDefault ? 8 : 0), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), null);
            MethodVisitor maxCalcAdapter = InlineCodegenUtil.wrapWithMaxLocalCalc(node);
            MethodContext methodContext = this.context.getParentContext().intoFunction(this.functionDescriptor);
            if (callDefault) {
                Type ownerType = this.typeMapper.mapOwner(this.functionDescriptor);
                FakeMemberCodegen parentCodegen = new FakeMemberCodegen(this.codegen.getParentCodegen(), inliningFunction, (FieldOwnerContext)methodContext.getParentContext(), ownerType.getInternalName());
                FunctionCodegen.generateDefaultImplBody(methodContext, this.functionDescriptor, maxCalcAdapter, DefaultParameterValueLoader.DEFAULT, inliningFunction, parentCodegen);
                smap = InlineCodegen.createSMAPWithDefaultMapping(inliningFunction, parentCodegen.getOrCreateSourceMapper().getResultMappings());
            } else {
                smap = this.generateMethodBody(maxCalcAdapter, this.functionDescriptor, methodContext, inliningFunction, jvmSignature, false);
            }
            nodeAndSMAP = new SMAPAndMethodNode(node, smap);
            maxCalcAdapter.visitMaxs(-1, -1);
            maxCalcAdapter.visitEnd();
        }
        SMAPAndMethodNode sMAPAndMethodNode = nodeAndSMAP;
        if (sMAPAndMethodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        return sMAPAndMethodNode;
    }

    private InlineResult inlineCall(SMAPAndMethodNode nodeAndSmap) {
        MethodNode node = nodeAndSmap.getNode();
        ReifiedTypeParametersUsages reificationResult = this.reifiedTypeInliner.reifyInstructions(node.instructions);
        this.generateClosuresBodies();
        this.putClosureParametersOnStack();
        InlineCodegenUtil.addInlineMarker(this.codegen.v, true);
        Parameters parameters2 = this.invocationParamBuilder.buildParameters();
        RootInliningContext info = new RootInliningContext(this.expressionMap, this.state, this.codegen.getInlineNameGenerator().subGenerator(this.functionDescriptor.getName().asString()), this.codegen.getContext(), this.callElement, this.codegen.getParentCodegen().getClassName(), this.reifiedTypeInliner);
        MethodInliner inliner = new MethodInliner(node, parameters2, info, new FieldRemapper(null, null, parameters2), this.isSameModule, "Method inlining " + this.callElement.getText(), this.createNestedSourceMapper(nodeAndSmap));
        LocalVarRemapper remapper = new LocalVarRemapper(parameters2, this.initialFrameSize);
        MethodNode adapter = InlineCodegenUtil.createEmptyMethodNode();
        adapter.visitInsn(0);
        InlineResult result2 = inliner.doInline(adapter, remapper, true, LabelOwner.SKIP_ALL);
        result2.getReifiedTypeParametersUsages().mergeAll(reificationResult);
        CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)this.codegen.getContext().getContextDescriptor();
        final Set<String> labels = InlineCodegen.getDeclarationLabels(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2), descriptor2);
        LabelOwner labelOwner = new LabelOwner(){

            @Override
            public boolean isMyLabel(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$1", "isMyLabel"));
                }
                return labels.contains(name);
            }
        };
        List<MethodInliner.PointForExternalFinallyBlocks> infos = MethodInliner.processReturns(adapter, labelOwner, true, null);
        this.generateAndInsertFinallyBlocks(adapter, infos, ((StackValue.Local)remapper.remap((int)(parameters2.totalSize() + 1)).value).index);
        this.removeFinallyMarkers(adapter);
        adapter.accept(new InliningInstructionAdapter(this.codegen.v));
        InlineCodegenUtil.addInlineMarker(this.codegen.v, false);
        return result2;
    }

    private void generateClosuresBodies() {
        for (LambdaInfo info : this.expressionMap.values()) {
            info.setNode(this.generateLambdaBody(info));
        }
    }

    private SMAPAndMethodNode generateLambdaBody(LambdaInfo info) {
        JetExpression declaration = info.getFunctionWithBodyOrCallableReference();
        FunctionDescriptor descriptor2 = info.getFunctionDescriptor();
        MethodContext parentContext = this.codegen.getContext();
        MethodContext context = parentContext.intoClosure(descriptor2, this.codegen, this.typeMapper).intoInlinedLambda(descriptor2);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(descriptor2);
        Method asmMethod = jvmMethodSignature.getAsmMethod();
        MethodNode methodNode = new MethodNode(327680, AsmUtil.getMethodAsmFlags(descriptor2, context.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmMethodSignature.getGenericsSignature(), null);
        MethodVisitor adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(methodNode);
        SMAP smap = this.generateMethodBody(adapter, descriptor2, context, declaration, jvmMethodSignature, true);
        adapter.visitMaxs(-1, -1);
        return new SMAPAndMethodNode(methodNode, smap);
    }

    private SMAP generateMethodBody(@NotNull MethodVisitor adapter, @NotNull FunctionDescriptor descriptor2, @NotNull MethodContext context, @NotNull JetExpression expression, @NotNull JvmMethodSignature jvmMethodSignature, boolean isLambda) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        FakeMemberCodegen parentCodegen = new FakeMemberCodegen(this.codegen.getParentCodegen(), expression, (FieldOwnerContext)context.getParentContext(), isLambda ? this.codegen.getParentCodegen().getClassName() : this.typeMapper.mapOwner(descriptor2).getInternalName());
        FunctionGenerationStrategy.CodegenBased strategy = expression instanceof JetCallableReferenceExpression ? new FunctionReferenceGenerationStrategy(this.state, descriptor2, CallUtilPackage.getResolvedCallWithAssert(((JetCallableReferenceExpression)expression).getCallableReference(), this.codegen.getBindingContext())) : new FunctionGenerationStrategy.FunctionDefault(this.state, descriptor2, (JetDeclarationWithBody)expression);
        FunctionCodegen.generateMethodBody(adapter, descriptor2, context, jvmMethodSignature, strategy, parentCodegen);
        return InlineCodegen.createSMAPWithDefaultMapping(expression, parentCodegen.getOrCreateSourceMapper().getResultMappings());
    }

    private static SMAP createSMAPWithDefaultMapping(@NotNull JetExpression declaration, @NotNull List<FileMapping> mappings) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createSMAPWithDefaultMapping"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createSMAPWithDefaultMapping"));
        }
        PsiFile containingFile = declaration.getContainingFile();
        Integer lineNumbers2 = CodegenUtil.getLineNumberForElement(containingFile, true);
        assert (lineNumbers2 != null) : "Couldn't extract line count in " + containingFile;
        return new SMAP(mappings);
    }

    @Override
    public void afterParameterPut(@NotNull Type type2, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "afterParameterPut"));
        }
        this.putCapturedInLocal(type2, stackValue, valueParameterDescriptor, -1);
    }

    private void putCapturedInLocal(@NotNull Type type2, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor, int capturedParamIndex) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedInLocal"));
        }
        if (!this.asFunctionInline && Type.VOID_TYPE != type2) {
            ParameterInfo info;
            StackValue remappedIndex;
            boolean couldBeRemapped = !this.shouldPutValue(type2, stackValue, valueParameterDescriptor);
            StackValue stackValue2 = remappedIndex = couldBeRemapped ? stackValue : null;
            if (capturedParamIndex >= 0) {
                CapturedParamDesc capturedParamInfoInLambda = this.activeLambda.getCapturedVars().get(capturedParamIndex);
                info = this.invocationParamBuilder.addCapturedParam(capturedParamInfoInLambda, capturedParamInfoInLambda.getFieldName());
                info.setRemapValue(remappedIndex);
            } else {
                info = this.invocationParamBuilder.addNextParameter(type2, false, remappedIndex);
            }
            this.putParameterOnStack(info);
        }
    }

    public boolean shouldPutValue(@NotNull Type type2, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor descriptor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "shouldPutValue"));
        }
        if (stackValue == null) {
            return true;
        }
        if (AsmUtil.isPrimitive(type2) != AsmUtil.isPrimitive(stackValue.type)) {
            return true;
        }
        if (stackValue instanceof StackValue.Local) {
            return false;
        }
        StackValue field = stackValue;
        if (stackValue instanceof StackValue.FieldForSharedVar) {
            field = ((StackValue.FieldForSharedVar)stackValue).receiver;
        }
        if (field instanceof StackValue.Field) {
            DeclarationDescriptor varDescriptor = ((StackValue.Field)field).descriptor;
            return !(varDescriptor instanceof ParameterDescriptor) || !InlineUtil.isInlineLambdaParameter((ParameterDescriptor)varDescriptor) || !InlineUtil.isInline(varDescriptor.getContainingDeclaration());
        }
        return true;
    }

    private void putParameterOnStack(ParameterInfo ... infos) {
        ParameterInfo info;
        int i;
        int[] index2 = new int[infos.length];
        for (i = 0; i < infos.length; ++i) {
            info = infos[i];
            index2[i] = !info.isSkippedOrRemapped() ? this.codegen.getFrameMap().enterTemp(info.getType()) : -1;
        }
        for (i = infos.length - 1; i >= 0; --i) {
            info = infos[i];
            if (info.isSkippedOrRemapped()) continue;
            Type type2 = info.type;
            StackValue.local(index2[i], type2).store(StackValue.onStack(type2), this.codegen.v);
        }
    }

    @Override
    public void putHiddenParams() {
        List<JvmMethodParameterSignature> valueParameters = this.jvmSignature.getValueParameters();
        if (!InlineCodegen.isStaticMethod(this.functionDescriptor, this.context)) {
            this.invocationParamBuilder.addNextParameter(AsmTypes.OBJECT_TYPE, false, null);
        }
        for (JvmMethodParameterSignature param : valueParameters) {
            if (param.getKind() == JvmMethodParameterKind.VALUE) break;
            this.invocationParamBuilder.addNextParameter(param.getAsmType(), false, null);
        }
        List<ParameterInfo> infos = this.invocationParamBuilder.listNotCaptured();
        this.putParameterOnStack(infos.toArray(new ParameterInfo[infos.size()]));
    }

    public void leaveTemps() {
        FrameMap frameMap = this.codegen.getFrameMap();
        List<ParameterInfo> infos = this.invocationParamBuilder.listAllParams();
        ListIterator<ParameterInfo> iterator2 = infos.listIterator(infos.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo param = iterator2.previous();
            if (param.isSkippedOrRemapped()) continue;
            frameMap.leaveTemp(param.type);
        }
    }

    public static boolean isInliningParameter(JetExpression expression, ValueParameterDescriptor valueParameterDescriptor) {
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression);
        return InlineUtil.isInlineLambdaParameter(valueParameterDescriptor) && InlineCodegen.isInlinableParameterExpression(deparenthesized);
    }

    protected static boolean isInlinableParameterExpression(JetExpression deparenthesized) {
        return deparenthesized instanceof JetFunctionLiteralExpression || deparenthesized instanceof JetNamedFunction || deparenthesized instanceof JetCallableReferenceExpression;
    }

    public void rememberClosure(JetExpression expression, Type type2) {
        JetExpression lambda2 = JetPsiUtil.deparenthesize(expression);
        assert (InlineCodegen.isInlinableParameterExpression(lambda2)) : "Couldn't find inline expression in " + expression.getText();
        LambdaInfo info = new LambdaInfo(lambda2, this.typeMapper);
        ParameterInfo closureInfo = this.invocationParamBuilder.addNextParameter(type2, true, null);
        closureInfo.setLambda(info);
        this.expressionMap.put(closureInfo.getIndex(), info);
    }

    @NotNull
    protected static Set<String> getDeclarationLabels(@Nullable PsiElement lambdaOrFun, @NotNull DeclarationDescriptor descriptor2) {
        Name label;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDeclarationLabels"));
        }
        HashSet<String> result2 = new HashSet<String>();
        if (lambdaOrFun != null && (label = LabelResolver.INSTANCE.getLabelNameIfAny(lambdaOrFun)) != null) {
            result2.add(label.asString());
        }
        if (!DescriptorUtils.isFunctionLiteral(descriptor2)) {
            if (!descriptor2.getName().isSpecial()) {
                result2.add(descriptor2.getName().asString());
            }
            result2.add("$$$$$ROOT$$$$$");
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "getDeclarationLabels"));
        }
        return hashSet;
    }

    private void putClosureParametersOnStack() {
        Iterator<LambdaInfo> i$ = this.expressionMap.values().iterator();
        while (i$.hasNext()) {
            LambdaInfo next;
            this.activeLambda = next = i$.next();
            this.codegen.pushClosureOnStack(next.getClassDescriptor(), true, this);
        }
        this.activeLambda = null;
    }

    public static CodegenContext getContext(DeclarationDescriptor descriptor2, GenerationState state) {
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            return new PackageContext((PackageFragmentDescriptor)descriptor2, state.getRootContext(), null);
        }
        CodegenContext parent = InlineCodegen.getContext(descriptor2.getContainingDeclaration(), state);
        if (descriptor2 instanceof ClassDescriptor) {
            OwnerKind kind = DescriptorUtils.isTrait(descriptor2) ? OwnerKind.TRAIT_IMPL : OwnerKind.IMPLEMENTATION;
            return parent.intoClass((ClassDescriptor)descriptor2, kind, state);
        }
        if (descriptor2 instanceof ScriptDescriptor) {
            ClassDescriptor classDescriptorForScript = state.getBindingContext().get(CodegenBinding.CLASS_FOR_SCRIPT, (ScriptDescriptor)descriptor2);
            assert (classDescriptorForScript != null) : "Can't find class for script: " + descriptor2;
            List<ScriptDescriptor> earlierScripts = state.getEarlierScriptsForReplInterpreter();
            return parent.intoScript((ScriptDescriptor)descriptor2, earlierScripts == null ? Collections.emptyList() : earlierScripts, classDescriptorForScript);
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            return parent.intoFunction((FunctionDescriptor)descriptor2);
        }
        throw new IllegalStateException("Couldn't build context for " + InlineCodegen.descriptorName(descriptor2));
    }

    private static boolean isStaticMethod(FunctionDescriptor functionDescriptor, MethodContext context) {
        return (AsmUtil.getMethodAsmFlags(functionDescriptor, context.getContextKind()) & 8) != 0;
    }

    private static String descriptorName(DeclarationDescriptor descriptor2) {
        return DescriptorRenderer.SHORT_NAMES_IN_TYPES.render(descriptor2);
    }

    @Override
    public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (InlineCodegen.isInliningParameter(argumentExpression, valueParameterDescriptor)) {
            this.rememberClosure(argumentExpression, parameterType);
        } else {
            StackValue value = this.codegen.gen(argumentExpression);
            this.putValueIfNeeded(valueParameterDescriptor, parameterType, value);
        }
    }

    @Override
    public void putValueIfNeeded(@Nullable ValueParameterDescriptor valueParameterDescriptor, @NotNull Type parameterType, @NotNull StackValue value) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (this.shouldPutValue(parameterType, value, valueParameterDescriptor)) {
            value.put(parameterType, this.codegen.v);
        }
        this.afterParameterPut(parameterType, value, valueParameterDescriptor);
    }

    @Override
    public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (this.shouldPutValue(stackValue.type, stackValue, null)) {
            stackValue.put(stackValue.type, this.codegen.v);
        }
        this.putCapturedInLocal(stackValue.type, stackValue, null, paramIndex);
    }

    public void generateAndInsertFinallyBlocks(@NotNull MethodNode intoNode, @NotNull List<MethodInliner.PointForExternalFinallyBlocks> insertPoints, int offsetForFinallyLocalVar) {
        if (intoNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intoNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateAndInsertFinallyBlocks"));
        }
        if (insertPoints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertPoints", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateAndInsertFinallyBlocks"));
        }
        if (!this.codegen.hasFinallyBlocks()) {
            return;
        }
        HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks> extensionPoints = new HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks>();
        for (MethodInliner.PointForExternalFinallyBlocks insertPoint : insertPoints) {
            extensionPoints.put(insertPoint.beforeIns, insertPoint);
        }
        DefaultProcessor processor = new DefaultProcessor(intoNode, offsetForFinallyLocalVar);
        int curFinallyDepth = 0;
        for (AbstractInsnNode curInstr = intoNode.instructions.getFirst(); curInstr != null; curInstr = curInstr.getNext()) {
            MethodInliner.PointForExternalFinallyBlocks extension;
            processor.processInstruction(curInstr, true);
            if (InlineCodegenUtil.isFinallyStart(curInstr)) {
                curFinallyDepth = InlineCodegenUtil.getConstant(curInstr.getPrevious());
            }
            if ((extension = (MethodInliner.PointForExternalFinallyBlocks)extensionPoints.get(curInstr)) == null) continue;
            Label start = new Label();
            MethodNode finallyNode = InlineCodegenUtil.createEmptyMethodNode();
            finallyNode.visitLabel(start);
            ExpressionCodegen finallyCodegen = new ExpressionCodegen(finallyNode, this.codegen.getFrameMap(), this.codegen.getReturnType(), this.codegen.getContext(), this.codegen.getState(), this.codegen.getParentCodegen());
            finallyCodegen.addBlockStackElementsForNonLocalReturns(this.codegen.getBlockStackElements(), curFinallyDepth);
            FrameMap frameMap = finallyCodegen.getFrameMap();
            FrameMap.Mark mark = frameMap.mark();
            while (frameMap.getCurrentSize() < processor.getNextFreeLocalIndex()) {
                frameMap.enterTemp(Type.INT_TYPE);
            }
            finallyCodegen.generateFinallyBlocksIfNeeded(extension.returnType, extension.finallyIntervalEnd.getLabel());
            InlineCodegenUtil.insertNodeBefore(finallyNode, intoNode, curInstr);
            SimpleInterval splitBy = new SimpleInterval((LabelNode)start.info, extension.finallyIntervalEnd);
            processor.getTryBlocksMetaInfo().splitCurrentIntervals(splitBy, true);
            processor.getLocalVarsMetaInfo().splitCurrentIntervals(splitBy, true);
            mark.dropTo();
        }
        processor.substituteTryBlockNodes(intoNode);
    }

    public void removeFinallyMarkers(@NotNull MethodNode intoNode) {
        if (intoNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intoNode", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "removeFinallyMarkers"));
        }
        if (InlineCodegenUtil.isFinallyMarkerRequired(this.codegen.getContext())) {
            return;
        }
        InsnList instructions = intoNode.instructions;
        AbstractInsnNode curInstr = instructions.getFirst();
        while (curInstr != null) {
            if (InlineCodegenUtil.isFinallyMarker(curInstr)) {
                AbstractInsnNode marker = curInstr;
                InlineCodegenUtil.getConstant(marker.getPrevious());
                curInstr = curInstr.getNext();
                instructions.remove(marker.getPrevious());
                instructions.remove(marker);
                continue;
            }
            curInstr = curInstr.getNext();
        }
    }

    private SourceMapper createNestedSourceMapper(@NotNull SMAPAndMethodNode nodeAndSmap) {
        if (nodeAndSmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeAndSmap", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createNestedSourceMapper"));
        }
        return new NestedSourceMapper(this.sourceMapper, nodeAndSmap.getRanges(), nodeAndSmap.getClassSMAP().getSourceInfo());
    }

    private void reportIncrementalInfo(@NotNull FunctionDescriptor sourceDescriptor, @NotNull FunctionDescriptor targetDescriptor) {
        if (sourceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reportIncrementalInfo"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "reportIncrementalInfo"));
        }
        IncrementalCompilationComponents incrementalCompilationComponents = this.state.getIncrementalCompilationComponents();
        TargetId targetId = this.state.getTargetId();
        if (incrementalCompilationComponents == null || targetId == null) {
            return;
        }
        IncrementalCache incrementalCache = incrementalCompilationComponents.getIncrementalCache(targetId);
        String sourceFile = InlinePackage.getClassFilePath(sourceDescriptor, incrementalCache);
        String targetFile = InlinePackage.getSourceFilePath(targetDescriptor);
        incrementalCache.registerInline(sourceFile, this.jvmSignature.toString(), targetFile);
    }

    private static class FakeMemberCodegen
    extends MemberCodegen {
        private final MemberCodegen delegate;
        @NotNull
        private final String className;

        public FakeMemberCodegen(@NotNull MemberCodegen wrapped, @NotNull JetElement declaration, @NotNull FieldOwnerContext codegenContext, @NotNull String className) {
            if (wrapped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (codegenContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            super(wrapped, declaration, codegenContext);
            this.delegate = wrapped;
            this.className = className;
        }

        @Override
        protected void generateDeclaration() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateBody() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateKotlinAnnotation() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public NameGenerator getInlineNameGenerator() {
            NameGenerator nameGenerator = this.delegate.getInlineNameGenerator();
            if (nameGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "getInlineNameGenerator"));
            }
            return nameGenerator;
        }

        @Override
        @NotNull
        public String getClassName() {
            String string = this.className;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "getClassName"));
            }
            return string;
        }
    }
}

