/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.BridgesPackage;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public abstract class ClassBodyCodegen
extends MemberCodegen<JetClassOrObject> {
    protected final JetClassOrObject myClass;
    protected final OwnerKind kind;
    protected final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull JetClassOrObject myClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (myClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClass", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "<init>"));
        }
        super(state, parentCodegen, context, myClass, v);
        this.myClass = myClass;
        this.kind = context.getContextKind();
        this.descriptor = this.bindingContext.get(BindingContext.CLASS, myClass);
    }

    @Override
    protected void generateBody() {
        if (this.kind != OwnerKind.TRAIT_IMPL) {
            for (JetDeclaration declaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(declaration)) continue;
                this.generateDeclaration(declaration);
            }
        }
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(declaration)) continue;
            this.generateDeclaration(declaration);
        }
        if (!DescriptorUtils.isTrait(this.descriptor)) {
            for (DeclarationDescriptor memberDescriptor : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
                FunctionDescriptor member;
                if (!(memberDescriptor instanceof FunctionDescriptor) || (member = (FunctionDescriptor)memberDescriptor).getKind().isReal() || BridgesPackage.findTraitImplementation(member) != null) continue;
                this.functionCodegen.generateBridges(member);
            }
        }
        this.generatePrimaryConstructorProperties();
    }

    private static boolean shouldProcessFirst(JetDeclaration declaration) {
        return !(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction);
    }

    protected void generateDeclaration(JetDeclaration declaration) {
        if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
            this.genFunctionOrProperty(declaration);
        } else if (declaration instanceof JetClassOrObject) {
            if (declaration instanceof JetEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (JetEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject((JetClassOrObject)declaration);
        }
    }

    private void generatePrimaryConstructorProperties() {
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        for (JetParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                this.propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
                continue;
            }
            this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor);
        }
    }

    @NotNull
    protected List<JetParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof JetClass) {
            List<JetParameter> list = ((JetClass)this.myClass).getPrimaryConstructorParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ClassBodyCodegen", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return DescriptorUtils.isTopLevelDeclaration(this.descriptor) ? null : this.descriptor;
    }
}

