/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;

class KotlinLightClassForAnonymousDeclaration
extends KotlinLightClassForExplicitDeclaration
implements PsiAnonymousClass {
    private static final Logger LOG = Logger.getInstance(KotlinLightClassForAnonymousDeclaration.class);
    private SoftReference<PsiClassType> cachedBaseType;

    KotlinLightClassForAnonymousDeclaration(@NotNull PsiManager manager, @NotNull FqName name, @NotNull JetClassOrObject classOrObject) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "<init>"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "<init>"));
        }
        super(manager, name, classOrObject);
        this.cachedBaseType = null;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = JavaPsiFacade.getElementFactory(this.getClassOrObject().getProject()).createReferenceElementByType(this.getBaseClassType());
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getBaseClassReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    @NotNull
    private String getFirstSupertypeFQName() {
        ClassDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            if ("java.lang.Object" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getFirstSupertypeFQName"));
            }
            return "java.lang.Object";
        }
        Collection<JetType> superTypes = descriptor2.getTypeConstructor().getSupertypes();
        if (superTypes.isEmpty()) {
            if ("java.lang.Object" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getFirstSupertypeFQName"));
            }
            return "java.lang.Object";
        }
        JetType superType = superTypes.iterator().next();
        ClassifierDescriptor superClassDescriptor = superType.getConstructor().getDeclarationDescriptor();
        if (superClassDescriptor == null) {
            LOG.error("No declaration descriptor for supertype " + superType + " of " + this.getDescriptor());
            if ("java.lang.Object" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getFirstSupertypeFQName"));
            }
            return "java.lang.Object";
        }
        String string = DescriptorUtils.getFqName(superClassDescriptor).asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getFirstSupertypeFQName"));
        }
        return string;
    }

    @Override
    @NotNull
    public synchronized PsiClassType getBaseClassType() {
        PsiType type2 = null;
        if (this.cachedBaseType != null) {
            type2 = (PsiClassType)this.cachedBaseType.get();
        }
        if (type2 != null && type2.isValid()) {
            PsiType psiType = type2;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getBaseClassType"));
            }
            return psiType;
        }
        String firstSupertypeFQName = this.getFirstSupertypeFQName();
        for (PsiClassType superType : this.getSuperTypes()) {
            PsiClass superClass = superType.resolve();
            if (superClass == null || !firstSupertypeFQName.equals(superClass.getQualifiedName())) continue;
            type2 = superType;
            break;
        }
        if (type2 == null) {
            Project project = this.getClassOrObject().getProject();
            type2 = PsiType.getJavaLangObject(PsiManager.getInstance(project), GlobalSearchScope.allScope(project));
        }
        this.cachedBaseType = new SoftReference<PsiType>(type2);
        PsiType psiType = type2;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForAnonymousDeclaration", "getBaseClassType"));
        }
        return psiType;
    }

    @Override
    @Nullable
    public PsiExpressionList getArgumentList() {
        return null;
    }

    @Override
    public boolean isInQualifiedNew() {
        return false;
    }
}

