/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;

public class NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    @NotNull
    public static NameResolver read(@NotNull InputStream in) {
        NameResolver nameResolver;
        block3: {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "read"));
            }
            try {
                ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(in);
                ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
                nameResolver = new NameResolver(simpleNames, qualifiedNames);
                if (nameResolver != null) break block3;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "read"));
        }
        return nameResolver;
    }

    public NameResolver(@NotNull ProtoBuf.StringTable strings, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "<init>"));
        }
        if (qualifiedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNames", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "<init>"));
        }
        this.strings = strings;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public String getString(int index2) {
        String string = this.strings.getString(index2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "getString"));
        }
        return string;
    }

    @NotNull
    public Name getName(int index2) {
        Name name = Name.guess(this.strings.getString(index2));
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "getName"));
        }
        return name;
    }

    @NotNull
    public ClassId getClassId(int index2) {
        LinkedList<String> packageFqName = new LinkedList<String>();
        LinkedList<String> relativeClassName = new LinkedList<String>();
        boolean local = false;
        while (index2 != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index2);
            String shortName = this.strings.getString(proto.getShortName());
            switch (proto.getKind()) {
                case CLASS: {
                    relativeClassName.addFirst(shortName);
                    break;
                }
                case PACKAGE: {
                    packageFqName.addFirst(shortName);
                    break;
                }
                case LOCAL: {
                    relativeClassName.addFirst(shortName);
                    local = true;
                }
            }
            index2 = proto.getParentQualifiedName();
        }
        ClassId classId = new ClassId(FqName.fromSegments(packageFqName), FqName.fromSegments(relativeClassName), local);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "getClassId"));
        }
        return classId;
    }

    @NotNull
    public FqName getFqName(int index2) {
        ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(index2);
        Name shortName = this.getName(qualifiedName.getShortName());
        if (!qualifiedName.hasParentQualifiedName()) {
            FqName fqName2 = FqName.topLevel(shortName);
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "getFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = this.getFqName(qualifiedName.getParentQualifiedName()).child(shortName);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/deserialization/NameResolver", "getFqName"));
        }
        return fqName3;
    }
}

