/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name, @NotNull ElementFilter filter2, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container, @NotNull PsiElement place, PsiFile placeFile) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        if (resolvers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvers", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        super(filter2, container);
        this.myResolvers = resolvers;
        this.myName = name;
        this.myPlace = place;
        this.myPlaceFile = placeFile;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "execute"));
        }
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult != null && cachedResult.length == 1 && cachedResult[0].isAccessible()) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace)) {
            return super.execute(element, state);
        }
        return true;
    }

    @Override
    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "add"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "add"));
        }
        this.add(new CandidateInfo(element, substitutor2));
    }

    protected void add(CandidateInfo info) {
        this.myCachedResult = null;
        this.myResults.add(info);
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "handleEvent"));
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    @NotNull
    public JavaResolveResult[] getResult() {
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            for (PsiConflictResolver resolver2 : this.myResolvers) {
                CandidateInfo candidate = resolver2.resolveConflict(conflicts);
                if (candidate == null) continue;
                conflicts.clear();
                conflicts.add(candidate);
                break;
            }
            cachedResult = conflicts.toArray(new JavaResolveResult[conflicts.size()]);
            this.myCachedResult = cachedResult;
        }
        if (cachedResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "getResult"));
        }
        return cachedResult;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "getName"));
        }
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/scope/processor/ConflictFilterProcessor", "getHint"));
        }
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }
}

