/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.serialization.deserialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;

import java.util.List;

public interface ErrorReporter {
    void reportIncompatibleAbiVersion(@NotNull ClassId classId, @NotNull String filePath, @NotNull BinaryVersion actualVersion);

    void reportIncompleteHierarchy(@NotNull ClassDescriptor descriptor, @NotNull List<String> unresolvedSuperClasses);

    void reportCannotInferVisibility(@NotNull CallableMemberDescriptor descriptor);

    void reportLoadingError(@NotNull String message, @Nullable Exception exception);

    ErrorReporter DO_NOTHING = new ErrorReporter() {
        @Override
        public void reportIncompatibleAbiVersion(
                @NotNull ClassId classId, @NotNull String filePath, @NotNull BinaryVersion actualVersion
        ) {
        }

        @Override
        public void reportIncompleteHierarchy(@NotNull ClassDescriptor descriptor, @NotNull List<String> unresolvedSuperClasses) {
        }

        @Override
        public void reportCannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
        }

        @Override
        public void reportLoadingError(@NotNull String message, @Nullable Exception exception) {
        }
    };
}
