/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u001a\u0012\u0010\b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\f\u001a\u00020\u0004*\u00020\u0005\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "deleteLogged", "", "Ljava/io/File;", "forceDeleteIfExists", "", "hasExtension", "expected", "", "isJar", "isZip", "structure-base"})
public final class FileUtilKt {
    private static final Logger LOG = LoggerFactory.getLogger((String)"structure.FileUtil");

    public static final boolean isZip(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FileUtilKt.hasExtension($receiver, "zip");
    }

    public static final boolean isJar(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FileUtilKt.hasExtension($receiver, "jar");
    }

    public static final boolean hasExtension(@NotNull File $receiver, @NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return $receiver.isFile() && Intrinsics.areEqual((Object)expected, (Object)FilesKt.getExtension((File)$receiver));
    }

    public static final void forceDeleteIfExists(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.exists()) {
            FileUtils.forceDelete((File)$receiver);
        }
    }

    public static final boolean deleteLogged(@NotNull File $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            FileUtilKt.forceDeleteIfExists($receiver);
            bl = true;
        }
        catch (Exception e) {
            LOG.error("Unable to delete " + $receiver, (Throwable)e);
            bl = false;
        }
        return bl;
    }
}

