/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.logging.Logger;
import com.jetbrains.plugin.structure.base.logging.LoggerFactory;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010(\n\u0000\n\u0002\u0010\"\n\u0000\u001a\u001b\u0010\u0002\u001a\u00020\u0003\"\n\b\u0000\u0010\u0004*\u0004\u0018\u00010\u0005*\u0002H\u0004\u00a2\u0006\u0002\u0010\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\t\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000b\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"LOG", "Lcom/jetbrains/plugin/structure/base/logging/Logger;", "closeLogged", "", "T", "Ljava/io/Closeable;", "(Ljava/io/Closeable;)V", "toList", "", "", "toSet", "", "structure-base_main"})
public final class LanguageUtilsKt {
    private static final Logger LOG = LoggerFactory.INSTANCE.createDefaultLogger("LanguageUtils");

    public static final <T extends Closeable> void closeLogged(T $receiver) {
        try {
            T t = $receiver;
            if (t != null) {
                t.close();
            }
        }
        catch (Exception e) {
            LOG.error("Unable to close " + $receiver, e);
        }
    }

    @NotNull
    public static final <T> List<T> toList(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.toList((Sequence)SequencesKt.asSequence($receiver));
    }

    @NotNull
    public static final <T> Set<T> toSet(@NotNull Iterator<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.toSet((Sequence)SequencesKt.asSequence($receiver));
    }
}

