/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/ZipUtil;", "", "()V", "archiveDirectory", "", "directory", "Ljava/io/File;", "destination", "createArchiver", "Lorg/codehaus/plexus/archiver/AbstractArchiver;", "file", "extractZip", "pluginZip", "destDir", "structure-base"})
public final class ZipUtil {
    public static final ZipUtil INSTANCE;

    public final void extractZip(@NotNull File pluginZip, @NotNull File destDir) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)pluginZip, (String)"pluginZip");
        Intrinsics.checkParameterIsNotNull((Object)destDir, (String)"destDir");
        ZipUnArchiver ua = new ZipUnArchiver(pluginZip);
        ua.enableLogging((Logger)new ConsoleLogger(2, ""));
        FileUtils.forceMkdir((File)destDir);
        ua.setDestDirectory(destDir);
        ua.extract();
    }

    public final void archiveDirectory(@NotNull File directory, @NotNull File destination) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        AbstractArchiver archiver = this.createArchiver(destination);
        archiver.enableLogging((Logger)new ConsoleLogger(3, "Unarchive logger"));
        archiver.addDirectory(directory, directory.getName() + "/");
        archiver.setDestFile(destination);
        archiver.createArchive();
    }

    private final AbstractArchiver createArchiver(File file) {
        String string;
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String name = string4;
        if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null)) {
            return (AbstractArchiver)new TarArchiver();
        }
        if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null)) {
            return (AbstractArchiver)new ZipArchiver();
        }
        if (StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) {
            return (AbstractArchiver)new JarArchiver();
        }
        throw (Throwable)new IllegalArgumentException("Unable to extract " + file + "- unknown file extension: " + name);
    }

    private ZipUtil() {
    }

    static {
        ZipUtil zipUtil;
        INSTANCE = zipUtil = new ZipUtil();
    }
}

