/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.decompress.Decompressor;
import com.jetbrains.plugin.structure.base.decompress.TarDecompressor;
import com.jetbrains.plugin.structure.base.decompress.ZipCompressor;
import com.jetbrains.plugin.structure.base.decompress.ZipDecompressor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a#\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"archiveDirectoryTo", "", "Ljava/io/File;", "destination", "extractTo", "outputSizeLimit", "", "(Ljava/io/File;Ljava/io/File;Ljava/lang/Long;)Ljava/io/File;", "structure-base"})
public final class ZipUtilKt {
    @NotNull
    public static final File extractTo(@NotNull File $this$extractTo, @NotNull File destination, @Nullable Long outputSizeLimit) {
        Decompressor decompressor;
        Intrinsics.checkParameterIsNotNull((Object)$this$extractTo, (String)"$this$extractTo");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        String string = $this$extractTo.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
            decompressor = new ZipDecompressor($this$extractTo, outputSizeLimit);
        } else {
            String string2 = $this$extractTo.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            if (StringsKt.endsWith$default((String)string2, (String)".tar.gz", (boolean)false, (int)2, null)) {
                decompressor = new TarDecompressor($this$extractTo, outputSizeLimit);
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown type archive type: " + destination.getName());
            }
        }
        Decompressor decompressor2 = decompressor;
        FileUtilKt.createDir(destination);
        decompressor2.extract(destination);
        return destination;
    }

    public static /* synthetic */ File extractTo$default(File file, File file2, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = null;
        }
        return ZipUtilKt.extractTo(file, file2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void archiveDirectoryTo(@NotNull File $this$archiveDirectoryTo, @NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)$this$archiveDirectoryTo, (String)"$this$archiveDirectoryTo");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = Intrinsics.areEqual((Object)FilesKt.getExtension((File)destination), (Object)"zip") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)destination), (Object)"jar") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)destination), (Object)"nupkg");
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        FileUtilKt.forceDeleteIfExists(destination);
        Closeable closeable = new ZipCompressor(destination);
        bl2 = false;
        Throwable throwable = null;
        try {
            ZipCompressor zip = (ZipCompressor)closeable;
            boolean bl6 = false;
            zip.addDirectory($this$archiveDirectoryTo);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

