/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import com.jetbrains.plugin.structure.base.decompress.Decompressor;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/ZipDecompressor;", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor;", "source", "Ljava/io/File;", "sizeLimit", "", "(Ljava/io/File;Ljava/lang/Long;)V", "entries", "Ljava/util/Enumeration;", "Ljava/util/zip/ZipEntry;", "entry", "zipFile", "Ljava/util/zip/ZipFile;", "closeNextEntryStream", "", "entryStream", "Ljava/io/InputStream;", "closeStream", "nextEntry", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Entry;", "nextEntryStream", "openStream", "structure-base"})
public final class ZipDecompressor
extends Decompressor {
    private ZipFile zipFile;
    private Enumeration<? extends ZipEntry> entries;
    private ZipEntry entry;
    private final File source;

    @Override
    public void openStream() {
        ZipFile zipFile = this.zipFile = new ZipFile(this.source);
        if (zipFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipFile");
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zipFile.entries()");
        this.entries = enumeration;
    }

    @Override
    @Nullable
    public Decompressor.Entry nextEntry() {
        ZipEntry nextEntry;
        ZipEntry zipEntry;
        Enumeration<? extends ZipEntry> enumeration = this.entries;
        if (enumeration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"entries");
        }
        if (enumeration.hasMoreElements()) {
            Enumeration<? extends ZipEntry> enumeration2 = this.entries;
            if (enumeration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"entries");
            }
            zipEntry = enumeration2.nextElement();
        } else {
            zipEntry = null;
        }
        this.entry = nextEntry = zipEntry;
        if (nextEntry == null) {
            return null;
        }
        Decompressor.Type type = nextEntry.isDirectory() ? Decompressor.Type.DIR : Decompressor.Type.FILE;
        String string = nextEntry.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nextEntry.name");
        return new Decompressor.Entry(string, type);
    }

    @Override
    public void closeNextEntryStream(@NotNull InputStream entryStream) {
        Intrinsics.checkParameterIsNotNull((Object)entryStream, (String)"entryStream");
        entryStream.close();
    }

    @Override
    @Nullable
    public InputStream nextEntryStream() {
        ZipFile zipFile = this.zipFile;
        if (zipFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipFile");
        }
        return zipFile.getInputStream(this.entry);
    }

    @Override
    public void closeStream() {
        ZipFile zipFile = this.zipFile;
        if (zipFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zipFile");
        }
        zipFile.close();
    }

    public ZipDecompressor(@NotNull File source, @Nullable Long sizeLimit) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super(sizeLimit, null);
        this.source = source;
    }
}

