/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryException;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import retrofit2.Call;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"downloadFile", "Ljava/io/File;", "executed", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "targetPath", "downloadPlugin", "callable", "Lretrofit2/Call;", "guessFileName", "", "response", "Lokhttp3/Response;", "url", "rest"})
public final class DownloadPluginHelperKt {
    @Nullable
    public static final File downloadPlugin(@NotNull Call<ResponseBody> callable, @NotNull File targetPath) {
        Object object;
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        retrofit2.Response<ResponseBody> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            File file;
            try {
                file = DownloadPluginHelperKt.downloadFile(response, targetPath);
            }
            catch (Exception e) {
                throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", new Object[0]), e);
            }
            return file;
        }
        if (response.code() == 404) {
            return null;
        }
        Object object2 = response.errorBody();
        if (object2 == null || (object2 = object2.string()) == null) {
            object2 = object = response.message();
        }
        if (object2 == null) {
            object = "";
        }
        Object object3 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object3;
        boolean bl3 = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl4 = false;
        String message = charSequence.length() > 0 ? ": " + (String)it : "";
        throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", new Object[0]) + message);
    }

    private static final File downloadFile(retrofit2.Response<ResponseBody> executed, File targetPath) {
        String mimeType;
        String url = executed.raw().request().url().url().toExternalForm();
        ResponseBody responseBody = (ResponseBody)executed.body();
        if (responseBody == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"executed.body() ?: return null");
        ResponseBody response = responseBody;
        MediaType mediaType = response.contentType();
        String string = mimeType = mediaType != null ? mediaType.toString() : null;
        if (Intrinsics.areEqual((Object)mimeType, (Object)"application/zip") ^ true && Intrinsics.areEqual((Object)mimeType, (Object)"application/java-archive") ^ true) {
            return null;
        }
        File targetFile = targetPath;
        if (targetFile.isDirectory()) {
            Response response2 = executed.raw();
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"executed.raw()");
            String string2 = url;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url");
            String guessFileName = DownloadPluginHelperKt.guessFileName(response2, string2);
            if (StringsKt.contains$default((CharSequence)guessFileName, (char)File.separatorChar, (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("invalid.filename", new Object[0]));
            }
            File file = new File(targetFile, guessFileName);
            if (Intrinsics.areEqual((Object)file.getParentFile(), (Object)targetFile) ^ true) {
                throw (Throwable)new IOException(Messages.INSTANCE.getMessage("invalid.filename", new Object[0]));
            }
            targetFile = file;
        }
        Files.copy(response.byteStream(), targetFile.toPath(), new CopyOption[0]);
        return targetFile;
    }

    private static final String guessFileName(Response response, String url) {
        String contentDispositionHeader;
        String string;
        String contentDisposition;
        Object v0;
        boolean bl;
        String filenameMarker;
        block4: {
            filenameMarker = "filename=";
            Iterable iterable = response.headers().names();
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            bl = false;
            for (Object t : iterable2) {
                String it = (String)t;
                boolean bl3 = false;
                if (!StringsKt.equals((String)it, (String)"Content-Disposition", (boolean)true)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        String string2 = contentDisposition = (String)v0;
        if (string2 != null) {
            String string3 = string2;
            boolean bl4 = false;
            bl = false;
            String it = string3;
            boolean bl5 = false;
            string = response.headers().get(contentDisposition);
        } else {
            string = contentDispositionHeader = null;
        }
        if (contentDispositionHeader == null || !StringsKt.contains$default((CharSequence)contentDispositionHeader, (CharSequence)filenameMarker, (boolean)false, (int)2, null)) {
            String fileName = StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null);
            CharSequence charSequence = fileName;
            bl = false;
            return charSequence.length() > 0 ? fileName : url;
        }
        return StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)contentDispositionHeader, (String)filenameMarker, (String)""), (char)';', null, (int)2, null), (CharSequence)"\"");
    }
}

