/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.utils;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryException;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.utils.PluginUploadRestError;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0002\u001a-\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"parseUploadErrorMessage", "", "errorBody", "Lokhttp3/ResponseBody;", "code", "", "pluginName", "uploadOrFail", "T", "callable", "Lretrofit2/Call;", "plugin", "(Lretrofit2/Call;Ljava/lang/String;)Ljava/lang/Object;", "rest"})
public final class UploadPluginHelperKt {
    public static final <T> T uploadOrFail(@NotNull Call<T> callable, @Nullable String plugin) {
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        Response<T> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            Object object = response.body();
            if (object == null) {
                throw (Throwable)new PluginRepositoryException(Messages.INSTANCE.getMessage("no.response.from.server", new Object[0]));
            }
            return (T)object;
        }
        String message = UploadPluginHelperKt.parseUploadErrorMessage(response.errorBody(), response.code(), plugin);
        throw (Throwable)new PluginRepositoryException("Upload failed: " + message);
    }

    public static /* synthetic */ Object uploadOrFail$default(Call call, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return UploadPluginHelperKt.uploadOrFail(call, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String parseUploadErrorMessage(ResponseBody errorBody, int code, String pluginName) {
        String string;
        ResponseBody responseBody = errorBody;
        if (responseBody == null) {
            return Messages.INSTANCE.getMessage("failed.upload", new Object[0]);
        }
        ResponseBody error = responseBody;
        if (code == 404) {
            Object[] objectArray = new Object[1];
            String string2 = pluginName;
            if (string2 == null) {
                string2 = "plugin";
            }
            objectArray[0] = string2;
            return Messages.INSTANCE.getMessage("not.found", objectArray);
        }
        MediaType mediaType = error.contentType();
        String contextType = mediaType != null ? mediaType.toString() : null;
        String string3 = contextType;
        if (string3 != null) {
            if (StringsKt.startsWith$default((String)string3, (String)"text/plain", (boolean)false, (int)2, null)) {
                string = error.string();
                return string;
            }
        }
        String string4 = contextType;
        if (string4 != null) {
            if (StringsKt.startsWith$default((String)string4, (String)"application/json", (boolean)false, (int)2, null)) {
                PluginUploadRestError restError = (PluginUploadRestError)ExtensionsKt.jacksonObjectMapper().readValue(error.string(), PluginUploadRestError.class);
                if (restError.getMsg() != null) {
                    return restError.getMsg();
                }
                string = restError.getMessage();
                if (string != null) return string;
                string = Messages.INSTANCE.getMessage("failed.upload", new Object[0]);
                return string;
            }
        }
        string = Messages.INSTANCE.getMessage("failed.upload", new Object[0]) + ' ' + error.string();
        return string;
    }

    static /* synthetic */ String parseUploadErrorMessage$default(ResponseBody responseBody, int n, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        return UploadPluginHelperKt.parseUploadErrorMessage(responseBody, n, string);
    }
}

