/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.CompositeConverter;
import org.jetbrains.intellij.pluginRepository.PluginBean;
import org.jetbrains.intellij.pluginRepository.PluginInfoBean;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryInstance;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryRestKt;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryService;
import org.jetbrains.intellij.pluginRepository.RestCategoryBean;
import org.jetbrains.intellij.pluginRepository.RestError;
import org.jetbrains.intellij.pluginRepository.RestPluginBean;
import org.jetbrains.intellij.pluginRepository.RestPluginRepositoryBean;
import org.jetbrains.intellij.pluginRepository.exceptions.UploadFailedException;
import org.slf4j.Logger;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.mime.TypedString;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J,\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0003J,\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0003H\u0002J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001a\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u0003J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J \u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002J \u0010+\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003H\u0002J&\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003J0\u00101\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020/2\u0006\u0010-\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0003H\u0007J0\u00101\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0003H\u0007JE\u00103\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u00142\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u00104R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/intellij/pluginRepository/PluginRepositoryInstance;", "", "siteUrl", "", "token", "(Ljava/lang/String;Ljava/lang/String;)V", "service", "Lorg/jetbrains/intellij/pluginRepository/PluginRepositoryService;", "kotlin.jvm.PlatformType", "getSiteUrl", "()Ljava/lang/String;", "convertCategory", "", "Lorg/jetbrains/intellij/pluginRepository/PluginBean;", "response", "Lorg/jetbrains/intellij/pluginRepository/RestCategoryBean;", "convertPlugin", "Lorg/jetbrains/intellij/pluginRepository/RestPluginBean;", "category", "download", "Ljava/io/File;", "pluginXmlId", "version", "channel", "targetPath", "downloadCompatiblePlugin", "ideBuild", "downloadFile", "Lretrofit/client/Response;", "ensureCredentialsAreSet", "", "guessFileName", "url", "listPlugins", "pluginId", "pluginInfo", "Lorg/jetbrains/intellij/pluginRepository/PluginInfoBean;", "family", "processRetofitError", "e", "Lretrofit/RetrofitError;", "notFoundErrorMessage", "baseErrorMessage", "retrofitErrorMessage", "uploadNewPlugin", "file", "categoryId", "", "licenseUrl", "uploadPlugin", "notes", "uploadPluginInternal", "(Ljava/io/File;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "rest"})
public final class PluginRepositoryInstance {
    private final PluginRepositoryService service;
    @NotNull
    private final String siteUrl;
    private final String token;

    @JvmOverloads
    public final void uploadPlugin(int pluginId, @NotNull File file, @Nullable String channel, @Nullable String notes) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PluginRepositoryInstance.uploadPluginInternal$default(this, file, pluginId, null, channel, notes, 4, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void uploadPlugin$default(PluginRepositoryInstance pluginRepositoryInstance, int n, File file, String string, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        pluginRepositoryInstance.uploadPlugin(n, file, string, string2);
    }

    @JvmOverloads
    public final void uploadPlugin(int pluginId, @NotNull File file, @Nullable String channel) {
        PluginRepositoryInstance.uploadPlugin$default(this, pluginId, file, channel, null, 8, null);
    }

    @JvmOverloads
    public final void uploadPlugin(int pluginId, @NotNull File file) {
        PluginRepositoryInstance.uploadPlugin$default(this, pluginId, file, null, null, 12, null);
    }

    @JvmOverloads
    public final void uploadPlugin(@NotNull String pluginXmlId, @NotNull File file, @Nullable String channel, @Nullable String notes) {
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PluginRepositoryInstance.uploadPluginInternal$default(this, file, null, pluginXmlId, channel, notes, 2, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void uploadPlugin$default(PluginRepositoryInstance pluginRepositoryInstance, String string, File file, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        pluginRepositoryInstance.uploadPlugin(string, file, string2, string3);
    }

    @JvmOverloads
    public final void uploadPlugin(@NotNull String pluginXmlId, @NotNull File file, @Nullable String channel) {
        PluginRepositoryInstance.uploadPlugin$default(this, pluginXmlId, file, channel, null, 8, null);
    }

    @JvmOverloads
    public final void uploadPlugin(@NotNull String pluginXmlId, @NotNull File file) {
        PluginRepositoryInstance.uploadPlugin$default(this, pluginXmlId, file, null, null, 12, null);
    }

    @NotNull
    public final PluginInfoBean uploadNewPlugin(@NotNull File file, @NotNull String family, int categoryId, @NotNull String licenseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)family, (String)"family");
        Intrinsics.checkParameterIsNotNull((Object)licenseUrl, (String)"licenseUrl");
        this.ensureCredentialsAreSet();
        try {
            PluginRepositoryRestKt.access$getLOG$p().info("Uploading new plugin from " + file.getAbsolutePath());
            PluginInfoBean uploadedPlugin = this.service.uploadNewPlugin(PluginRepositoryRestKt.access$toTypedFile(file), family, new TypedString(licenseUrl), new TypedString(String.valueOf(categoryId)));
            PluginRepositoryRestKt.access$getLOG$p().info("" + uploadedPlugin.getName() + " was successfully uploaded with id " + uploadedPlugin.getId());
            return uploadedPlugin;
        }
        catch (RetrofitError e) {
            throw (Throwable)new UploadFailedException(this.processRetofitError(e, "", "Failed to upload plugin"), e);
        }
    }

    private final void uploadPluginInternal(File file, Integer pluginId, String pluginXmlId, String channel, String notes) {
        this.ensureCredentialsAreSet();
        try {
            Response response;
            TypedString typedString;
            TypedString typedString2;
            String it;
            PluginRepositoryService pluginRepositoryService;
            TypedString typedString3;
            String string;
            Logger logger = PluginRepositoryRestKt.access$getLOG$p();
            StringBuilder stringBuilder = new StringBuilder().append("Uploading plugin ");
            Object object = pluginXmlId;
            if (object == null) {
                object = pluginId;
            }
            logger.info(stringBuilder.append(object).append(" from ").append(file.getAbsolutePath()).append(" to ").append(this.siteUrl).toString());
            if (pluginXmlId != null) {
                TypedString typedString4;
                TypedString typedString5;
                PluginRepositoryService pluginRepositoryService2 = this.service;
                TypedString typedString6 = new TypedString(pluginXmlId);
                String string2 = channel;
                if (string2 != null) {
                    string = string2;
                    typedString3 = typedString6;
                    pluginRepositoryService = pluginRepositoryService2;
                    it = string;
                    typedString2 = new TypedString(it);
                    pluginRepositoryService2 = pluginRepositoryService;
                    typedString6 = typedString3;
                    typedString5 = typedString2;
                } else {
                    typedString5 = null;
                }
                String string3 = notes;
                if (string3 != null) {
                    string = string3;
                    typedString2 = typedString5;
                    typedString3 = typedString6;
                    pluginRepositoryService = pluginRepositoryService2;
                    it = string;
                    typedString = new TypedString(it);
                    pluginRepositoryService2 = pluginRepositoryService;
                    typedString6 = typedString3;
                    typedString5 = typedString2;
                    typedString4 = typedString;
                } else {
                    typedString4 = null;
                }
                response = pluginRepositoryService2.uploadByXmlId(typedString6, typedString5, typedString4, PluginRepositoryRestKt.access$toTypedFile(file));
            } else {
                TypedString typedString7;
                TypedString typedString8;
                PluginRepositoryService pluginRepositoryService3 = this.service;
                TypedString typedString9 = new TypedString(String.valueOf(pluginId));
                String string4 = channel;
                if (string4 != null) {
                    string = string4;
                    typedString3 = typedString9;
                    pluginRepositoryService = pluginRepositoryService3;
                    it = string;
                    typedString2 = new TypedString(it);
                    pluginRepositoryService3 = pluginRepositoryService;
                    typedString9 = typedString3;
                    typedString8 = typedString2;
                } else {
                    typedString8 = null;
                }
                String string5 = notes;
                if (string5 != null) {
                    string = string5;
                    typedString2 = typedString8;
                    typedString3 = typedString9;
                    pluginRepositoryService = pluginRepositoryService3;
                    it = string;
                    typedString = new TypedString(it);
                    pluginRepositoryService3 = pluginRepositoryService;
                    typedString9 = typedString3;
                    typedString8 = typedString2;
                    typedString7 = typedString;
                } else {
                    typedString7 = null;
                }
                response = pluginRepositoryService3.upload(typedString9, typedString8, typedString7, PluginRepositoryRestKt.access$toTypedFile(file));
            }
            Response response2 = response;
            PluginRepositoryRestKt.access$getLOG$p().info("Done: " + PluginRepositoryRestKt.access$getText$p(response2));
        }
        catch (RetrofitError e) {
            String notFoundErrorMessage = "Cannot find " + pluginXmlId + ". " + "Note that you need to upload the plugin to the repository at least once manually " + "(to specify options like the license, repository URL etc.) before uploads through the client can be used.";
            String errorMessage = this.processRetofitError(e, notFoundErrorMessage, "Failed to upload plugin");
            throw (Throwable)new UploadFailedException(errorMessage, e);
        }
    }

    static /* bridge */ /* synthetic */ void uploadPluginInternal$default(PluginRepositoryInstance pluginRepositoryInstance, File file, Integer n, String string, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        pluginRepositoryInstance.uploadPluginInternal(file, n, string, string2, string3);
    }

    private final void ensureCredentialsAreSet() {
        if (this.token == null) {
            throw (Throwable)new RuntimeException("Token must be set for uploading");
        }
    }

    @Nullable
    public final File download(@NotNull String pluginXmlId, @NotNull String version, @Nullable String channel, @NotNull String targetPath) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryRestKt.access$getLOG$p().info("Downloading " + pluginXmlId + ':' + version);
        try {
            file = this.downloadFile(this.service.download(pluginXmlId, version, channel), targetPath);
        }
        catch (RetrofitError e) {
            this.processRetofitError(e, "Cannot find " + pluginXmlId + ':' + version, "Can't download plugin");
            file = null;
        }
        return file;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ File download$default(PluginRepositoryInstance pluginRepositoryInstance, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pluginRepositoryInstance.download(string, string2, string3, string4);
    }

    @Nullable
    public final File downloadCompatiblePlugin(@NotNull String pluginXmlId, @NotNull String ideBuild, @Nullable String channel, @NotNull String targetPath) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
        Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
        PluginRepositoryRestKt.access$getLOG$p().info("Downloading " + pluginXmlId + " for " + ideBuild + " build");
        try {
            file = this.downloadFile(this.service.downloadCompatiblePlugin(pluginXmlId, ideBuild, channel), targetPath);
        }
        catch (RetrofitError e) {
            this.processRetofitError(e, "Cannot find " + pluginXmlId + " compatible with " + ideBuild + " build", "Can't download plugin");
            file = null;
        }
        return file;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ File downloadCompatiblePlugin$default(PluginRepositoryInstance pluginRepositoryInstance, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return pluginRepositoryInstance.downloadCompatiblePlugin(string, string2, string3, string4);
    }

    private final String processRetofitError(RetrofitError e, String notFoundErrorMessage, String baseErrorMessage) {
        if (Intrinsics.areEqual((Object)e.getKind(), (Object)RetrofitError.Kind.UNEXPECTED)) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            throw throwable;
        }
        String errorMessage = this.retrofitErrorMessage(e, baseErrorMessage, notFoundErrorMessage);
        PluginRepositoryRestKt.access$getLOG$p().error(errorMessage, (Throwable)e);
        return errorMessage;
    }

    private final String retrofitErrorMessage(RetrofitError e, String baseErrorMessage, String notFoundErrorMessage) {
        Object bodyAs;
        Response response = e.getResponse();
        if (response == null) {
            return "" + baseErrorMessage + ": " + e.getMessage();
        }
        Response response2 = response;
        if (response2.getStatus() == 404) {
            return notFoundErrorMessage;
        }
        String string = response2.getBody().mimeType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.body.mimeType()");
        if (StringsKt.startsWith$default((String)string, (String)"application/json", (boolean)false, (int)2, null) && (bodyAs = e.getBodyAs((Type)((Object)RestError.class))) instanceof RestError) {
            return ((RestError)bodyAs).getMsg();
        }
        String string2 = response2.getBody().mimeType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"response.body.mimeType()");
        if (StringsKt.startsWith$default((String)string2, (String)"text/plain", (boolean)false, (int)2, null)) {
            return e.getBody().toString();
        }
        return "" + baseErrorMessage + ". Response from server: " + response2.getStatus();
    }

    private final File downloadFile(Response response, String targetPath) {
        String mimeType = response.getBody().mimeType();
        if (Intrinsics.areEqual((Object)mimeType, (Object)"application/zip") ^ true && Intrinsics.areEqual((Object)mimeType, (Object)"application/java-archive") ^ true) {
            return null;
        }
        File targetFile = new File(targetPath);
        if (targetFile.isDirectory()) {
            String string = response.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.url");
            String guessFileName = this.guessFileName(response, string);
            if (StringsKt.contains$default((CharSequence)guessFileName, (char)File.separatorChar, (boolean)false, (int)2, null)) {
                throw (Throwable)new IOException("Invalid filename returned by a server");
            }
            File file = new File(targetFile, guessFileName);
            if (Intrinsics.areEqual((Object)file.getParentFile(), (Object)targetFile) ^ true) {
                throw (Throwable)new IOException("Invalid filename returned by a server");
            }
            targetFile = file;
        }
        Files.copy(response.getBody().in(), targetFile.toPath(), new CopyOption[0]);
        PluginRepositoryRestKt.access$getLOG$p().info("Downloaded successfully to " + targetFile.getAbsolutePath());
        return targetFile;
    }

    private final String guessFileName(Response response, String url) {
        Header contentDispositionHeader;
        String filenameMarker;
        block5: {
            String fileName;
            Object object;
            block4: {
                Object v2;
                block3: {
                    filenameMarker = "filename=";
                    List list = response.getHeaders();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"response.headers");
                    Iterable iterable = list;
                    object = iterable;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Header it;
                        Object t = iterator.next();
                        Header header = it = (Header)t;
                        Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"it");
                        if (!StringsKt.equals((String)header.getName(), (String)"Content-Disposition", (boolean)true)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                contentDispositionHeader = v2;
                if (contentDispositionHeader == null) break block4;
                String string = contentDispositionHeader.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentDispositionHeader.value");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)filenameMarker, (boolean)false, (int)2, null)) break block5;
            }
            return (object = (CharSequence)(fileName = StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null))).length() > 0 ? fileName : url;
        }
        String string = contentDispositionHeader.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentDispositionHeader.value");
        return StringsKt.removeSurrounding((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)string, (String)filenameMarker, (String)""), (char)';', null, (int)2, null), (CharSequence)"\"");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginBean> listPlugins(@NotNull String ideBuild, @Nullable String channel, @Nullable String pluginId) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ideBuild, (String)"ideBuild");
        RestPluginRepositoryBean response = this.service.listPlugins(ideBuild, channel, pluginId);
        List<RestCategoryBean> list2 = response.getCategories();
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                RestCategoryBean it = (RestCategoryBean)element$iv$iv;
                Iterable list$iv$iv = this.convertCategory(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final PluginInfoBean pluginInfo(@NotNull String family, @NotNull String pluginXmlId) {
        PluginInfoBean pluginInfoBean;
        Intrinsics.checkParameterIsNotNull((Object)family, (String)"family");
        Intrinsics.checkParameterIsNotNull((Object)pluginXmlId, (String)"pluginXmlId");
        try {
            pluginInfoBean = this.service.pluginInfo(family, pluginXmlId);
        }
        catch (RetrofitError e) {
            this.processRetofitError(e, "Cannot find " + pluginXmlId + " in " + family + " family", "Can't get plugin info");
            pluginInfoBean = null;
        }
        return pluginInfoBean;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginBean> convertCategory(RestCategoryBean response) {
        List list;
        List<RestPluginBean> list2 = response.getPlugins();
        if (list2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                RestPluginBean restPluginBean = (RestPluginBean)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = response.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                PluginBean pluginBean = this.convertPlugin((RestPluginBean)it, string);
                collection.add(pluginBean);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final PluginBean convertPlugin(RestPluginBean response, String category) {
        String string = response.getName();
        String string2 = response.getId();
        String string3 = response.getVersion();
        String string4 = response.getIdeaVersion().getSinceBuild();
        String string5 = response.getIdeaVersion().getUntilBuild();
        String string6 = response.getVendor();
        List list = response.getDepends();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return new PluginBean(string, string2, string3, category, string4, string5, string6, list);
    }

    @NotNull
    public final String getSiteUrl() {
        return this.siteUrl;
    }

    public PluginRepositoryInstance(@NotNull String siteUrl, @Nullable String token) {
        Intrinsics.checkParameterIsNotNull((Object)siteUrl, (String)"siteUrl");
        this.siteUrl = siteUrl;
        this.token = token;
        this.service = (PluginRepositoryService)new RestAdapter.Builder().setEndpoint(this.siteUrl).setClient((Client.Provider)service.1.INSTANCE).setRequestInterceptor(new RequestInterceptor(this){
            final /* synthetic */ PluginRepositoryInstance this$0;

            public final void intercept(RequestInterceptor.RequestFacade request) {
                if (PluginRepositoryInstance.access$getToken$p(this.this$0) != null) {
                    request.addHeader("Authorization", "Bearer " + PluginRepositoryInstance.access$getToken$p(this.this$0));
                }
            }
            {
                this.this$0 = pluginRepositoryInstance;
            }
        }).setLog((RestAdapter.Log)service.3.INSTANCE).setLogLevel(RestAdapter.LogLevel.BASIC).setConverter((Converter)new CompositeConverter()).build().create(PluginRepositoryService.class);
    }

    public /* synthetic */ PluginRepositoryInstance(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public static final /* synthetic */ String access$getToken$p(PluginRepositoryInstance $this) {
        return $this.token;
    }
}

