/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.java-time;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.java-time.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaLocalDateTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    private static final JavaLocalDateTimeColumnType INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof LocalDateTime) {
            instant = Instant.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()));
        } else if (object instanceof Date) {
            instant = Instant.ofEpochMilli(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            instant = Instant.ofEpochMilli(((Timestamp)value).getTime());
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Instant instant2 = instant;
        return DefaultKt.getCurrentDialect() instanceof SQLiteDialect ? '\'' + JavaDateColumnTypeKt.access$getSQLITE_DATE_TIME_STRING_FORMATTER$p().format(instant2) + '\'' : '\'' + JavaDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p().format(instant2) + '\'';
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        Object object2 = object instanceof LocalDateTime ? value : (object instanceof Date ? ((Date)value).toLocalDate().atStartOfDay() : (object instanceof Timestamp ? ((Timestamp)value).toLocalDateTime() : (object instanceof Integer ? LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).intValue()), ZoneId.systemDefault()) : (object instanceof Long ? LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), ZoneId.systemDefault()) : (object instanceof String ? LocalDateTime.parse((CharSequence)value, JavaDateColumnTypeKt.access$formatterForDateString((String)value)) : this.valueFromDB(value.toString()))))));
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"when(value) {\n        is\u2026B(value.toString())\n    }");
        return object2;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (value instanceof LocalDateTime) {
            Timestamp timestamp = Timestamp.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
            Intrinsics.checkExpressionValueIsNotNull((Object)timestamp, (String)"java.sql.Timestamp.from(\u2026emDefault()).toInstant())");
            return timestamp;
        }
        return value;
    }

    public JavaLocalDateTimeColumnType() {
        super(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new JavaLocalDateTimeColumnType();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/java-time/JavaLocalDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        @NotNull
        public final JavaLocalDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

