/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityCacheKt;
import org.jetbrains.exposed.dao.EntityHookKt;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpdateStatement;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementGroup;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/dao/EntityLifecycleInterceptor;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "()V", "beforeCommit", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "beforeExecution", "context", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "beforeRollback", "flushEntities", "query", "Lorg/jetbrains/exposed/sql/Query;", "exposed-dao"})
public final class EntityLifecycleInterceptor
implements GlobalStatementInterceptor {
    public void beforeExecution(@NotNull Transaction transaction, @NotNull StatementContext context) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Statement statement = context.getStatement();
        if (statement instanceof Query) {
            this.flushEntities(transaction, (Query)statement);
        } else if (statement instanceof DeleteStatement) {
            EntityCacheKt.flushCache(transaction);
            EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(CollectionsKt.listOf((Object)((DeleteStatement)statement).getTable()));
        } else if (statement instanceof InsertStatement) {
            EntityCacheKt.flushCache(transaction);
            EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(CollectionsKt.listOf((Object)((InsertStatement)statement).getTable()));
        } else if (!(statement instanceof BatchUpdateStatement)) {
            if (statement instanceof UpdateStatement) {
                EntityCacheKt.flushCache(transaction);
                EntityCacheKt.getEntityCache(transaction).removeTablesReferrers$exposed_dao(TableKt.targetTables((ColumnSet)((UpdateStatement)statement).getTargetsSet()));
            } else if (statement.getType().getGroup() == StatementGroup.DDL) {
                EntityCacheKt.flushCache(transaction);
            }
        }
    }

    public void beforeCommit(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        List<Entity<?>> created = EntityCacheKt.flushCache(transaction);
        EntityHookKt.alertSubscribers(transaction);
        List<Entity<?>> createdByHooks = EntityCacheKt.flushCache(transaction);
        EntityCache.Companion.invalidateGlobalCaches(CollectionsKt.plus((Collection)created, (Iterable)createdByHooks));
    }

    public void beforeRollback(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        EntityCache entityCache2 = EntityCacheKt.getEntityCache(transaction);
        entityCache2.clearReferrersCache();
        entityCache2.getData().clear();
        entityCache2.getInserts().clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void flushEntities(@NotNull Transaction $this$flushEntities, Query query2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = query2.getSet().getSource().getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Column column = (Column)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Table table = it.getTable();
            collection.add(table);
        }
        Set tables = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)((List)destination$iv$iv), IdTable.class));
        EntityCacheKt.getEntityCache($this$flushEntities).flush(tables);
    }

    public void afterCommit() {
        GlobalStatementInterceptor.DefaultImpls.afterCommit((GlobalStatementInterceptor)this);
    }

    public void afterExecution(@NotNull Transaction transaction, @NotNull List<StatementContext> contexts, @NotNull PreparedStatementApi executedStatement) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(contexts, (String)"contexts");
        Intrinsics.checkParameterIsNotNull((Object)executedStatement, (String)"executedStatement");
        GlobalStatementInterceptor.DefaultImpls.afterExecution((GlobalStatementInterceptor)this, (Transaction)transaction, contexts, (PreparedStatementApi)executedStatement);
    }

    public void afterRollback() {
        GlobalStatementInterceptor.DefaultImpls.afterRollback((GlobalStatementInterceptor)this);
    }
}

