/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityClass;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpdateStatement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0086\u0002R6\u0010\u0006\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/dao/EntityBatchUpdate;", "", "klass", "Lorg/jetbrains/exposed/dao/EntityClass;", "Lorg/jetbrains/exposed/dao/Entity;", "(Lorg/jetbrains/exposed/dao/EntityClass;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/dao/id/EntityID;", "Ljava/util/SortedMap;", "Lorg/jetbrains/exposed/sql/Column;", "getKlass", "()Lorg/jetbrains/exposed/dao/EntityClass;", "addBatch", "", "id", "execute", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "set", "column", "value", "exposed-dao"})
public final class EntityBatchUpdate {
    private final ArrayList<Pair<EntityID<?>, SortedMap<Column<?>, Object>>> data;
    @NotNull
    private final EntityClass<?, Entity<?>> klass;

    public final void addBatch(@NotNull EntityID<?> id) {
        Intrinsics.checkParameterIsNotNull(id, (String)"id");
        if (Intrinsics.areEqual((Object)id.getTable(), this.klass.getTable()) ^ true) {
            String string = "Table from Entity ID " + id.getTable().getTableName() + " differs from entity class " + this.klass.getTable().getTableName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.data.add(TuplesKt.to(id, new TreeMap()));
    }

    public final void set(@NotNull Column<?> column, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(column, (String)"column");
        SortedMap values = (SortedMap)((Pair)CollectionsKt.last((List)this.data)).getSecond();
        if (values.containsKey(column)) {
            String string = column + " is already initialized";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ((Map)values).put(column, value);
    }

    /*
     * WARNING - void declaration
     */
    public final int execute(@NotNull Transaction transaction) {
        void $this$fold$iv;
        void $this$groupByTo$iv$iv;
        Pair it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Iterable $this$filterNot$iv = this.data;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (((SortedMap)it.getSecond()).isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Pair)element$iv$iv;
            boolean bl = false;
            Set key$iv$iv = ((SortedMap)it.getSecond()).keySet();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object updateSets = destination$iv$iv;
        $this$groupBy$iv = updateSets.values();
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void set;
            Object element$iv$iv;
            element$iv$iv = (List)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            BatchUpdateStatement batchUpdateStatement = new BatchUpdateStatement(this.klass.getTable());
            int n = acc;
            boolean bl3 = false;
            boolean bl4 = false;
            BatchUpdateStatement it2 = batchUpdateStatement;
            boolean bl5 = false;
            it2.getData().addAll((Collection)set);
            Object object = it2.execute(transaction);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            int n2 = ((Number)object).intValue();
            accumulator$iv = n + n2;
        }
        return accumulator$iv;
    }

    @NotNull
    public final EntityClass<?, Entity<?>> getKlass() {
        return this.klass;
    }

    public EntityBatchUpdate(@NotNull EntityClass<?, ? extends Entity<?>> klass) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        this.klass = klass;
        this.data = new ArrayList();
    }
}

