/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.utils.process;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jenkinsci.utils.process.ProcessInputStream;

public class CommandBuilder
implements Serializable,
Cloneable {
    private final List<String> args = new ArrayList<String>();
    public final Map<String, String> env = new HashMap<String, String>();
    private File pwd;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CommandBuilder.class.getName());

    public CommandBuilder() {
    }

    public CommandBuilder(Collection<String> args) {
        this.addAll(args);
    }

    public CommandBuilder(String ... args) {
        this.add(args);
    }

    public ProcessBuilder build() {
        return new ProcessBuilder(this.args).directory(this.pwd);
    }

    public int system() throws IOException, InterruptedException {
        ProcessBuilder pb = this.build();
        pb.environment().putAll(Collections.unmodifiableMap(this.env));
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        return p.waitFor();
    }

    public ProcessInputStream popen() throws IOException {
        ProcessBuilder pb = this.build();
        pb.environment().putAll(Collections.unmodifiableMap(this.env));
        pb.redirectErrorStream(true);
        LOGGER.fine("Executing: " + this.toStringWithQuote());
        Process p = pb.start();
        p.getOutputStream().close();
        return new ProcessInputStream(p).withDisplayName(this.toStringWithQuote());
    }

    public CommandBuilder pwd(File dir) {
        this.pwd = dir;
        return this;
    }

    public CommandBuilder add(Object a) {
        return this.add(a.toString());
    }

    public CommandBuilder add(Object a, boolean mask) {
        return this.add(a.toString());
    }

    public CommandBuilder add(File f) {
        return this.add(f.getAbsolutePath());
    }

    public CommandBuilder add(String a) {
        if (a != null) {
            this.args.add(a);
        }
        return this;
    }

    public CommandBuilder prepend(String ... args) {
        this.args.addAll(0, Arrays.asList(args));
        return this;
    }

    public CommandBuilder addQuoted(String a) {
        return this.add('\"' + a + '\"');
    }

    public CommandBuilder addQuoted(String a, boolean mask) {
        return this.add('\"' + a + '\"');
    }

    public CommandBuilder add(Object ... args) {
        if (args != null) {
            for (Object arg : args) {
                this.add(arg);
            }
        }
        return this;
    }

    public CommandBuilder add(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.add(arg);
            }
        }
        return this;
    }

    public CommandBuilder add(CommandBuilder cmds) {
        if (cmds != null) {
            this.addAll(cmds.args);
            this.env.putAll(cmds.env);
        }
        return this;
    }

    public CommandBuilder addAll(Collection<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.add(arg);
            }
        }
        return this;
    }

    public CommandBuilder addKeyValuePair(String prefix, String key, String value) {
        if (key == null) {
            return this;
        }
        this.add((prefix == null ? "-D" : prefix) + key + '=' + value);
        return this;
    }

    public CommandBuilder addKeyValuePairs(String prefix, Map<String, String> props) {
        for (Map.Entry<String, String> e : props.entrySet()) {
            this.addKeyValuePair(prefix, e.getKey(), e.getValue());
        }
        return this;
    }

    public CommandBuilder addKeyValuePairs(String prefix, Map<String, String> props, Set<String> propsToMask) {
        for (Map.Entry<String, String> e : props.entrySet()) {
            this.addKeyValuePair(prefix, e.getKey(), e.getValue());
        }
        return this;
    }

    public String[] toCommandArray() {
        return this.args.toArray(new String[this.args.size()]);
    }

    public CommandBuilder clone() {
        CommandBuilder r = new CommandBuilder();
        r.args.addAll(this.args);
        r.env.putAll(this.env);
        r.pwd = this.pwd;
        return r;
    }

    public void clear() {
        this.args.clear();
        this.env.clear();
    }

    public List<String> toList() {
        return this.args;
    }

    public String toStringWithQuote() {
        StringBuilder buf = new StringBuilder();
        for (String arg : this.args) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (arg.indexOf(32) >= 0 || arg.length() == 0) {
                buf.append('\"').append(arg).append('\"');
                continue;
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public CommandBuilder toWindowsCommand(boolean escapeVars) {
        StringBuilder quotedArgs = new StringBuilder();
        for (String arg : this.args) {
            boolean percent = false;
            boolean quoted = false;
            for (int i = 0; i < arg.length(); ++i) {
                int c = arg.charAt(i);
                if (!(quoted || c != 32 && c != 42 && c != 63 && c != 44 && c != 59)) {
                    quoted = CommandBuilder.startQuoting(quotedArgs, arg, i);
                } else if (c == 94 || c == 38 || c == 60 || c == 62 || c == 124) {
                    if (!quoted) {
                        quoted = CommandBuilder.startQuoting(quotedArgs, arg, i);
                    }
                } else if (c == 34) {
                    if (!quoted) {
                        quoted = CommandBuilder.startQuoting(quotedArgs, arg, i);
                    }
                    quotedArgs.append('\"');
                } else if (percent && escapeVars && (c >= 65 && c <= 90 || c >= 97 && c <= 122)) {
                    if (!quoted) {
                        quoted = CommandBuilder.startQuoting(quotedArgs, arg, i);
                    }
                    quotedArgs.append('\"').append((char)c);
                    c = 34;
                }
                boolean bl = percent = c == 37;
                if (!quoted) continue;
                quotedArgs.append((char)c);
            }
            if (quoted) {
                quotedArgs.append('\"');
            } else {
                quotedArgs.append(arg);
            }
            quotedArgs.append(' ');
        }
        quotedArgs.append("&& exit %%ERRORLEVEL%%");
        return new CommandBuilder().add("cmd.exe", "/C").addQuoted(quotedArgs.toString());
    }

    public CommandBuilder toWindowsCommand() {
        return this.toWindowsCommand(false);
    }

    private static boolean startQuoting(StringBuilder buf, String arg, int atIndex) {
        buf.append('\"').append(arg.substring(0, atIndex));
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> envvar : this.env.entrySet()) {
            buf.append(envvar.getKey()).append('=');
            if (envvar.getValue().indexOf(32) >= 0) {
                buf.append('\"').append(envvar.getValue()).append('\"');
            } else {
                buf.append(envvar.getValue());
            }
            buf.append(' ');
        }
        for (int i = 0; i < this.args.size(); ++i) {
            String arg = this.args.get(i);
            if (i > 0) {
                buf.append(' ');
            }
            if (arg.indexOf(32) >= 0 || arg.length() == 0) {
                buf.append('\"').append(arg).append('\"');
                continue;
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandBuilder that = (CommandBuilder)o;
        if (!this.args.equals(that.args)) {
            return false;
        }
        if (!this.env.equals(that.env)) {
            return false;
        }
        return !(this.pwd != null ? !this.pwd.equals(that.pwd) : that.pwd != null);
    }

    public int hashCode() {
        int result = this.args.hashCode();
        result = 31 * this.env.hashCode();
        result = 31 * result + (this.pwd != null ? this.pwd.hashCode() : 0);
        return result;
    }
}

