/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.Extension;
import hudson.Util;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.UpdateUpdater;
import hudson.scm.subversion.WorkspaceUpdater;
import hudson.scm.subversion.WorkspaceUpdaterDescriptor;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class UpdateWithCleanUpdater
extends WorkspaceUpdater {
    private static final long serialVersionUID = 8427138737745329413L;

    @DataBoundConstructor
    public UpdateWithCleanUpdater() {
    }

    public WorkspaceUpdater.UpdateTask createTask() {
        return new TaskImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends WorkspaceUpdaterDescriptor {
        public String getDisplayName() {
            return Messages.UpdateWithCleanUpdater_DisplayName();
        }
    }

    public static class TaskImpl
    extends UpdateUpdater.TaskImpl {
        private static final long serialVersionUID = -5120852266435704852L;

        protected void preUpdate(SubversionSCM.ModuleLocation module, File local) throws SVNException, IOException {
            this.listener.getLogger().println("Cleaning up " + local);
            this.clientManager.getStatusClient().doStatus(local, null, SVNDepth.INFINITY, false, false, true, false, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    SVNStatusType s = status.getCombinedNodeAndContentsStatus();
                    if (s == SVNStatusType.STATUS_UNVERSIONED || s == SVNStatusType.STATUS_IGNORED || s == SVNStatusType.STATUS_MODIFIED) {
                        TaskImpl.this.listener.getLogger().println("Deleting " + status.getFile());
                        try {
                            File f = status.getFile();
                            if (f.isDirectory()) {
                                Util.deleteRecursive((File)f);
                            } else {
                                f.delete();
                            }
                        }
                        catch (IOException e) {
                            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (Throwable)e));
                        }
                    }
                }
            }, null);
        }
    }
}

