/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.tmatesoft.svn.core.internal.util.SVNDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubversionChangeLogSet
extends ChangeLogSet<LogEntry> {
    private final List<LogEntry> logs;
    private Map<String, Long> revisionMap;
    private boolean ignoreDirPropChanges;

    @Deprecated
    SubversionChangeLogSet(AbstractBuild<?, ?> build, List<LogEntry> logs) {
        this(build, logs, false);
    }

    SubversionChangeLogSet(AbstractBuild<?, ?> build, List<LogEntry> logs, boolean ignoreDirPropChanges) {
        super(build);
        this.ignoreDirPropChanges = ignoreDirPropChanges;
        this.logs = this.prepareChangeLogEntries(logs);
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public List<LogEntry> getLogs() {
        return this.logs;
    }

    public Iterator<LogEntry> iterator() {
        return this.logs.iterator();
    }

    public String getKind() {
        return "svn";
    }

    public synchronized Map<String, Long> getRevisionMap() throws IOException {
        if (this.revisionMap == null) {
            this.revisionMap = SubversionSCM.parseRevisionFile(this.build);
        }
        return this.revisionMap;
    }

    private List<LogEntry> prepareChangeLogEntries(List<LogEntry> items) {
        items = SubversionChangeLogSet.removeDuplicatedEntries(items);
        if (this.ignoreDirPropChanges) {
            items = SubversionChangeLogSet.removePropertyOnlyChanges(items);
        }
        Collections.sort(items, new ReverseByRevisionComparator());
        for (LogEntry log : items) {
            log.setParent(this);
        }
        return Collections.unmodifiableList(items);
    }

    static List<LogEntry> removePropertyOnlyChanges(List<LogEntry> items) {
        for (LogEntry entry : items) {
            entry.removePropertyOnlyPaths();
        }
        return items;
    }

    static List<LogEntry> removeDuplicatedEntries(List<LogEntry> items) {
        HashSet<LogEntry> entries = new HashSet<LogEntry>(items);
        return new ArrayList<LogEntry>(entries);
    }

    @Exported
    public List<RevisionInfo> getRevisions() throws IOException {
        ArrayList<RevisionInfo> r = new ArrayList<RevisionInfo>();
        for (Map.Entry<String, Long> e : this.getRevisionMap().entrySet()) {
            r.add(new RevisionInfo(e.getKey(), e.getValue()));
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseByRevisionComparator
    implements Comparator<LogEntry>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ReverseByRevisionComparator() {
        }

        @Override
        public int compare(LogEntry a, LogEntry b) {
            return b.getRevision() - a.getRevision();
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class Path
    implements ChangeLogSet.AffectedFile {
        private LogEntry entry;
        private char action;
        private String value;
        private String kind;

        public LogEntry getLogEntry() {
            return this.entry;
        }

        public void setLogEntry(LogEntry entry) {
            this.entry = entry;
        }

        public void setAction(String action) {
            this.action = action.charAt(0);
        }

        @Exported(name="file")
        public String getValue() {
            return this.value;
        }

        public String getPath() {
            return this.getValue();
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isPropOnlyChange() {
            return this.action == 'M' && "dir".equals(this.kind);
        }

        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        @Exported
        public EditType getEditType() {
            if (this.action == 'A') {
                return EditType.ADD;
            }
            if (this.action == 'D') {
                return EditType.DELETE;
            }
            return EditType.EDIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogEntry
    extends ChangeLogSet.Entry {
        private int revision;
        private User author;
        private String date;
        private String msg;
        private List<Path> paths = new ArrayList<Path>();

        public SubversionChangeLogSet getParent() {
            return (SubversionChangeLogSet)super.getParent();
        }

        protected void removePropertyOnlyPaths() {
            Iterator<Path> it = this.paths.iterator();
            while (it.hasNext()) {
                Path path = it.next();
                if (!path.isPropOnlyChange()) continue;
                it.remove();
            }
        }

        protected void setParent(ChangeLogSet changeLogSet) {
            super.setParent(changeLogSet);
        }

        @Exported
        public int getRevision() {
            return this.revision;
        }

        public void setRevision(int revision) {
            this.revision = revision;
        }

        public String getCommitId() {
            return String.valueOf(this.revision);
        }

        public long getTimestamp() {
            return this.date != null ? SVNDate.parseDate((String)this.date).getTime() : -1L;
        }

        public User getAuthor() {
            if (this.author == null) {
                return User.getUnknown();
            }
            return this.author;
        }

        public Collection<String> getAffectedPaths() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return LogEntry.this.preparePath(((Path)LogEntry.this.paths.get(index)).value);
                }

                @Override
                public int size() {
                    return LogEntry.this.paths.size();
                }
            };
        }

        private String preparePath(String path) {
            SCM scm = this.getParent().build.getProject().getScm();
            if (!(scm instanceof SubversionSCM)) {
                return path;
            }
            SubversionSCM.ModuleLocation[] locations = ((SubversionSCM)scm).getLocations();
            for (int i = 0; i < locations.length; ++i) {
                String newPath;
                String commonPart = this.findCommonPart(locations[i].remote, path);
                if (commonPart == null) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((newPath = path.substring(commonPart.length())).startsWith("/")) {
                    newPath = newPath.substring(1);
                }
                return newPath;
            }
            return path;
        }

        private String findCommonPart(String folder, String filePath) {
            if (folder == null || filePath == null) {
                return null;
            }
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            for (int i = 0; i < folder.length(); ++i) {
                String part = folder.substring(i);
                if (!filePath.startsWith(part)) continue;
                return part;
            }
            return null;
        }

        public void setUser(String author) {
            this.author = User.get((String)author);
        }

        @Exported
        public String getUser() {
            return this.author != null ? this.author.getDisplayName() : "unknown";
        }

        @Exported
        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void addPath(Path p) {
            p.entry = this;
            this.paths.add(p);
        }

        @Exported
        public List<Path> getPaths() {
            return this.paths;
        }

        public Collection<Path> getAffectedFiles() {
            return this.paths;
        }

        void finish() {
            Collections.sort(this.paths, new Comparator<Path>(){

                @Override
                public int compare(Path o1, Path o2) {
                    String path1 = Util.fixNull((String)o1.getValue());
                    String path2 = Util.fixNull((String)o2.getValue());
                    return path1.compareTo(path2);
                }
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            LogEntry that = (LogEntry)((Object)o);
            if (this.revision != that.revision) {
                return false;
            }
            if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
                return false;
            }
            if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
                return false;
            }
            return !(this.msg != null ? !this.msg.equals(that.msg) : that.msg != null);
        }

        public int hashCode() {
            int result = this.revision;
            result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
            result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
            result = 31 * result + (this.msg != null ? this.msg.hashCode() : 0);
            return result;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static final class RevisionInfo {
        @Exported
        public final String module;
        @Exported
        public final long revision;

        public RevisionInfo(String module, long revision) {
            this.module = module;
            this.revision = revision;
        }
    }
}

