/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BaseSSHUser;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.Messages;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.io.FileUtils;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSSHUserPrivateKey
extends BaseSSHUser
implements SSHUserPrivateKey {
    private static final long serialVersionUID = 1L;
    private final Secret passphrase;
    private final PrivateKeySource privateKeySource;
    @GuardedBy(value="this")
    private transient List<String> privateKeys;
    @GuardedBy(value="this")
    private transient long privateKeysLastModified;

    @DataBoundConstructor
    public BasicSSHUserPrivateKey(CredentialsScope scope, String id, String username, PrivateKeySource privateKeySource, String passphrase, String description) {
        super(scope, id, username, description);
        this.privateKeySource = privateKeySource;
        this.passphrase = Secret.fromString((String)passphrase);
    }

    @Override
    @NonNull
    public String getPrivateKey() {
        List<String> privateKeys = this.getPrivateKeys();
        return privateKeys.isEmpty() ? "" : privateKeys.get(0);
    }

    @Override
    @NonNull
    public synchronized List<String> getPrivateKeys() {
        long lastModified = this.privateKeySource.getPrivateKeysLastModified();
        if (this.privateKeys == null || this.privateKeys.isEmpty() || lastModified > this.privateKeysLastModified) {
            ArrayList<String> privateKeys = new ArrayList<String>();
            for (String privateKey : this.privateKeySource.getPrivateKeys()) {
                try {
                    if (PuTTYKey.isPuTTYKeyFile((Reader)new StringReader(privateKey))) {
                        privateKeys.add(new PuTTYKey((Reader)new StringReader(privateKey), this.passphrase == null ? "" : this.passphrase.getPlainText()).toOpenSSH());
                        continue;
                    }
                    privateKeys.add(privateKey);
                }
                catch (IOException e) {}
            }
            this.privateKeys = privateKeys;
            this.privateKeysLastModified = lastModified;
        }
        return this.privateKeys;
    }

    @NonNull
    public PrivateKeySource getPrivateKeySource() {
        return this.privateKeySource;
    }

    @Override
    @NonNull
    public Secret getPassphrase() {
        return this.passphrase;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyLastModifiedOnMaster
    implements FilePath.FileCallable<Long> {
        private static final long serialVersionUID = 2L;

        public Long invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            long lastModified = Long.MIN_VALUE;
            File sshHome = new File(new File(System.getProperty("user.home")), ".ssh");
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                File file = new File(sshHome, keyName);
                if (!file.exists()) continue;
                lastModified = Math.max(lastModified, file.lastModified());
            }
            return lastModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LastModifiedOnMaster
    implements FilePath.FileCallable<Long> {
        private static final long serialVersionUID = 2L;
        private final List<String> files;

        public LastModifiedOnMaster(String ... files) {
            this(Arrays.asList(files));
        }

        public LastModifiedOnMaster(List<String> files) {
            this.files = new ArrayList<String>(files);
        }

        public Long invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            long lastModified = Long.MIN_VALUE;
            for (String path : this.files) {
                File file = new File(path);
                if (!file.exists()) continue;
                lastModified = Math.max(lastModified, file.lastModified());
            }
            return lastModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReadKeyOnMaster
    implements FilePath.FileCallable<List<String>> {
        private static final long serialVersionUID = 2L;

        public List<String> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            ArrayList<String> result = new ArrayList<String>();
            File sshHome = new File(new File(System.getProperty("user.home")), ".ssh");
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                File key = new File(sshHome, keyName);
                if (!key.isFile()) continue;
                result.add(FileUtils.readFileToString((File)key));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReadFileOnMaster
    implements FilePath.FileCallable<String> {
        private static final long serialVersionUID = 1L;
        private final String path;

        public ReadFileOnMaster(String path) {
            this.path = path;
        }

        public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            File key = new File(this.path);
            if (key.isFile()) {
                return FileUtils.readFileToString((File)key);
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UsersPrivateKeySource
    extends PrivateKeySource {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(UsersPrivateKeySource.class.getName());
        private volatile transient long lastModified;
        private volatile transient long nextCheckLastModified;

        @DataBoundConstructor
        public UsersPrivateKeySource() {
        }

        @Override
        @NonNull
        public List<String> getPrivateKeys() {
            try {
                return (List)Hudson.getInstance().getRootPath().act((FilePath.FileCallable)new ReadKeyOnMaster());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not read private key", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Could not read private key", e);
            }
            return Collections.emptyList();
        }

        @Override
        public long getPrivateKeysLastModified() {
            if (this.nextCheckLastModified > System.currentTimeMillis() || this.lastModified < 0L) {
                try {
                    this.lastModified = (Long)Hudson.getInstance().getRootPath().act((FilePath.FileCallable)new KeyLastModifiedOnMaster());
                }
                catch (NullPointerException e) {
                    LOGGER.log(Level.WARNING, "Could not stat private keys", e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not stat private keys", e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Could not stat private keys", e);
                }
                this.nextCheckLastModified = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
            }
            return this.lastModified;
        }

        @Extension
        public static class DescriptorImpl
        extends PrivateKeySourceDescriptor {
            public String getDisplayName() {
                return Messages.BasicSSHUserPrivateKey_UsersPrivateKeySourceDisplayName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileOnMasterPrivateKeySource
    extends PrivateKeySource {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterPrivateKeySource.class.getName());
        private final String privateKeyFile;
        private volatile transient long lastModified;
        private volatile transient long nextCheckLastModified;

        @DataBoundConstructor
        public FileOnMasterPrivateKeySource(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        @Override
        @NonNull
        public List<String> getPrivateKeys() {
            try {
                return Collections.singletonList(Hudson.getInstance().getRootPath().act((FilePath.FileCallable)new ReadFileOnMaster(this.privateKeyFile)));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not read private key file " + this.privateKeyFile, e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Could not read private key file " + this.privateKeyFile, e);
            }
            return Collections.emptyList();
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        private Object readResolve() {
            if (this.privateKeyFile != null && this.privateKeyFile.startsWith("---") && this.privateKeyFile.contains("---BEGIN") && this.privateKeyFile.contains("---END")) {
                return new DirectEntryPrivateKeySource(this.privateKeyFile);
            }
            return this;
        }

        @Override
        public long getPrivateKeysLastModified() {
            if (this.nextCheckLastModified > System.currentTimeMillis() || this.lastModified < 0L) {
                try {
                    this.lastModified = (Long)Hudson.getInstance().getRootPath().act((FilePath.FileCallable)new LastModifiedOnMaster(this.privateKeyFile));
                }
                catch (NullPointerException e) {
                    LOGGER.log(Level.WARNING, "Could not stat private key file " + this.privateKeyFile, e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not stat private key file " + this.privateKeyFile, e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Could not stat private key file " + this.privateKeyFile, e);
                }
                this.nextCheckLastModified = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
            }
            return this.lastModified;
        }

        @Extension
        public static class DescriptorImpl
        extends PrivateKeySourceDescriptor {
            public String getDisplayName() {
                return Messages.BasicSSHUserPrivateKey_FileOnMasterPrivateKeySourceDisplayName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectEntryPrivateKeySource
    extends PrivateKeySource {
        private static final long serialVersionUID = 1L;
        private final String privateKey;

        @DataBoundConstructor
        public DirectEntryPrivateKeySource(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        @NonNull
        public List<String> getPrivateKeys() {
            return Collections.singletonList(this.privateKey);
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        @Extension
        public static class DescriptorImpl
        extends PrivateKeySourceDescriptor {
            public String getDisplayName() {
                return Messages.BasicSSHUserPrivateKey_DirectEntryPrivateKeySourceDisplayName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PrivateKeySourceDescriptor
    extends Descriptor<PrivateKeySource> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PrivateKeySource
    extends AbstractDescribableImpl<PrivateKeySource>
    implements Serializable {
        @NonNull
        public abstract List<String> getPrivateKeys();

        public long getPrivateKeysLastModified() {
            return 1L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.BasicSSHUserPrivateKey_DisplayName();
        }

        public DescriptorExtensionList<PrivateKeySource, Descriptor<PrivateKeySource>> getPrivateKeySources() {
            return Hudson.getInstance().getDescriptorList(PrivateKeySource.class);
        }

        public BasicSSHUserPrivateKey fixInstance(BasicSSHUserPrivateKey instance) {
            return instance == null ? new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, null, "", new DirectEntryPrivateKeySource(""), "", "") : instance;
        }
    }
}

