/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshcredentials.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorException;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.JSchConnector;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.TrileadSSHPublicKeyAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.jcraft.jsch.JSchException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.util.Secret;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSchSSHPublicKeyAuthenticator
extends SSHAuthenticator<JSchConnector, SSHUserPrivateKey> {
    private static final Logger LOGGER = Logger.getLogger(TrileadSSHPublicKeyAuthenticator.class.getName());

    public JSchSSHPublicKeyAuthenticator(JSchConnector connector, SSHUserPrivateKey user) {
        this(connector, user, (String)null);
    }

    public JSchSSHPublicKeyAuthenticator(@NonNull JSchConnector connector, @NonNull SSHUserPrivateKey user, @CheckForNull String username) {
        super(connector, user, username);
    }

    @Override
    public boolean canAuthenticate() {
        return !((JSchConnector)this.getConnection()).hasSession() || ((JSchConnector)this.getConnection()).getSession().isConnected() && ((JSchConnector)this.getConnection()).getSession().getUserInfo() == null;
    }

    @Override
    protected boolean doAuthenticate() {
        try {
            SSHUserPrivateKey user = (SSHUserPrivateKey)this.getUser();
            Secret userPassphrase = user.getPassphrase();
            String passphrase = userPassphrase == null ? null : userPassphrase.getPlainText();
            byte[] passphraseBytes = passphrase == null ? null : passphrase.getBytes("UTF-8");
            for (String privateKey : JSchSSHPublicKeyAuthenticator.getPrivateKeys(user)) {
                ((JSchConnector)this.getConnection()).getJSch().addIdentity(this.getUsername(), privateKey.getBytes("UTF-8"), null, passphraseBytes);
            }
            return true;
        }
        catch (JSchException e) {
            e.printStackTrace(this.getListener().error("Failed to authenticate with public key"));
            return false;
        }
        catch (UnsupportedEncodingException e) {
            throw new SSHAuthenticatorException(e);
        }
    }

    @Override
    @NonNull
    public SSHAuthenticator.Mode getAuthenticationMode() {
        return SSHAuthenticator.Mode.BEFORE_CONNECT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        @Override
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C session, @NonNull U user) {
            return this.newInstance(session, user, null);
        }

        @Override
        @Nullable
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C session, @NonNull U user, @CheckForNull String username) {
            if (this.supports(session.getClass(), user.getClass())) {
                return new JSchSSHPublicKeyAuthenticator((JSchConnector)session, (SSHUserPrivateKey)user, username);
            }
            return null;
        }

        @Override
        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return JSchConnector.class.isAssignableFrom(connectionClass) && SSHUserPrivateKey.class.isAssignableFrom(userClass);
        }
    }
}

