/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GroovySystem;
import hudson.util.VersionNumber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;

public final class StaticWhitelist
extends EnumeratingWhitelist {
    static final boolean GROOVY2 = new VersionNumber(GroovySystem.getVersion()).compareTo(new VersionNumber("2")) >= 0;
    final List<EnumeratingWhitelist.MethodSignature> methodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    final List<EnumeratingWhitelist.NewSignature> newSignatures = new ArrayList<EnumeratingWhitelist.NewSignature>();
    final List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    final List<EnumeratingWhitelist.FieldSignature> fieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    final List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    private static final Set<String> BLACKLIST;

    public StaticWhitelist(Reader definition) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(definition);
        while ((line = br.readLine()) != null) {
            if ((line = StaticWhitelist.filter(line)) == null) continue;
            this.add(line);
        }
    }

    public StaticWhitelist(Collection<? extends String> lines) throws IOException {
        for (String string : lines) {
            this.add(string);
        }
    }

    public StaticWhitelist(String ... lines) throws IOException {
        this(Arrays.asList(lines));
    }

    @CheckForNull
    static String filter(@Nonnull String line) {
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return null;
        }
        return line;
    }

    static EnumeratingWhitelist.Signature parse(String line) throws IOException {
        String[] toks = line.split(" ");
        if (toks[0].equals("method")) {
            if (toks.length < 3) {
                throw new IOException(line);
            }
            return new EnumeratingWhitelist.MethodSignature(toks[1], toks[2], Arrays.copyOfRange(toks, 3, toks.length));
        }
        if (toks[0].equals("new")) {
            if (toks.length < 2) {
                throw new IOException(line);
            }
            return new EnumeratingWhitelist.NewSignature(toks[1], Arrays.copyOfRange(toks, 2, toks.length));
        }
        if (toks[0].equals("staticMethod")) {
            if (toks.length < 3) {
                throw new IOException(line);
            }
            return new EnumeratingWhitelist.StaticMethodSignature(toks[1], toks[2], Arrays.copyOfRange(toks, 3, toks.length));
        }
        if (toks[0].equals("field")) {
            if (toks.length != 3) {
                throw new IOException(line);
            }
            return new EnumeratingWhitelist.FieldSignature(toks[1], toks[2]);
        }
        if (toks[0].equals("staticField")) {
            if (toks.length != 3) {
                throw new IOException(line);
            }
            return new EnumeratingWhitelist.StaticFieldSignature(toks[1], toks[2]);
        }
        throw new IOException(line);
    }

    private void add(String line) throws IOException {
        EnumeratingWhitelist.Signature s = StaticWhitelist.parse(line);
        if (s instanceof EnumeratingWhitelist.StaticMethodSignature) {
            this.staticMethodSignatures.add((EnumeratingWhitelist.StaticMethodSignature)s);
        } else if (s instanceof EnumeratingWhitelist.MethodSignature) {
            this.methodSignatures.add((EnumeratingWhitelist.MethodSignature)s);
        } else if (s instanceof EnumeratingWhitelist.StaticFieldSignature) {
            this.staticFieldSignatures.add((EnumeratingWhitelist.StaticFieldSignature)s);
        } else if (s instanceof EnumeratingWhitelist.FieldSignature) {
            this.fieldSignatures.add((EnumeratingWhitelist.FieldSignature)s);
        } else {
            this.newSignatures.add((EnumeratingWhitelist.NewSignature)s);
        }
    }

    public static StaticWhitelist from(URL definition) throws IOException {
        InputStream is = definition.openStream();
        try {
            StaticWhitelist staticWhitelist = new StaticWhitelist(new InputStreamReader(is, "UTF-8"));
            return staticWhitelist;
        }
        finally {
            is.close();
        }
    }

    @Override
    protected List<EnumeratingWhitelist.MethodSignature> methodSignatures() {
        return this.methodSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.NewSignature> newSignatures() {
        return this.newSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures() {
        return this.staticMethodSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.FieldSignature> fieldSignatures() {
        return this.fieldSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures() {
        return this.staticFieldSignatures;
    }

    public static RejectedAccessException rejectMethod(@Nonnull Method m) {
        assert ((m.getModifiers() & 8) == 0);
        return StaticWhitelist.blacklist(new RejectedAccessException("method", EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes())));
    }

    public static RejectedAccessException rejectMethod(@Nonnull Method m, String info) {
        assert ((m.getModifiers() & 8) == 0);
        return StaticWhitelist.blacklist(new RejectedAccessException("method", EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()), info));
    }

    public static RejectedAccessException rejectNew(@Nonnull Constructor<?> c) {
        return StaticWhitelist.blacklist(new RejectedAccessException("new", EnumeratingWhitelist.getName(c.getDeclaringClass()) + StaticWhitelist.printArgumentTypes(c.getParameterTypes())));
    }

    public static RejectedAccessException rejectStaticMethod(@Nonnull Method m) {
        assert ((m.getModifiers() & 8) != 0);
        return StaticWhitelist.blacklist(new RejectedAccessException("staticMethod", EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes())));
    }

    public static RejectedAccessException rejectField(@Nonnull Field f) {
        assert ((f.getModifiers() & 8) == 0);
        return StaticWhitelist.blacklist(new RejectedAccessException("field", EnumeratingWhitelist.getName(f.getDeclaringClass()) + " " + f.getName()));
    }

    public static RejectedAccessException rejectStaticField(@Nonnull Field f) {
        assert ((f.getModifiers() & 8) != 0);
        return StaticWhitelist.blacklist(new RejectedAccessException("staticField", EnumeratingWhitelist.getName(f.getDeclaringClass()) + " " + f.getName()));
    }

    private static String printArgumentTypes(Class<?>[] parameterTypes) {
        StringBuilder b = new StringBuilder();
        for (Class<?> c : parameterTypes) {
            b.append(' ');
            b.append(EnumeratingWhitelist.getName(c));
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="https://sourceforge.net/p/findbugs/bugs/786/")
    private static Set<String> loadBlacklist() throws IOException {
        InputStream is = StaticWhitelist.class.getResourceAsStream("blacklist");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
            HashSet<String> blacklist = new HashSet<String>();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                blacklist.add(line);
            }
            HashSet<String> hashSet = blacklist;
            return hashSet;
        }
        finally {
            is.close();
        }
    }

    private static RejectedAccessException blacklist(RejectedAccessException x) {
        if (BLACKLIST.contains(x.getSignature())) {
            x.setDangerous(true);
        }
        return x;
    }

    static {
        try {
            BLACKLIST = StaticWhitelist.loadBlacklist();
        }
        catch (IOException x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

