/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import hudson.Extension;
import hudson.Util;
import hudson.model.ParameterDefinition;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InputStep
extends AbstractStepImpl
implements Serializable {
    private final String message;
    private String id;
    private String submitter;
    private List<ParameterDefinition> parameters = Collections.emptyList();
    private String ok;

    @DataBoundConstructor
    public InputStep(String message) {
        if (message == null) {
            message = "Pipeline has paused and needs your input before proceeding";
        }
        this.message = message;
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = this.capitalize(Util.fixEmpty((String)id));
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.capitalize(Util.getDigestOf((String)this.message));
        }
        return this.id;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    @DataBoundSetter
    public void setSubmitter(String submitter) {
        this.submitter = Util.fixEmptyAndTrim((String)submitter);
    }

    private String capitalize(String id) {
        if (id == null) {
            return null;
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException();
        }
        char ch = id.charAt(0);
        if ('a' <= ch && ch <= 'z') {
            id = (char)(ch - 97 + 65) + id.substring(1);
        }
        return id;
    }

    public String getOk() {
        return this.ok != null ? this.ok : "Proceed";
    }

    @DataBoundSetter
    public void setOk(String ok) {
        this.ok = Util.fixEmptyAndTrim((String)ok);
    }

    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(List<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public boolean canSubmit() {
        Authentication a = Jenkins.getAuthentication();
        return this.canSettle(a);
    }

    @Deprecated
    public boolean canSettle(Authentication a) {
        if (this.submitter == null || a.getName().equals(this.submitter)) {
            return true;
        }
        for (GrantedAuthority ga : a.getAuthorities()) {
            if (!ga.getAuthority().equals(this.submitter)) continue;
            return true;
        }
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(InputStepExecution.class);
        }

        public String getFunctionName() {
            return "input";
        }

        public String getDisplayName() {
            return "Wait for interactive input";
        }
    }
}

