/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.FilePath;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.jvnet.animal_sniffer.IgnoreJRERequirement;

public class ParameterizedTriggerUtils {
    @IgnoreJRERequirement
    public static Properties loadProperties(String properties) throws IOException {
        Properties p = new Properties();
        try {
            p.load(new StringReader(properties));
        }
        catch (NoSuchMethodError _) {
            p.load((InputStream)new StringInputStream(properties));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(FilePath f, String encoding) throws IOException {
        InputStream in = f.read();
        try {
            String string = IOUtils.toString((InputStream)in, (String)encoding);
            return string;
        }
        finally {
            in.close();
        }
    }

    public static boolean isSupportNonAsciiPropertiesFile() {
        try {
            Properties.class.getMethod("load", Reader.class);
        }
        catch (NoSuchMethodException _) {
            return false;
        }
        return true;
    }

    public static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }
}

