/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SubversionTagAction;
import java.util.ArrayList;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversionRevisionBuildParameters
extends AbstractBuildParameters {
    private boolean includeUpstreamParameters = false;

    public SubversionRevisionBuildParameters() {
        this(false);
    }

    @DataBoundConstructor
    public SubversionRevisionBuildParameters(boolean includeUpstreamParameters) {
        this.includeUpstreamParameters = includeUpstreamParameters;
    }

    public boolean getIncludeUpstreamParameters() {
        return this.includeUpstreamParameters;
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) {
        SubversionTagAction tagAction = (SubversionTagAction)build.getAction(SubversionTagAction.class);
        RevisionParameterAction revisionAction = (RevisionParameterAction)build.getAction(RevisionParameterAction.class);
        ArrayList infos = new ArrayList();
        if (tagAction == null) {
            listener.getLogger().println("[parameterizedtrigger] no SubversionTagAction found -- is this project an SVN project ?");
        } else {
            infos.addAll(tagAction.getTags().keySet());
        }
        if (this.includeUpstreamParameters) {
            if (revisionAction == null) {
                listener.getLogger().println("[parameterizedtrigger] no RevisionParameterAction found -- project did not have SVN parameters passed to it?");
            } else {
                infos.addAll(revisionAction.getRevisions());
            }
        }
        return infos.size() == 0 ? null : new RevisionParameterAction(infos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Subversion revision";
        }
    }
}

