/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.util.EnumConverter;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuildStepHelper;
import org.kohsuke.stapler.Stapler;

public class Plugin
extends hudson.Plugin {
    public void start() throws Exception {
        Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), ResultCondition.class);
    }

    public static boolean isConditionalBuildStepInstalled() {
        hudson.Plugin plugin = Jenkins.getInstance().getPlugin("conditional-buildstep");
        return plugin != null ? plugin.getWrapper().isActive() : false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class RenameListener
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            ItemGroup context = item.getParent();
            String full = StringUtils.isEmpty((String)context.getFullName()) ? "" : context.getFullName() + '/';
            String fullOldName = full + oldName;
            String fullNewName = full + newName;
            for (Project p : Jenkins.getInstance().getAllItems(Project.class)) {
                TriggerBuilder tb;
                boolean changed = false;
                BuildTrigger bt = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                if (bt != null) {
                    for (BuildTriggerConfig c : bt.getConfigs()) {
                        changed |= c.onJobRenamed(p.getParent(), fullOldName, fullNewName);
                    }
                }
                if ((tb = (TriggerBuilder)p.getBuildersList().get(TriggerBuilder.class)) != null) {
                    for (BuildTriggerConfig buildTriggerConfig : tb.getConfigs()) {
                        changed |= buildTriggerConfig.onJobRenamed(p.getParent(), fullOldName, fullNewName);
                    }
                }
                if (Plugin.isConditionalBuildStepInstalled()) {
                    changed |= this.renameInConditionalBuildStep(p, oldName, newName);
                }
                if (!changed) continue;
                try {
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during rename from " + fullOldName + " to " + fullNewName, e);
                }
            }
        }

        public void onDeleted(Item item) {
            for (Project p : Jenkins.getInstance().getAllItems(Project.class)) {
                TriggerBuilder tb;
                String oldName = item.getFullName();
                boolean changed = false;
                BuildTrigger bt = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                if (bt != null) {
                    ListIterator<BuildTriggerConfig> btc = bt.getConfigs().listIterator();
                    while (btc.hasNext()) {
                        BuildTriggerConfig c = btc.next();
                        if (!c.onDeleted(p.getParent(), oldName)) continue;
                        changed = true;
                        if (c.getProjects().length() != 0) continue;
                        btc.remove();
                    }
                }
                if ((tb = (TriggerBuilder)p.getBuildersList().get(TriggerBuilder.class)) != null) {
                    ListIterator<BlockableBuildTriggerConfig> bbtc = tb.getConfigs().listIterator();
                    while (bbtc.hasNext()) {
                        BuildTriggerConfig c = bbtc.next();
                        if (!c.onDeleted(p.getParent(), oldName)) continue;
                        changed = true;
                        if (c.getProjects().length() != 0) continue;
                        bbtc.remove();
                    }
                }
                if (Plugin.isConditionalBuildStepInstalled()) {
                    changed |= this.deleteInConditionalBuildStep(p, oldName);
                }
                if (!changed) continue;
                try {
                    if (bt != null && bt.getConfigs().isEmpty()) {
                        p.getPublishersList().remove((Object)bt);
                    }
                    if (tb != null && tb.getConfigs().isEmpty()) {
                        p.getBuildersList().remove((Object)tb);
                    }
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during remove of " + oldName, e);
                }
            }
        }

        private boolean renameInConditionalBuildStep(Project<?, ?> p, String oldName, String newName) {
            boolean changed = false;
            List containedBuilders = ConditionalBuildStepHelper.getContainedBuilders(p, TriggerBuilder.class);
            for (TriggerBuilder triggerBuilder : containedBuilders) {
                for (BuildTriggerConfig buildTriggerConfig : triggerBuilder.getConfigs()) {
                    changed |= buildTriggerConfig.onJobRenamed(p.getParent(), oldName, newName);
                }
            }
            return changed;
        }

        private boolean deleteInConditionalBuildStep(Project<?, ?> p, String oldName) {
            boolean changed = false;
            List containedBuilders = ConditionalBuildStepHelper.getContainedBuilders(p, TriggerBuilder.class);
            for (TriggerBuilder triggerBuilder : containedBuilders) {
                ListIterator<BlockableBuildTriggerConfig> bbtc = triggerBuilder.getConfigs().listIterator();
                while (bbtc.hasNext()) {
                    BuildTriggerConfig c = bbtc.next();
                    if (!c.onDeleted(p.getParent(), oldName)) continue;
                    changed = true;
                    if (c.getProjects().length() != 0) continue;
                    bbtc.remove();
                }
            }
            return changed;
        }
    }
}

