/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BlockingBehaviour;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.DifferentiatingAction;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockableBuildTriggerConfig
extends BuildTriggerConfig {
    private final BlockingBehaviour block;
    public boolean buildAllNodesWithLabel;

    public BlockableBuildTriggerConfig(String projects, BlockingBehaviour block, List<AbstractBuildParameters> configs) {
        super(projects, ResultCondition.ALWAYS, false, configs);
        this.block = block;
    }

    @DataBoundConstructor
    public BlockableBuildTriggerConfig(String projects, BlockingBehaviour block, List<AbstractBuildParameterFactory> configFactories, List<AbstractBuildParameters> configs) {
        super(projects, ResultCondition.ALWAYS, false, configFactories, configs);
        this.block = block;
    }

    public BlockingBehaviour getBlock() {
        return this.block;
    }

    @Override
    public List<Future<AbstractBuild>> perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        List<Future<AbstractBuild>> r = super.perform(build, launcher, listener);
        if (this.block == null) {
            return Collections.emptyList();
        }
        return r;
    }

    @Override
    public ListMultimap<AbstractProject, Future<AbstractBuild>> perform2(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ListMultimap<AbstractProject, Future<AbstractBuild>> futures = super.perform2(build, launcher, listener);
        if (this.block == null) {
            return ArrayListMultimap.create();
        }
        return futures;
    }

    @Override
    protected Future schedule(AbstractBuild<?, ?> build, AbstractProject project, List<Action> list) throws InterruptedException, IOException {
        if (this.block != null) {
            while (true) {
                Future f;
                if ((f = this.schedule(build, project, 0, (List<Action>)(list = ImmutableList.builder().addAll(list).add((Object)new DifferentiatingAction()).build()))) != null || f == null && !project.isBuildable()) {
                    return f;
                }
                Thread.sleep(1000L);
            }
        }
        return super.schedule(build, project, (List<Action>)list);
    }

    public Collection<Node> getNodes() {
        return Hudson.getInstance().getLabel("asrt").getNodes();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTriggerConfig.DescriptorImpl {
    }
}

