/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.eclipse.jgit.lib.ObjectId;

public class ObjectIdConverter
implements Converter {
    private final Base64Encoder base64 = new Base64Encoder();

    public boolean canConvert(Class type) {
        return ObjectId.class == type;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(((ObjectId)source).name());
    }

    protected boolean isLegacyNode(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return reader.hasMoreChildren() && "byte-array".equals(reader.peekNextChild());
    }

    protected Object legacyUnmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        ObjectId sha1 = ObjectId.fromRaw((byte[])this.base64.decode(reader.getValue()));
        reader.moveUp();
        return sha1;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (this.isLegacyNode(reader, context)) {
            return this.legacyUnmarshal(reader, context);
        }
        return ObjectId.fromString((String)reader.getValue());
    }
}

