/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitTool
extends ToolInstallation
implements NodeSpecific<GitTool>,
EnvironmentSpecific<GitTool> {
    public static final transient String DEFAULT = "Default";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitTool.class.getName());

    @DataBoundConstructor
    public GitTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getGitExe() {
        return this.getHome();
    }

    private static GitTool[] getInstallations(DescriptorImpl descriptor) {
        GitTool[] installations = null;
        try {
            installations = (GitTool[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new GitTool[]{};
        }
        return installations;
    }

    public static GitTool getDefaultInstallation() {
        DescriptorImpl gitTools = (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
        GitTool tool = gitTools.getInstallation(DEFAULT);
        if (tool != null) {
            return tool;
        }
        GitTool[] installations = (GitTool[])gitTools.getInstallations();
        if (installations.length > 0) {
            return installations[0];
        }
        GitTool.onLoaded();
        return ((GitTool[])gitTools.getInstallations())[0];
    }

    public GitTool forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GitTool(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public GitTool forEnvironment(EnvVars environment) {
        return new GitTool(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void onLoaded() {
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.getInstance().getDescriptor(GitTool.class);
        GitTool[] installations = GitTool.getInstallations(descriptor);
        if (installations != null && installations.length > 0) {
            return;
        }
        String defaultGitExe = Functions.isWindows() ? "git.exe" : "git";
        GitTool tool = new GitTool(DEFAULT, defaultGitExe, Collections.emptyList());
        descriptor.setInstallations(new GitTool[]{tool});
        descriptor.save();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<GitTool> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setInstallations(req.bindJSONToList(this.clazz, json.get("tool")).toArray(new GitTool[0]));
            this.save();
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            String path = value.getPath();
            return FormValidation.validateExecutable((String)path);
        }

        public GitTool getInstallation(String name) {
            for (GitTool i : (GitTool[])this.getInstallations()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            if (name.length() > 0) {
                LOGGER.log(Level.WARNING, "invalid gitTool selection {0}", name);
            }
            return null;
        }

        public List<ToolDescriptor<? extends GitTool>> getApplicableDesccriptors() {
            ArrayList<ToolDescriptor<? extends GitTool>> r = new ArrayList<ToolDescriptor<? extends GitTool>>();
            for (ToolDescriptor td : Jenkins.getInstance().getDescriptorList(ToolInstallation.class)) {
                if (!GitTool.class.isAssignableFrom(td.clazz)) continue;
                r.add((ToolDescriptor<? extends GitTool>)td);
            }
            return r;
        }
    }
}

