/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinjectapi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectException;

public class EnvInjectVarsIO {
    private static final String ENVINJECT_TXT_FILENAME = "injectedEnvVars.txt";
    private static final String TOKEN = "=";

    private EnvInjectVarsIO() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static Map<String, String> getEnvironment(@Nonnull File envInjectBaseDir) throws EnvInjectException {
        File f = new File(envInjectBaseDir, ENVINJECT_TXT_FILENAME);
        if (!f.exists()) {
            return null;
        }
        try (BufferedReader fileReader = Files.newBufferedReader(f.toPath(), Charset.defaultCharset());){
            HashMap<String, String> result = new HashMap<String, String>();
            EnvInjectVarsIO.fromTxt(fileReader, result);
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException | InvalidPathException fne) {
            throw new EnvInjectException((Throwable)fne);
        }
    }

    public static void saveEnvironment(@Nonnull File rootDir, @Nonnull Map<String, String> envMap) throws EnvInjectException {
        File f = new File(rootDir, ENVINJECT_TXT_FILENAME);
        try (BufferedWriter wr = Files.newBufferedWriter(f.toPath(), Charset.defaultCharset(), new OpenOption[0]);){
            TreeMap<String, String> map2Write = new TreeMap<String, String>();
            map2Write.putAll(envMap);
            EnvInjectVarsIO.toTxt(map2Write, wr);
        }
        catch (IOException | InvalidPathException ex) {
            throw new EnvInjectException((Throwable)ex);
        }
    }

    private static void fromTxt(@Nonnull Reader reader, @Nonnull Map<String, String> result) throws EnvInjectException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, TOKEN);
                int tokens = tokenizer.countTokens();
                if (tokens != 2) continue;
                result.put(String.valueOf(tokenizer.nextElement()), String.valueOf(tokenizer.nextElement()));
            }
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException ioe) {
                throw new EnvInjectException((Throwable)ioe);
            }
        }
    }

    private static void toTxt(@Nonnull Map<String, String> envMap, @Nonnull Writer fw) throws IOException {
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            fw.write(String.format("%s%s%s%n", entry.getKey(), TOKEN, entry.getValue()));
        }
    }
}

