/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinjectapi.util;

import hudson.model.Action;
import hudson.model.Run;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EnvInjectActionRetriever {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectActionRetriever.class.getName());

    private EnvInjectActionRetriever() {
    }

    @CheckForNull
    public static Action getEnvInjectAction(@Nonnull Run<?, ?> run) {
        try {
            Method method;
            Object object;
            Class<?> matrixClass = Class.forName("hudson.matrix.MatrixRun");
            if (matrixClass.isInstance(run) && (object = (method = matrixClass.getMethod("getParentBuild", null)).invoke(run, new Object[0])) instanceof Run) {
                run = (Run)object;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.FINEST, "hudson.matrix.MatrixRun is not installed", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.WARNING, "The method getParentBuild does not exist for hudson.matrix.MatrixRun", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.WARNING, "There was a problem in the invocation of getParentBuild in hudson.matrix.MatrixRun", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "There was a problem in the invocation of getParentBuild in hudson.matrix.MatrixRun", e);
        }
        List actions = run.getActions();
        for (Action action : actions) {
            if (action == null || !"injectedEnvVars".equals(action.getUrlName())) continue;
            return action;
        }
        return null;
    }
}

